/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.regex.Pattern;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.ml.clustering.LDA;
import org.apache.spark.ml.clustering.LDAModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.expressions.GenericRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaLDAExample {
    public static void main(String[] args) {
        String inputFile = "data/mllib/sample_lda_data.txt";
        SparkConf conf = new SparkConf().setAppName("JavaLDAExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        SQLContext sqlContext = new SQLContext(jsc);
        JavaRDD points = jsc.textFile(inputFile).map((Function)new ParseVector());
        StructField[] fields = new StructField[]{new StructField("features", (DataType)new VectorUDT(), false, Metadata.empty())};
        StructType schema = new StructType(fields);
        DataFrame dataset = sqlContext.createDataFrame(points, schema);
        LDA lda = new LDA().setK(10).setMaxIter(10);
        LDAModel model = lda.fit(dataset);
        System.out.println(model.logLikelihood(dataset));
        System.out.println(model.logPerplexity(dataset));
        DataFrame topics = model.describeTopics(3);
        topics.show(false);
        model.transform(dataset).show(false);
        jsc.stop();
    }

    private static class ParseVector
    implements Function<String, Row> {
        private static final Pattern separator = Pattern.compile(" ");

        private ParseVector() {
        }

        public Row call(String line) {
            String[] tok = separator.split(line);
            double[] point = new double[tok.length];
            for (int i = 0; i < tok.length; ++i) {
                point[i] = Double.parseDouble(tok[i]);
            }
            Object[] points = new Vector[]{Vectors.dense((double[])point)};
            return new GenericRow(points);
        }
    }
}

