/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import com.twitter.algebird.CMSHasher;
import com.twitter.algebird.CMSHasherImplicits;
import com.twitter.algebird.MapMonoid;
import com.twitter.algebird.Semigroup$;
import com.twitter.algebird.TopCMS;
import com.twitter.algebird.TopPctCMS$;
import com.twitter.algebird.TopPctCMSMonoid;
import org.apache.spark.SparkConf;
import org.apache.spark.examples.streaming.StreamingExamples$;
import org.apache.spark.examples.streaming.TwitterAlgebirdCMS$;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.twitter.TwitterUtils$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import twitter4j.Status;

public final class TwitterAlgebirdCMS$ {
    public static final TwitterAlgebirdCMS$ MODULE$;

    static {
        new TwitterAlgebirdCMS$();
    }

    public void main(String[] args) {
        StreamingExamples$.MODULE$.setStreamingLogLevels();
        double DELTA = 0.001;
        double EPS = 0.01;
        int SEED = 1;
        double PERC = 0.001;
        int TOPK = 10;
        String[] filters = args;
        SparkConf sparkConf = new SparkConf().setAppName("TwitterAlgebirdCMS");
        StreamingContext ssc = new StreamingContext(sparkConf, Seconds$.MODULE$.apply(10L));
        ReceiverInputDStream stream = TwitterUtils$.MODULE$.createStream(ssc, (Option)None$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])filters), StorageLevel$.MODULE$.MEMORY_ONLY_SER_2());
        DStream users = stream.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Status status) {
                return status.getUser().getId();
            }
        }, ClassTag$.MODULE$.Long());
        TopPctCMSMonoid cms = TopPctCMS$.MODULE$.monoid(EPS, DELTA, SEED, PERC, (Ordering)Ordering.Long$.MODULE$, (CMSHasher)CMSHasherImplicits.CMSHasherLong$.MODULE$);
        ObjectRef globalCMS = new ObjectRef((Object)cms.zero());
        MapMonoid mm = new MapMonoid(Semigroup$.MODULE$.intSemigroup());
        ObjectRef globalExact = new ObjectRef((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        DStream approxTopUsers = users.mapPartitions((Function1)new Serializable(cms){
            public static final long serialVersionUID = 0L;
            public final TopPctCMSMonoid cms$1;

            public final Iterator<TopCMS<Object>> apply(Iterator<Object> ids) {
                return ids.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.3 $outer;

                    public final TopCMS<Object> apply(long id) {
                        return this.$outer.cms$1.create((Object)BoxesRunTime.boxToLong((long)id));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.cms$1 = cms$1;
            }
        }, users.mapPartitions$default$2(), ClassTag$.MODULE$.apply(TopCMS.class)).reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TopCMS<Object> apply(TopCMS<Object> x$1, TopCMS<Object> x$2) {
                return (TopCMS)x$1.$plus$plus(x$2);
            }
        });
        DStream exactTopUsers = DStream$.MODULE$.toPairDStreamFunctions(users.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(long id) {
                return new Tuple2.mcJI.sp(id, 1);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Long$.MODULE$).reduceByKey((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int a, int b) {
                return this.apply$mcIII$sp(a, b);
            }

            public int apply$mcIII$sp(int a, int b) {
                return a + b;
            }
        });
        approxTopUsers.foreachRDD((Function1)new Serializable(PERC, TOPK, globalCMS){
            public static final long serialVersionUID = 0L;
            private final double PERC$1;
            private final int TOPK$1;
            public final ObjectRef globalCMS$1;

            public final void apply(RDD<TopCMS<Object>> rdd) {
                if (rdd.count() != 0L) {
                    TopCMS partial = (TopCMS)rdd.first();
                    Seq partialTopK = (Seq)((IterableLike)((SeqLike)((SetLike)partial.heavyHitters().map((Function1)new Serializable(this, partial){
                        public static final long serialVersionUID = 0L;
                        private final TopCMS partial$1;

                        public final Tuple2<Object, Object> apply(long id) {
                            return new Tuple2.mcJJ.sp(id, BoxesRunTime.unboxToLong((Object)this.partial$1.frequency((Object)BoxesRunTime.boxToLong((long)id)).estimate()));
                        }
                        {
                            this.partial$1 = partial$1;
                        }
                    }, Set$.MODULE$.canBuildFrom())).toSeq().sortBy((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Tuple2<Object, Object> x$3) {
                            return x$3._2$mcJ$sp();
                        }
                    }, (Ordering)Ordering.Long$.MODULE$)).reverse()).slice(0, this.TOPK$1);
                    this.globalCMS$1.elem = (TopCMS)((TopCMS)this.globalCMS$1.elem).$plus$plus((Object)partial);
                    Seq globalTopK = (Seq)((IterableLike)((SeqLike)((SetLike)((TopCMS)this.globalCMS$1.elem).heavyHitters().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.main.1 $outer;

                        public final Tuple2<Object, Object> apply(long id) {
                            return new Tuple2.mcJJ.sp(id, BoxesRunTime.unboxToLong((Object)((TopCMS)this.$outer.globalCMS$1.elem).frequency((Object)BoxesRunTime.boxToLong((long)id)).estimate()));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, Set$.MODULE$.canBuildFrom())).toSeq().sortBy((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Tuple2<Object, Object> x$4) {
                            return x$4._2$mcJ$sp();
                        }
                    }, (Ordering)Ordering.Long$.MODULE$)).reverse()).slice(0, this.TOPK$1);
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Approx heavy hitters at %2.2f%% threshold this batch: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.PERC$1), partialTopK.mkString("[", ",", "]")})));
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Approx heavy hitters at %2.2f%% threshold overall: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.PERC$1), globalTopK.mkString("[", ",", "]")})));
                }
            }
            {
                this.PERC$1 = PERC$1;
                this.TOPK$1 = TOPK$1;
                this.globalCMS$1 = globalCMS$1;
            }
        });
        exactTopUsers.foreachRDD((Function1)new Serializable(TOPK, mm, globalExact){
            public static final long serialVersionUID = 0L;
            private final int TOPK$1;
            private final MapMonoid mm$1;
            private final ObjectRef globalExact$1;

            public final void apply(RDD<Tuple2<Object, Object>> rdd) {
                if (rdd.count() != 0L) {
                    scala.collection.immutable.Map partialMap = Predef$.MODULE$.refArrayOps((Object[])rdd.collect()).toMap(Predef$.MODULE$.conforms());
                    OrderedRDDFunctions qual$1 = RDD$.MODULE$.rddToOrderedRDDFunctions(rdd.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$1) {
                            Tuple2<Object, Object> tuple2 = x0$1;
                            if (tuple2 != null) {
                                long id = tuple2._1$mcJ$sp();
                                int count = tuple2._2$mcI$sp();
                                Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(count, id);
                                return sp2;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, ClassTag$.MODULE$.apply(Tuple2.class)), (Ordering)Ordering.Int$.MODULE$, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Long());
                    boolean x$6 = false;
                    int x$7 = qual$1.sortByKey$default$2();
                    Tuple2[] partialTopK = (Tuple2[])qual$1.sortByKey(x$6, x$7).take(this.TOPK$1);
                    this.globalExact$1.elem = (scala.collection.immutable.Map)this.mm$1.plus((Map)((scala.collection.immutable.Map)this.globalExact$1.elem).toMap(Predef$.MODULE$.conforms()), (Map)partialMap);
                    Seq globalTopK = (Seq)((IterableLike)((SeqLike)((scala.collection.immutable.Map)this.globalExact$1.elem).toSeq().sortBy((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(Tuple2<Object, Object> x$5) {
                            return x$5._2$mcI$sp();
                        }
                    }, (Ordering)Ordering.Int$.MODULE$)).reverse()).slice(0, this.TOPK$1);
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Exact heavy hitters this batch: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])partialTopK).mkString("[", ",", "]")})));
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Exact heavy hitters overall: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{globalTopK.mkString("[", ",", "]")})));
                }
            }
            {
                this.TOPK$1 = TOPK$1;
                this.mm$1 = mm$1;
                this.globalExact$1 = globalExact$1;
            }
        });
        ssc.start();
        ssc.awaitTermination();
    }

    private TwitterAlgebirdCMS$() {
        MODULE$ = this;
    }
}

