/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.fpm.AssociationRules;
import org.apache.spark.mllib.fpm.FPGrowth;
import org.apache.spark.mllib.fpm.FPGrowthModel;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class SimpleFPGrowth$ {
    public static final SimpleFPGrowth$ MODULE$;

    static {
        new SimpleFPGrowth$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("SimpleFPGrowth");
        SparkContext sc = new SparkContext(conf);
        RDD data = sc.textFile("data/mllib/sample_fpgrowth.txt", sc.textFile$default$2());
        RDD transactions = data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String s) {
                return new StringOps(Predef$.MODULE$.augmentString(s.trim())).split(' ');
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        FPGrowth fpg = new FPGrowth().setMinSupport(0.2).setNumPartitions(10);
        FPGrowthModel model = fpg.run(transactions, ClassTag$.MODULE$.apply(String.class));
        Predef$.MODULE$.refArrayOps((Object[])model.freqItemsets().collect()).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(FPGrowth.FreqItemset<String> itemset) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)Predef$.MODULE$.refArrayOps((Object[])itemset.items()).mkString("[", ",", "]")).append((Object)", ").append((Object)BoxesRunTime.boxToLong((long)itemset.freq())).toString());
            }
        });
        double minConfidence = 0.8;
        Predef$.MODULE$.refArrayOps((Object[])model.generateAssociationRules(minConfidence).collect()).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(AssociationRules.Rule<String> rule) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)Predef$.MODULE$.refArrayOps((Object[])rule.antecedent()).mkString("[", ",", "]")).append((Object)" => ").append((Object)Predef$.MODULE$.refArrayOps((Object[])rule.consequent()).mkString("[", ",", "]")).append((Object)", ").append((Object)BoxesRunTime.boxToDouble((double)rule.confidence())).toString());
            }
        });
    }

    private SimpleFPGrowth$() {
        MODULE$ = this;
    }
}

