/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaDoubleRDD;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.recommendation.ALS;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.rdd.RDD;
import scala.Tuple2;

public class JavaRecommendationExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("Java Collaborative Filtering Example");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        String path = "data/mllib/als/test.data";
        JavaRDD data = jsc.textFile(path);
        JavaRDD ratings = data.map((Function)new Function<String, Rating>(){

            public Rating call(String s) {
                String[] sarray = s.split(",");
                return new Rating(Integer.parseInt(sarray[0]), Integer.parseInt(sarray[1]), Double.parseDouble(sarray[2]));
            }
        });
        int rank = 10;
        int numIterations = 10;
        MatrixFactorizationModel model = ALS.train((RDD)JavaRDD.toRDD((JavaRDD)ratings), (int)rank, (int)numIterations, (double)0.01);
        JavaRDD userProducts = ratings.map((Function)new Function<Rating, Tuple2<Object, Object>>(){

            public Tuple2<Object, Object> call(Rating r) {
                return new Tuple2((Object)r.user(), (Object)r.product());
            }
        });
        JavaPairRDD predictions = JavaPairRDD.fromJavaRDD((JavaRDD)model.predict(JavaRDD.toRDD((JavaRDD)userProducts)).toJavaRDD().map((Function)new Function<Rating, Tuple2<Tuple2<Integer, Integer>, Double>>(){

            public Tuple2<Tuple2<Integer, Integer>, Double> call(Rating r) {
                return new Tuple2((Object)new Tuple2((Object)r.user(), (Object)r.product()), (Object)r.rating());
            }
        }));
        JavaRDD ratesAndPreds = JavaPairRDD.fromJavaRDD((JavaRDD)ratings.map((Function)new Function<Rating, Tuple2<Tuple2<Integer, Integer>, Double>>(){

            public Tuple2<Tuple2<Integer, Integer>, Double> call(Rating r) {
                return new Tuple2((Object)new Tuple2((Object)r.user(), (Object)r.product()), (Object)r.rating());
            }
        })).join(predictions).values();
        double MSE = JavaDoubleRDD.fromRDD((RDD)ratesAndPreds.map((Function)new Function<Tuple2<Double, Double>, Object>(){

            public Object call(Tuple2<Double, Double> pair) {
                Double err = (Double)pair._1() - (Double)pair._2();
                return err * err;
            }
        }).rdd()).mean();
        System.out.println("Mean Squared Error = " + MSE);
        model.save(jsc.sc(), "target/tmp/myCollaborativeFilter");
        MatrixFactorizationModel sameModel = MatrixFactorizationModel.load((SparkContext)jsc.sc(), (String)"target/tmp/myCollaborativeFilter");
    }
}

