/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.fpm.FPGrowth;
import org.apache.spark.mllib.fpm.FPGrowthModel;

public class JavaFPGrowthExample {
    public static void main(String[] args) {
        double minSupport = 0.3;
        int numPartition = -1;
        if (args.length < 1) {
            System.err.println("Usage: JavaFPGrowth <input_file> [minSupport] [numPartition]");
            System.exit(1);
        }
        String inputFile = args[0];
        if (args.length >= 2) {
            minSupport = Double.parseDouble(args[1]);
        }
        if (args.length >= 3) {
            numPartition = Integer.parseInt(args[2]);
        }
        SparkConf sparkConf = new SparkConf().setAppName("JavaFPGrowthExample");
        JavaSparkContext sc = new JavaSparkContext(sparkConf);
        JavaRDD transactions = sc.textFile(inputFile).map((Function)new Function<String, ArrayList<String>>(){

            public ArrayList<String> call(String s) {
                return Lists.newArrayList((Object[])s.split(" "));
            }
        });
        FPGrowthModel model = new FPGrowth().setMinSupport(minSupport).setNumPartitions(numPartition).run(transactions);
        for (FPGrowth.FreqItemset s : model.freqItemsets().toJavaRDD().collect()) {
            System.out.println("[" + Joiner.on((String)",").join((Iterable)s.javaItems()) + "], " + s.freq());
        }
        sc.stop();
    }
}

