/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.CosineSimilarity;
import org.apache.spark.examples.mllib.CosineSimilarity$Params$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.distributed.CoordinateMatrix;
import org.apache.spark.mllib.linalg.distributed.MatrixEntry;
import org.apache.spark.mllib.linalg.distributed.RowMatrix;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scopt.OptionParser;
import scopt.Read$;

public final class CosineSimilarity$ {
    public static final CosineSimilarity$ MODULE$;

    static {
        new CosineSimilarity$();
    }

    public void main(String[] args) {
        CosineSimilarity.Params defaultParams = new CosineSimilarity.Params(CosineSimilarity$Params$.MODULE$.apply$default$1(), CosineSimilarity$Params$.MODULE$.apply$default$2());
        OptionParser<CosineSimilarity.Params> parser = new OptionParser<CosineSimilarity.Params>(){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CosineSimilarity: an example app."}));
                this.opt("threshold", Read$.MODULE$.doubleRead()).required().text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"threshold similarity: to tradeoff computation vs quality estimate"})).s((Seq)Nil$.MODULE$)).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CosineSimilarity.Params apply(double x, CosineSimilarity.Params c) {
                        double x$2 = x;
                        String x$3 = c.copy$default$1();
                        return c.copy(x$3, x$2);
                    }
                });
                this.arg("<inputFile>", Read$.MODULE$.stringRead()).required().text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input file, one row per line, space-separated"})).s((Seq)Nil$.MODULE$)).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CosineSimilarity.Params apply(String x, CosineSimilarity.Params c) {
                        return c.copy(x, c.copy$default$2());
                    }
                });
                this.note(new StringOps(Predef$.MODULE$.augmentString("\n          |For example, the following command runs this app on a dataset:\n          |\n          | ./bin/spark-submit  --class org.apache.spark.examples.mllib.CosineSimilarity \\\n          | examplesjar.jar \\\n          | --threshold 0.1 data/mllib/sample_svm_data.txt\n        ")).stripMargin());
            }
        };
        parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(CosineSimilarity.Params params) {
                CosineSimilarity$.MODULE$.run(params);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                System.exit(1);
            }
        });
    }

    public void run(CosineSimilarity.Params params) {
        SparkConf conf = new SparkConf().setAppName("CosineSimilarity");
        SparkContext sc = new SparkContext(conf);
        RDD rows = sc.textFile(params.inputFile(), sc.textFile$default$2()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Vector apply(String line) {
                double[] values = (double[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(line)).split(' ')).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(String x$1) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toDouble();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                return Vectors$.MODULE$.dense(values);
            }
        }, ClassTag$.MODULE$.apply(Vector.class)).cache();
        RowMatrix mat = new RowMatrix(rows);
        CoordinateMatrix exact = mat.columnSimilarities();
        CoordinateMatrix approx = mat.columnSimilarities(params.threshold());
        RDD exactEntries = exact.entries().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Tuple2<Object, Object>, Object> apply(MatrixEntry x0$1) {
                MatrixEntry matrixEntry = x0$1;
                if (matrixEntry != null) {
                    long i = matrixEntry.i();
                    long j = matrixEntry.j();
                    double u = matrixEntry.value();
                    Tuple2 tuple2 = new Tuple2((Object)new Tuple2.mcJJ.sp(i, j), (Object)BoxesRunTime.boxToDouble((double)u));
                    return tuple2;
                }
                throw new MatchError((Object)matrixEntry);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD approxEntries = approx.entries().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Tuple2<Object, Object>, Object> apply(MatrixEntry x0$2) {
                MatrixEntry matrixEntry = x0$2;
                if (matrixEntry != null) {
                    long i = matrixEntry.i();
                    long j = matrixEntry.j();
                    double v = matrixEntry.value();
                    Tuple2 tuple2 = new Tuple2((Object)new Tuple2.mcJJ.sp(i, j), (Object)BoxesRunTime.boxToDouble((double)v));
                    return tuple2;
                }
                throw new MatchError((Object)matrixEntry);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        double MAE = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(exactEntries, ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$)).leftOuterJoin(approxEntries), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple2.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$)).values().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Option<Object>> x0$3) {
                Tuple2<Object, Option<Object>> tuple2;
                block4: {
                    double d;
                    block3: {
                        block2: {
                            tuple2 = x0$3;
                            if (tuple2 == null) break block2;
                            double u = tuple2._1$mcD$sp();
                            Option option = (Option)tuple2._2();
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            double v = BoxesRunTime.unboxToDouble((Object)some.x());
                            d = package$.MODULE$.abs(u - v);
                            break block3;
                        }
                        if (tuple2 == null) break block4;
                        double u = tuple2._1$mcD$sp();
                        Option option = (Option)tuple2._2();
                        None$ none$ = None$.MODULE$;
                        Option option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                        d = package$.MODULE$.abs(u);
                    }
                    return d;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.Double())).mean();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Average absolute error in estimate is: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)MAE)})));
        sc.stop();
    }

    private CosineSimilarity$() {
        MODULE$ = this;
    }
}

