/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.Correlations;
import org.apache.spark.examples.mllib.Correlations$Params$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.stat.Statistics$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.sys.package$;
import scopt.OptionParser;
import scopt.Read$;

public final class Correlations$ {
    public static final Correlations$ MODULE$;

    static {
        new Correlations$();
    }

    public void main(String[] args) {
        Correlations.Params defaultParams = new Correlations.Params(Correlations$Params$.MODULE$.apply$default$1());
        OptionParser<Correlations.Params> parser = new OptionParser<Correlations.Params>(defaultParams){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Correlations: an example app for computing correlations"}));
                this.opt("input", Read$.MODULE$.stringRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input path to labeled examples in LIBSVM format, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultParams$1.input()}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Correlations.Params apply(String x, Correlations.Params c) {
                        return c.copy(x);
                    }
                });
                this.note(new StringOps(Predef$.MODULE$.augmentString("\n        |For example, the following command runs this app on a synthetic dataset:\n        |\n        | bin/spark-submit --class org.apache.spark.examples.mllib.Correlations \\\n        |  examples/target/scala-*/spark-examples-*.jar \\\n        |  --input data/mllib/sample_linear_regression_data.txt\n        ")).stripMargin());
            }
        };
        parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Correlations.Params params) {
                Correlations$.MODULE$.run(params);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return package$.MODULE$.exit(1);
            }
        });
    }

    public void run(Correlations.Params params) {
        SparkConf conf = new SparkConf().setAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Correlations with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params})));
        SparkContext sc = new SparkContext(conf);
        RDD examples = MLUtils$.MODULE$.loadLibSVMFile(sc, params.input()).cache();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Summary of data file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.input()})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " data points"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)examples.count())})));
        RDD labelRDD = examples.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(LabeledPoint x$1) {
                return x$1.label();
            }
        }, ClassTag$.MODULE$.Double());
        int numFeatures = ((LabeledPoint[])examples.take(1))[0].features().size();
        String corrType = "pearson";
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Correlation (", ") between label and each feature"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{corrType})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Feature\\tCorrelation"})).s((Seq)Nil$.MODULE$));
        IntRef feature = new IntRef(0);
        while (feature.elem < numFeatures) {
            RDD featureRDD = examples.map((Function1)new Serializable(feature){
                public static final long serialVersionUID = 0L;
                private final IntRef feature$1;

                public final double apply(LabeledPoint x$2) {
                    return x$2.features().apply(this.feature$1.elem);
                }
                {
                    this.feature$1 = feature$1;
                }
            }, ClassTag$.MODULE$.Double());
            double corr = Statistics$.MODULE$.corr(labelRDD, featureRDD);
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)feature.elem), BoxesRunTime.boxToDouble((double)corr)})));
            ++feature.elem;
        }
        Predef$.MODULE$.println();
        sc.stop();
    }

    private Correlations$() {
        MODULE$ = this;
    }
}

