/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.attribute.NumericAttribute$;
import org.apache.spark.ml.feature.VectorSlicer;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ClassTag$;

public final class VectorSlicerExample$ {
    public static final VectorSlicerExample$ MODULE$;

    static {
        new VectorSlicerExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("VectorSlicerExample");
        SparkContext sc = new SparkContext(conf);
        SQLContext sqlContext = new SQLContext(sc);
        Row[] data = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Vectors$.MODULE$.dense(-2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.3, 0.0}))}))});
        NumericAttribute defaultAttr = NumericAttribute$.MODULE$.defaultAttr();
        NumericAttribute[] attrs = (NumericAttribute[])Predef$.MODULE$.refArrayOps((Object[])new String[]{"f1", "f2", "f3"}).map((Function1)new Serializable(defaultAttr){
            public static final long serialVersionUID = 0L;
            private final NumericAttribute defaultAttr$1;

            public final NumericAttribute apply(String name) {
                return this.defaultAttr$1.withName(name);
            }
            {
                this.defaultAttr$1 = defaultAttr$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(NumericAttribute.class)));
        AttributeGroup attrGroup = new AttributeGroup("userFeatures", (Attribute[])attrs);
        RDD dataRDD = sc.parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])data), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class));
        DataFrame dataset = sqlContext.createDataFrame(dataRDD, new StructType((StructField[])((Object[])new StructField[]{attrGroup.toStructField()})));
        VectorSlicer slicer = new VectorSlicer().setInputCol("userFeatures").setOutputCol("features");
        slicer.setIndices(new int[]{1}).setNames((String[])((Object[])new String[]{"f3"}));
        DataFrame output = slicer.transform(dataset);
        Predef$.MODULE$.println((Object)output.select("userFeatures", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"features"})).first());
        sc.stop();
    }

    private VectorSlicerExample$() {
        MODULE$ = this;
    }
}

