/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.evaluation.RegressionEvaluator;
import org.apache.spark.ml.feature.VectorIndexer;
import org.apache.spark.ml.feature.VectorIndexerModel;
import org.apache.spark.ml.regression.RandomForestRegressionModel;
import org.apache.spark.ml.regression.RandomForestRegressor;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import scala.Array$;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class RandomForestRegressorExample$ {
    public static final RandomForestRegressorExample$ MODULE$;

    static {
        new RandomForestRegressorExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("RandomForestRegressorExample");
        SparkContext sc = new SparkContext(conf);
        SQLContext sqlContext = new SQLContext(sc);
        DataFrame data = sqlContext.read().format("libsvm").load("data/mllib/sample_libsvm_data.txt");
        VectorIndexerModel featureIndexer = new VectorIndexer().setInputCol("features").setOutputCol("indexedFeatures").setMaxCategories(4).fit(data);
        DataFrame[] dataFrameArray = data.randomSplit(new double[]{0.7, 0.3});
        Option option = Array$.MODULE$.unapplySeq((Object)dataFrameArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            DataFrame trainingData = (DataFrame)((SeqLike)option.get()).apply(0);
            DataFrame testData = (DataFrame)((SeqLike)option.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)trainingData, (Object)testData);
            DataFrame trainingData2 = (DataFrame)tuple22._1();
            DataFrame testData2 = (DataFrame)tuple22._2();
            RandomForestRegressor rf = (RandomForestRegressor)new RandomForestRegressor().setLabelCol("label").setFeaturesCol("indexedFeatures");
            Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{featureIndexer, rf}));
            PipelineModel model = pipeline.fit(trainingData2);
            DataFrame predictions = model.transform(testData2);
            predictions.select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label", "features"})).show(5);
            RegressionEvaluator evaluator = new RegressionEvaluator().setLabelCol("label").setPredictionCol("prediction").setMetricName("rmse");
            double rmse2 = evaluator.evaluate(predictions);
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Root Mean Squared Error (RMSE) on test data = ").append((Object)BoxesRunTime.boxToDouble((double)rmse2)).toString());
            RandomForestRegressionModel rfModel = (RandomForestRegressionModel)model.stages()[1];
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Learned regression forest model:\n").append((Object)rfModel.toDebugString()).toString());
            sc.stop();
            return;
        }
        throw new MatchError((Object)dataFrameArray);
    }

    private RandomForestRegressorExample$() {
        MODULE$ = this;
    }
}

