/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.examples.ml.MyJavaLogisticRegressionModel;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.classification.Classifier;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.sql.DataFrame;

class MyJavaLogisticRegression
extends Classifier<Vector, MyJavaLogisticRegression, MyJavaLogisticRegressionModel> {
    private String uid_ = Identifiable$.MODULE$.randomUID("myJavaLogReg");
    IntParam maxIter = new IntParam((Identifiable)this, "maxIter", "max number of iterations");

    public MyJavaLogisticRegression() {
        this.init();
    }

    public MyJavaLogisticRegression(String uid) {
        this.uid_ = uid;
        this.init();
    }

    public String uid() {
        return this.uid_;
    }

    int getMaxIter() {
        return (Integer)this.getOrDefault((Param)this.maxIter);
    }

    private void init() {
        this.setMaxIter(100);
    }

    MyJavaLogisticRegression setMaxIter(int value) {
        return (MyJavaLogisticRegression)this.set((Param)this.maxIter, value);
    }

    public MyJavaLogisticRegressionModel train(DataFrame dataset) {
        JavaRDD oldDataset = this.extractLabeledPoints(dataset).toJavaRDD();
        int numFeatures = ((LabeledPoint)oldDataset.take(1).get(0)).features().size();
        Vector weights = Vectors.zeros((int)numFeatures);
        return (MyJavaLogisticRegressionModel)new MyJavaLogisticRegressionModel(this.uid(), weights).setParent((Estimator)this);
    }

    public MyJavaLogisticRegression copy(ParamMap extra) {
        return (MyJavaLogisticRegression)this.defaultCopy(extra);
    }
}

