/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.ml.MovieLensALS;
import org.apache.spark.examples.ml.MovieLensALS$;
import org.apache.spark.examples.ml.MovieLensALS$Movie$;
import org.apache.spark.examples.ml.MovieLensALS$Params$;
import org.apache.spark.examples.ml.MovieLensALS$Rating$;
import org.apache.spark.ml.recommendation.ALS;
import org.apache.spark.ml.recommendation.ALSModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scopt.OptionParser;
import scopt.Read$;

public final class MovieLensALS$ {
    public static final MovieLensALS$ MODULE$;

    static {
        new MovieLensALS$();
    }

    public void main(String[] args) {
        MovieLensALS.Params defaultParams = new MovieLensALS.Params(MovieLensALS$Params$.MODULE$.apply$default$1(), MovieLensALS$Params$.MODULE$.apply$default$2(), MovieLensALS$Params$.MODULE$.apply$default$3(), MovieLensALS$Params$.MODULE$.apply$default$4(), MovieLensALS$Params$.MODULE$.apply$default$5(), MovieLensALS$Params$.MODULE$.apply$default$6());
        OptionParser<MovieLensALS.Params> parser = new OptionParser<MovieLensALS.Params>(defaultParams){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MovieLensALS: an example app for ALS on MovieLens data."}));
                this.opt("ratings", Read$.MODULE$.stringRead()).required().text("path to a MovieLens dataset of ratings").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MovieLensALS.Params apply(String x, MovieLensALS.Params c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6());
                    }
                });
                this.opt("movies", Read$.MODULE$.stringRead()).required().text("path to a MovieLens dataset of movies").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MovieLensALS.Params apply(String x, MovieLensALS.Params c) {
                        String x$3 = x;
                        String x$4 = c.copy$default$1();
                        int x$5 = c.copy$default$3();
                        double x$6 = c.copy$default$4();
                        int x$7 = c.copy$default$5();
                        int x$8 = c.copy$default$6();
                        return c.copy(x$4, x$3, x$5, x$6, x$7, x$8);
                    }
                });
                this.opt("rank", Read$.MODULE$.intRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rank, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.rank())}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MovieLensALS.Params apply(int x, MovieLensALS.Params c) {
                        int x$9 = x;
                        String x$10 = c.copy$default$1();
                        String x$11 = c.copy$default$2();
                        int x$12 = c.copy$default$3();
                        double x$13 = c.copy$default$4();
                        int x$14 = c.copy$default$6();
                        return c.copy(x$10, x$11, x$12, x$13, x$9, x$14);
                    }
                });
                this.opt("maxIter", Read$.MODULE$.intRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"max number of iterations, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.maxIter())}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MovieLensALS.Params apply(int x, MovieLensALS.Params c) {
                        int x$15 = x;
                        String x$16 = c.copy$default$1();
                        String x$17 = c.copy$default$2();
                        double x$18 = c.copy$default$4();
                        int x$19 = c.copy$default$5();
                        int x$20 = c.copy$default$6();
                        return c.copy(x$16, x$17, x$15, x$18, x$19, x$20);
                    }
                });
                this.opt("regParam", Read$.MODULE$.doubleRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"regularization parameter, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)defaultParams$1.regParam())}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MovieLensALS.Params apply(double x, MovieLensALS.Params c) {
                        double x$21 = x;
                        String x$22 = c.copy$default$1();
                        String x$23 = c.copy$default$2();
                        int x$24 = c.copy$default$3();
                        int x$25 = c.copy$default$5();
                        int x$26 = c.copy$default$6();
                        return c.copy(x$22, x$23, x$24, x$21, x$25, x$26);
                    }
                });
                this.opt("numBlocks", Read$.MODULE$.intRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of blocks, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.numBlocks())}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MovieLensALS.Params apply(int x, MovieLensALS.Params c) {
                        int x$27 = x;
                        String x$28 = c.copy$default$1();
                        String x$29 = c.copy$default$2();
                        int x$30 = c.copy$default$3();
                        double x$31 = c.copy$default$4();
                        int x$32 = c.copy$default$5();
                        return c.copy(x$28, x$29, x$30, x$31, x$32, x$27);
                    }
                });
                this.note(new StringOps(Predef$.MODULE$.augmentString("\n          |Example command line to run this app:\n          |\n          | bin/spark-submit --class org.apache.spark.examples.ml.MovieLensALS \\\n          |  examples/target/scala-*/spark-examples-*.jar \\\n          |  --rank 10 --maxIter 15 --regParam 0.1 \\\n          |  --movies data/mllib/als/sample_movielens_movies.txt \\\n          |  --ratings data/mllib/als/sample_movielens_ratings.txt\n        ")).stripMargin());
            }
        };
        parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(MovieLensALS.Params params) {
                MovieLensALS$.MODULE$.run(params);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                System.exit(1);
            }
        });
    }

    public void run(MovieLensALS.Params params) {
        SparkConf conf = new SparkConf().setAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MovieLensALS with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params})));
        SparkContext sc = new SparkContext(conf);
        SQLContext sqlContext = new SQLContext(sc);
        RDD ratings = sc.textFile(params.ratings(), sc.textFile$default$2()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final MovieLensALS.Rating apply(String str) {
                return MovieLensALS$Rating$.MODULE$.parseRating(str);
            }
        }, ClassTag$.MODULE$.apply(MovieLensALS.Rating.class)).cache();
        long numRatings = ratings.count();
        long numUsers = ratings.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(MovieLensALS.Rating x$1) {
                return x$1.userId();
            }
        }, ClassTag$.MODULE$.Int()).distinct().count();
        long numMovies = ratings.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(MovieLensALS.Rating x$2) {
                return x$2.movieId();
            }
        }, ClassTag$.MODULE$.Int()).distinct().count();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ", " ratings from ", " users on ", " movies."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numRatings), BoxesRunTime.boxToLong((long)numUsers), BoxesRunTime.boxToLong((long)numMovies)})));
        RDD[] splits = ratings.randomSplit(new double[]{0.8, 0.2}, 0L);
        RDD training = splits[0].cache();
        RDD test = splits[1].cache();
        long numTraining = training.count();
        long numTest = test.count();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Training: ", ", test: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numTraining), BoxesRunTime.boxToLong((long)numTest)})));
        ratings.unpersist(false);
        ALS als = new ALS().setUserCol("userId").setItemCol("movieId").setRank(params.rank()).setMaxIter(params.maxIter()).setRegParam(params.regParam()).setNumBlocks(params.numBlocks());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_ml_MovieLensALS$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.examples.ml.MovieLensALS.Rating")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_examples_ml_MovieLensALS$$typecreator2$1() {
            }
        }
        ALSModel model = als.fit(sqlContext.implicits().rddToDataFrameHolder(training, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_ml_MovieLensALS$$typecreator2$1())).toDF());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_ml_MovieLensALS$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.examples.ml.MovieLensALS.Rating")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_examples_ml_MovieLensALS$$typecreator3$1() {
            }
        }
        DataFrame predictions = model.transform(sqlContext.implicits().rddToDataFrameHolder(test, ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_examples_ml_MovieLensALS$$typecreator3$1())).toDF()).cache();
        double mse = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(predictions.select("rating", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction"})).rdd().flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(Row x0$1) {
                Row row = x0$1;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Object rating = ((SeqLike)some.get()).apply(0);
                    Object prediction = ((SeqLike)some.get()).apply(1);
                    if (rating instanceof Float) {
                        float f = BoxesRunTime.unboxToFloat((Object)rating);
                        if (prediction instanceof Float) {
                            float f2 = BoxesRunTime.unboxToFloat((Object)prediction);
                            double err = (double)f - (double)f2;
                            double err2 = err * err;
                            Iterable iterable = Predef$.MODULE$.double2Double(err2).isNaN() ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)BoxesRunTime.boxToDouble((double)err2)));
                            return iterable;
                        }
                    }
                }
                throw new MatchError((Object)row);
            }
        }, ClassTag$.MODULE$.Double())).mean();
        double rmse2 = scala.math.package$.MODULE$.sqrt(mse);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test RMSE = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)rmse2)})));
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_ml_MovieLensALS$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.examples.ml.MovieLensALS.Movie")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_examples_ml_MovieLensALS$$typecreator4$1() {
            }
        }
        DataFrame movies = sqlContext.implicits().rddToDataFrameHolder(sc.textFile(params.movies(), sc.textFile$default$2()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final MovieLensALS.Movie apply(String str) {
                return MovieLensALS$Movie$.MODULE$.parseMovie(str);
            }
        }, ClassTag$.MODULE$.apply(MovieLensALS.Movie.class)), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_examples_ml_MovieLensALS$$typecreator4$1())).toDF();
        DataFrame falsePositives = predictions.join(movies).where(predictions.apply("movieId").$eq$eq$eq((Object)movies.apply("movieId")).$amp$amp((Object)sqlContext.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rating"}))).$((Seq)Nil$.MODULE$).$less$eq((Object)BoxesRunTime.boxToInteger((int)1))).$amp$amp((Object)sqlContext.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction"}))).$((Seq)Nil$.MODULE$).$greater$eq((Object)BoxesRunTime.boxToInteger((int)4)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{sqlContext.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"userId"}))).$((Seq)Nil$.MODULE$), predictions.apply("movieId"), sqlContext.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"title"}))).$((Seq)Nil$.MODULE$), sqlContext.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rating"}))).$((Seq)Nil$.MODULE$), sqlContext.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction"}))).$((Seq)Nil$.MODULE$)}));
        long numFalsePositives = falsePositives.count();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " false positives"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numFalsePositives)})));
        if (numFalsePositives > 0L) {
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Example false positives:"})).s((Seq)Nil$.MODULE$));
            Predef$.MODULE$.refArrayOps((Object[])falsePositives.limit(100).collect()).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Object x) {
                    Predef$.MODULE$.println(x);
                }
            });
        }
        sc.stop();
    }

    private MovieLensALS$() {
        MODULE$ = this;
    }
}

