/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.feature.Word2Vec;
import org.apache.spark.ml.feature.Word2VecModel;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaWord2VecExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaWord2VecExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        SQLContext sqlContext = new SQLContext(jsc);
        JavaRDD jrdd = jsc.parallelize(Arrays.asList(RowFactory.create((Object[])new Object[]{Arrays.asList("Hi I heard about Spark".split(" "))}), RowFactory.create((Object[])new Object[]{Arrays.asList("I wish Java could use case classes".split(" "))}), RowFactory.create((Object[])new Object[]{Arrays.asList("Logistic regression models are neat".split(" "))})));
        StructType schema = new StructType(new StructField[]{new StructField("text", (DataType)new ArrayType(DataTypes.StringType, true), false, Metadata.empty())});
        DataFrame documentDF = sqlContext.createDataFrame(jrdd, schema);
        Word2Vec word2Vec = new Word2Vec().setInputCol("text").setOutputCol("result").setVectorSize(3).setMinCount(0);
        Word2VecModel model = word2Vec.fit(documentDF);
        DataFrame result = model.transform(documentDF);
        for (Row r : result.select("result", new String[0]).take(3)) {
            System.out.println(r);
        }
    }
}

