/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.feature.StopWordsRemover;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaStopWordsRemoverExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaStopWordsRemoverExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        SQLContext jsql = new SQLContext(jsc);
        StopWordsRemover remover = new StopWordsRemover().setInputCol("raw").setOutputCol("filtered");
        JavaRDD rdd = jsc.parallelize(Arrays.asList(RowFactory.create((Object[])new Object[]{Arrays.asList("I", "saw", "the", "red", "baloon")}), RowFactory.create((Object[])new Object[]{Arrays.asList("Mary", "had", "a", "little", "lamb")})));
        StructType schema = new StructType(new StructField[]{new StructField("raw", (DataType)DataTypes.createArrayType((DataType)DataTypes.StringType), false, Metadata.empty())});
        DataFrame dataset = jsql.createDataFrame(rdd, schema);
        remover.transform(dataset).show();
        jsc.stop();
    }
}

