/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;

public class JavaSimpleParamsExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaSimpleParamsExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        SQLContext jsql = new SQLContext(jsc);
        ArrayList localTraining = Lists.newArrayList((Object[])new LabeledPoint[]{new LabeledPoint(1.0, Vectors.dense((double)0.0, (double[])new double[]{1.1, 0.1})), new LabeledPoint(0.0, Vectors.dense((double)2.0, (double[])new double[]{1.0, -1.0})), new LabeledPoint(0.0, Vectors.dense((double)2.0, (double[])new double[]{1.3, 1.0})), new LabeledPoint(1.0, Vectors.dense((double)0.0, (double[])new double[]{1.2, -0.5}))});
        DataFrame training = jsql.createDataFrame(jsc.parallelize((List)localTraining), LabeledPoint.class);
        LogisticRegression lr = new LogisticRegression();
        System.out.println("LogisticRegression parameters:\n" + lr.explainParams() + "\n");
        lr.setMaxIter(10).setRegParam(0.01);
        LogisticRegressionModel model1 = (LogisticRegressionModel)lr.fit(training);
        System.out.println("Model 1 was fit using parameters: " + model1.parent().extractParamMap());
        ParamMap paramMap = new ParamMap();
        paramMap.put(new ParamPair[]{lr.maxIter().w(20)});
        paramMap.put((Param)lr.maxIter(), (Object)30);
        double[] thresholds = new double[]{0.45, 0.55};
        paramMap.put(new ParamPair[]{lr.regParam().w(0.1), lr.thresholds().w((Object)thresholds)});
        ParamMap paramMap2 = new ParamMap();
        paramMap2.put(new ParamPair[]{lr.probabilityCol().w((Object)"myProbability")});
        ParamMap paramMapCombined = paramMap.$plus$plus(paramMap2);
        LogisticRegressionModel model2 = (LogisticRegressionModel)lr.fit(training, paramMapCombined);
        System.out.println("Model 2 was fit using parameters: " + model2.parent().extractParamMap());
        ArrayList localTest = Lists.newArrayList((Object[])new LabeledPoint[]{new LabeledPoint(1.0, Vectors.dense((double)-1.0, (double[])new double[]{1.5, 1.3})), new LabeledPoint(0.0, Vectors.dense((double)3.0, (double[])new double[]{2.0, -0.1})), new LabeledPoint(1.0, Vectors.dense((double)0.0, (double[])new double[]{2.2, -1.5}))});
        DataFrame test = jsql.createDataFrame(jsc.parallelize((List)localTest), LabeledPoint.class);
        DataFrame results = model2.transform(test);
        for (Row r : results.select("features", new String[]{"label", "myProbability", "prediction"}).collect()) {
            System.out.println("(" + r.get(0) + ", " + r.get(1) + ") -> prob=" + r.get(2) + ", prediction=" + r.get(3));
        }
        jsc.stop();
    }
}

