/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.regex.Pattern;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.ml.clustering.KMeans;
import org.apache.spark.ml.clustering.KMeansModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.expressions.GenericRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaKMeansExample {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: ml.JavaKMeansExample <file> <k>");
            System.exit(1);
        }
        String inputFile = args[0];
        int k = Integer.parseInt(args[1]);
        SparkConf conf = new SparkConf().setAppName("JavaKMeansExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        SQLContext sqlContext = new SQLContext(jsc);
        JavaRDD points = jsc.textFile(inputFile).map((Function)new ParsePoint());
        StructField[] fields = new StructField[]{new StructField("features", (DataType)new VectorUDT(), false, Metadata.empty())};
        StructType schema = new StructType(fields);
        DataFrame dataset = sqlContext.createDataFrame(points, schema);
        KMeans kmeans = new KMeans().setK(k);
        KMeansModel model = kmeans.fit(dataset);
        Vector[] centers = model.clusterCenters();
        System.out.println("Cluster Centers: ");
        for (Vector center : centers) {
            System.out.println(center);
        }
        jsc.stop();
    }

    private static class ParsePoint
    implements Function<String, Row> {
        private static final Pattern separator = Pattern.compile(" ");

        private ParsePoint() {
        }

        public Row call(String line) {
            String[] tok = separator.split(line);
            double[] point = new double[tok.length];
            for (int i = 0; i < tok.length; ++i) {
                point[i] = Double.parseDouble(tok[i]);
            }
            Object[] points = new Vector[]{Vectors.dense((double[])point)};
            return new GenericRow(points);
        }
    }
}

