/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.feature.Bucketizer;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaBucketizerExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaBucketizerExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        SQLContext jsql = new SQLContext(jsc);
        double[] splits = new double[]{Double.NEGATIVE_INFINITY, -0.5, 0.0, 0.5, Double.POSITIVE_INFINITY};
        JavaRDD data = jsc.parallelize(Arrays.asList(RowFactory.create((Object[])new Object[]{-0.5}), RowFactory.create((Object[])new Object[]{-0.3}), RowFactory.create((Object[])new Object[]{0.0}), RowFactory.create((Object[])new Object[]{0.2})));
        StructType schema = new StructType(new StructField[]{new StructField("features", DataTypes.DoubleType, false, Metadata.empty())});
        DataFrame dataFrame = jsql.createDataFrame(data, schema);
        Bucketizer bucketizer = new Bucketizer().setInputCol("features").setOutputCol("bucketedFeatures").setSplits(splits);
        DataFrame bucketedData = bucketizer.transform(dataFrame);
        bucketedData.show();
        jsc.stop();
    }
}

