/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.ml.CrossValidatorExample$;
import org.apache.spark.examples.ml.Document;
import org.apache.spark.examples.ml.LabeledDocument;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.evaluation.BinaryClassificationEvaluator;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.feature.HashingTF;
import org.apache.spark.ml.feature.Tokenizer;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.tuning.CrossValidator;
import org.apache.spark.ml.tuning.CrossValidatorModel;
import org.apache.spark.ml.tuning.ParamGridBuilder;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CrossValidatorExample$ {
    public static final CrossValidatorExample$ MODULE$;

    static {
        new CrossValidatorExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("CrossValidatorExample");
        SparkContext sc = new SparkContext(conf);
        SQLContext sqlContext = new SQLContext(sc);
        RDD training = sc.parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledDocument[]{new LabeledDocument(0L, "a b c d e spark", 1.0), new LabeledDocument(1L, "b d", 0.0), new LabeledDocument(2L, "spark f g h", 1.0), new LabeledDocument(3L, "hadoop mapreduce", 0.0), new LabeledDocument(4L, "b spark who", 1.0), new LabeledDocument(5L, "g d a y", 0.0), new LabeledDocument(6L, "spark fly", 1.0), new LabeledDocument(7L, "was mapreduce", 0.0), new LabeledDocument(8L, "e spark program", 1.0), new LabeledDocument(9L, "a e c l", 0.0), new LabeledDocument(10L, "spark compile", 1.0), new LabeledDocument(11L, "hadoop software", 0.0)})), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(LabeledDocument.class));
        Tokenizer tokenizer = (Tokenizer)new Tokenizer().setInputCol("text").setOutputCol("words");
        HashingTF hashingTF = new HashingTF().setInputCol(tokenizer.getOutputCol()).setOutputCol("features");
        LogisticRegression lr = new LogisticRegression().setMaxIter(10);
        Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{tokenizer, hashingTF, lr}));
        CrossValidator crossval = new CrossValidator().setEstimator((Estimator)pipeline).setEvaluator((Evaluator)new BinaryClassificationEvaluator());
        ParamMap[] paramGrid = new ParamGridBuilder().addGrid(hashingTF.numFeatures(), new int[]{10, 100, 1000}).addGrid(lr.regParam(), new double[]{0.1, 0.01}).build();
        crossval.setEstimatorParamMaps(paramGrid);
        crossval.setNumFolds(2);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_ml_CrossValidatorExample$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.examples.ml.LabeledDocument")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_examples_ml_CrossValidatorExample$$typecreator1$1() {
            }
        }
        CrossValidatorModel cvModel = crossval.fit(sqlContext.implicits().rddToDataFrameHolder(training, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_ml_CrossValidatorExample$$typecreator1$1())).toDF());
        RDD test = sc.parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Document[]{new Document(4L, "spark i j k"), new Document(5L, "l m n"), new Document(6L, "mapreduce spark"), new Document(7L, "apache hadoop")})), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Document.class));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_ml_CrossValidatorExample$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.examples.ml.Document")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_examples_ml_CrossValidatorExample$$typecreator2$1() {
            }
        }
        Predef$.MODULE$.refArrayOps((Object[])cvModel.transform(sqlContext.implicits().rddToDataFrameHolder(test, ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_examples_ml_CrossValidatorExample$$typecreator2$1())).toDF()).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"text", "probability", "prediction"})).collect()).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Row x0$1) {
                Row row = x0$1;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(4) == 0) {
                    Object id = ((SeqLike)some.get()).apply(0);
                    Object text = ((SeqLike)some.get()).apply(1);
                    Object prob = ((SeqLike)some.get()).apply(2);
                    Object prediction = ((SeqLike)some.get()).apply(3);
                    if (id instanceof Long) {
                        long l = BoxesRunTime.unboxToLong((Object)id);
                        if (text instanceof String) {
                            String string = (String)text;
                            if (prob instanceof Vector) {
                                Vector vector = (Vector)prob;
                                if (prediction instanceof Double) {
                                    double d = BoxesRunTime.unboxToDouble((Object)prediction);
                                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ", ", ") --> prob=", ", prediction=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)l), string, vector, BoxesRunTime.boxToDouble((double)d)})));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                    }
                }
                throw new MatchError((Object)row);
            }
        });
        sc.stop();
    }

    private CrossValidatorExample$() {
        MODULE$ = this;
    }
}

