/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.PairFunction;
import scala.Tuple2;

public final class JavaTC {
    private static final int numEdges = 200;
    private static final int numVertices = 100;
    private static final Random rand = new Random(42L);

    static List<Tuple2<Integer, Integer>> generateGraph() {
        HashSet<Tuple2> edges = new HashSet<Tuple2>(200);
        while (edges.size() < 200) {
            int from = rand.nextInt(100);
            int to = rand.nextInt(100);
            Tuple2 e = new Tuple2((Object)from, (Object)to);
            if (from == to) continue;
            edges.add(e);
        }
        return new ArrayList<Tuple2<Integer, Integer>>(edges);
    }

    public static void main(String[] args) {
        long oldCount;
        SparkConf sparkConf = new SparkConf().setAppName("JavaHdfsLR");
        JavaSparkContext sc = new JavaSparkContext(sparkConf);
        Integer slices = args.length > 0 ? Integer.parseInt(args[0]) : 2;
        JavaPairRDD tc = sc.parallelizePairs(JavaTC.generateGraph(), slices.intValue()).cache();
        JavaPairRDD edges = tc.mapToPair((PairFunction)new PairFunction<Tuple2<Integer, Integer>, Integer, Integer>(){

            public Tuple2<Integer, Integer> call(Tuple2<Integer, Integer> e) {
                return new Tuple2(e._2(), e._1());
            }
        });
        long nextCount = tc.count();
        do {
            oldCount = nextCount;
        } while ((nextCount = (tc = tc.union(tc.join(edges).mapToPair((PairFunction)ProjectFn.INSTANCE)).distinct().cache()).count()) != oldCount);
        System.out.println("TC has " + tc.count() + " edges.");
        sc.stop();
    }

    static class ProjectFn
    implements PairFunction<Tuple2<Integer, Tuple2<Integer, Integer>>, Integer, Integer> {
        static final ProjectFn INSTANCE = new ProjectFn();

        ProjectFn() {
        }

        public Tuple2<Integer, Integer> call(Tuple2<Integer, Tuple2<Integer, Integer>> triple) {
            return new Tuple2(((Tuple2)triple._2())._2(), ((Tuple2)triple._2())._1());
        }
    }
}

