/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.cql3.CqlConfigHelper;
import org.apache.cassandra.hadoop.cql3.CqlOutputFormat;
import org.apache.cassandra.hadoop.cql3.CqlPagingInputFormat;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

public final class CassandraCQLTest$ {
    public static final CassandraCQLTest$ MODULE$;

    static {
        new CassandraCQLTest$();
    }

    public void main(String[] args) {
        RDD casoutputCF;
        SparkConf sparkConf = new SparkConf().setAppName("CQLTestApp");
        SparkContext sc = new SparkContext(sparkConf);
        String cHost = args[0];
        String cPort = args[1];
        String KeySpace = "retail";
        String InputColumnFamily = "ordercf";
        String OutputColumnFamily = "salecount";
        Job job = new Job();
        job.setInputFormatClass(CqlPagingInputFormat.class);
        Configuration configuration = job.getConfiguration();
        ConfigHelper.setInputInitialAddress((Configuration)job.getConfiguration(), (String)cHost);
        ConfigHelper.setInputRpcPort((Configuration)job.getConfiguration(), (String)cPort);
        ConfigHelper.setInputColumnFamily((Configuration)job.getConfiguration(), (String)KeySpace, (String)InputColumnFamily);
        ConfigHelper.setInputPartitioner((Configuration)job.getConfiguration(), (String)"Murmur3Partitioner");
        CqlConfigHelper.setInputCQLPageRowSize((Configuration)job.getConfiguration(), (String)"3");
        String query = new StringBuilder().append((Object)"UPDATE ").append((Object)KeySpace).append((Object)".").append((Object)OutputColumnFamily).append((Object)" SET sale_count = ? ").toString();
        CqlConfigHelper.setOutputCql((Configuration)job.getConfiguration(), (String)query);
        job.setOutputFormatClass(CqlOutputFormat.class);
        ConfigHelper.setOutputColumnFamily((Configuration)job.getConfiguration(), (String)KeySpace, (String)OutputColumnFamily);
        ConfigHelper.setOutputInitialAddress((Configuration)job.getConfiguration(), (String)cHost);
        ConfigHelper.setOutputRpcPort((Configuration)job.getConfiguration(), (String)cPort);
        ConfigHelper.setOutputPartitioner((Configuration)job.getConfiguration(), (String)"Murmur3Partitioner");
        RDD casRdd = sc.newAPIHadoopRDD(job.getConfiguration(), CqlPagingInputFormat.class, Map.class, Map.class);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Count: ").append((Object)BoxesRunTime.boxToLong((long)casRdd.count())).toString());
        RDD productSaleRDD = casRdd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Tuple2<Map<String, ByteBuffer>, Map<String, ByteBuffer>> x0$1) {
                Tuple2<Map<String, ByteBuffer>, Map<String, ByteBuffer>> tuple2 = x0$1;
                if (tuple2 != null) {
                    Map value = (Map)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)ByteBufferUtil.string((ByteBuffer)((ByteBuffer)value.get("prod_id"))), (Object)BoxesRunTime.boxToInteger((int)ByteBufferUtil.toInt((ByteBuffer)((ByteBuffer)value.get("quantity")))));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD aggregatedRDD = RDD$.MODULE$.rddToPairRDDFunctions(productSaleRDD, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$1, int x$2) {
                return this.apply$mcIII$sp(x$1, x$2);
            }

            public int apply$mcIII$sp(int x$1, int x$2) {
                return x$1 + x$2;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])aggregatedRDD.collect()).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, Object> x0$2) {
                Tuple2<String, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    String productId = (String)tuple2._1();
                    int saleCount = tuple2._2$mcI$sp();
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)productId).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)saleCount)).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        RDD x$3 = casoutputCF = aggregatedRDD.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Map<String, ByteBuffer>, List<ByteBuffer>> apply(Tuple2<String, Object> x0$3) {
                Tuple2<String, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    String productId = (String)tuple2._1();
                    int saleCount = tuple2._2$mcI$sp();
                    Map<String, ByteBuffer> outKey = Collections.singletonMap("prod_id", ByteBufferUtil.bytes((String)productId));
                    List<ByteBuffer> outVal = Collections.singletonList(ByteBufferUtil.bytes((int)saleCount));
                    Tuple2 tuple22 = new Tuple2(outKey, outVal);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        ClassTag x$4 = ClassTag$.MODULE$.apply(Map.class);
        ClassTag x$5 = ClassTag$.MODULE$.apply(List.class);
        Null$ x$6 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$3);
        RDD$.MODULE$.rddToPairRDDFunctions(x$3, x$4, x$5, null).saveAsNewAPIHadoopFile(KeySpace, Map.class, List.class, CqlOutputFormat.class, job.getConfiguration());
        sc.stop();
    }

    private CassandraCQLTest$() {
        MODULE$ = this;
    }
}

