/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql.hive;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.OutputSupplier;
import java.io.File;
import java.io.InputStream;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.sql.hive.HiveFromSpark;
import org.apache.spark.examples.sql.hive.HiveFromSpark$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hive.HiveContext;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class HiveFromSpark$ {
    public static final HiveFromSpark$ MODULE$;
    private final InputStream kv1Stream;
    private final File kv1File;

    static {
        new HiveFromSpark$();
    }

    public InputStream kv1Stream() {
        return this.kv1Stream;
    }

    public File kv1File() {
        return this.kv1File;
    }

    public void main(String[] args) {
        SparkConf sparkConf = new SparkConf().setAppName("HiveFromSpark");
        SparkContext sc = new SparkContext(sparkConf);
        HiveContext hiveContext = new HiveContext(sc);
        hiveContext.sql("CREATE TABLE IF NOT EXISTS src (key INT, value STRING)");
        hiveContext.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA LOCAL INPATH '", "' INTO TABLE src"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kv1File().getAbsolutePath()})));
        Predef$.MODULE$.println((Object)"Result of 'SELECT *': ");
        Predef$.MODULE$.refArrayOps((Object[])hiveContext.sql("SELECT * FROM src").collect()).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object x) {
                Predef$.MODULE$.println(x);
            }
        });
        long count = ((Row)Predef$.MODULE$.refArrayOps((Object[])hiveContext.sql("SELECT COUNT(*) FROM src").collect()).head()).getLong(0);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COUNT(*): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)count)})));
        DataFrame rddFromSql = hiveContext.sql("SELECT key, value FROM src WHERE key < 10 ORDER BY key");
        Predef$.MODULE$.println((Object)"Result of RDD.map:");
        RDD rddAsStrings = rddFromSql.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row x0$1) {
                Row row = x0$1;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Object key = ((SeqLike)some.get()).apply(0);
                    Object value = ((SeqLike)some.get()).apply(1);
                    if (key instanceof Integer) {
                        int n = BoxesRunTime.unboxToInt((Object)key);
                        if (value instanceof String) {
                            String string = (String)value;
                            String string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Key: ", ", Value: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n), string}));
                            return string2;
                        }
                    }
                }
                throw new MatchError((Object)row);
            }
        }, ClassTag$.MODULE$.apply(String.class));
        RDD rdd = sc.parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final HiveFromSpark.Record apply(int i) {
                return new HiveFromSpark.Record(i, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"val_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom()), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(HiveFromSpark.Record.class));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_sql_hive_HiveFromSpark$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.examples.sql.hive.HiveFromSpark.Record")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_examples_sql_hive_HiveFromSpark$$typecreator1$1() {
            }
        }
        hiveContext.implicits().rddToDataFrameHolder(rdd, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_sql_hive_HiveFromSpark$$typecreator1$1())).toDF().registerTempTable("records");
        Predef$.MODULE$.println((Object)"Result of SELECT *:");
        Predef$.MODULE$.refArrayOps((Object[])hiveContext.sql("SELECT * FROM records r JOIN src s ON r.key = s.key").collect()).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object x) {
                Predef$.MODULE$.println(x);
            }
        });
        sc.stop();
    }

    private HiveFromSpark$() {
        MODULE$ = this;
        this.kv1Stream = this.getClass().getResourceAsStream("/kv1.txt");
        this.kv1File = File.createTempFile("kv1", "txt");
        this.kv1File().deleteOnExit();
        ByteStreams.copy((InputStream)this.kv1Stream(), (OutputSupplier)Files.newOutputStreamSupplier((File)this.kv1File()));
    }
}

