/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.PowerIterationClusteringExample;
import org.apache.spark.examples.mllib.PowerIterationClusteringExample$Params$;
import org.apache.spark.mllib.clustering.PowerIterationClustering;
import org.apache.spark.mllib.clustering.PowerIterationClusteringModel;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scopt.OptionParser;
import scopt.Read$;

public final class PowerIterationClusteringExample$ {
    public static final PowerIterationClusteringExample$ MODULE$;

    static {
        new PowerIterationClusteringExample$();
    }

    public void main(String[] args) {
        PowerIterationClusteringExample.Params defaultParams = new PowerIterationClusteringExample.Params(PowerIterationClusteringExample$Params$.MODULE$.apply$default$1(), PowerIterationClusteringExample$Params$.MODULE$.apply$default$2(), PowerIterationClusteringExample$Params$.MODULE$.apply$default$3());
        OptionParser<PowerIterationClusteringExample.Params> parser = new OptionParser<PowerIterationClusteringExample.Params>(defaultParams){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PowerIterationClusteringExample: an example PIC app using concentric circles."}));
                this.opt('k', "k", Read$.MODULE$.intRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of circles (clusters), default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.k())}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final PowerIterationClusteringExample.Params apply(int x, PowerIterationClusteringExample.Params c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3());
                    }
                });
                this.opt('n', "n", Read$.MODULE$.intRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of points in smallest circle, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.numPoints())}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final PowerIterationClusteringExample.Params apply(int x, PowerIterationClusteringExample.Params c) {
                        int x$5 = x;
                        int x$6 = c.copy$default$1();
                        int x$7 = c.copy$default$3();
                        return c.copy(x$6, x$5, x$7);
                    }
                });
                this.opt("maxIterations", Read$.MODULE$.intRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of iterations, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.maxIterations())}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final PowerIterationClusteringExample.Params apply(int x, PowerIterationClusteringExample.Params c) {
                        int x$8 = x;
                        int x$9 = c.copy$default$1();
                        int x$10 = c.copy$default$2();
                        return c.copy(x$9, x$10, x$8);
                    }
                });
            }
        };
        parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(PowerIterationClusteringExample.Params params) {
                PowerIterationClusteringExample$.MODULE$.run(params);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return scala.sys.package$.MODULE$.exit(1);
            }
        });
    }

    public void run(PowerIterationClusteringExample.Params params) {
        SparkConf conf = new SparkConf().setMaster("local").setAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PowerIterationClustering with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params})));
        SparkContext sc = new SparkContext(conf);
        Logger.getRootLogger().setLevel(Level.WARN);
        RDD<Tuple3<Object, Object, Object>> circlesRdd = this.generateCirclesRdd(sc, params.k(), params.numPoints());
        PowerIterationClusteringModel model = new PowerIterationClustering().setK(params.k()).setMaxIterations(params.maxIterations()).setInitializationMode("degree").run(circlesRdd);
        Map clusters = Predef$.MODULE$.refArrayOps((Object[])model.assignments().collect()).groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(PowerIterationClustering.Assignment x$1) {
                return x$1.cluster();
            }
        }).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long[] apply(PowerIterationClustering.Assignment[] x$2) {
                return (long[])Predef$.MODULE$.refArrayOps((Object[])x$2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(PowerIterationClustering.Assignment x$3) {
                        return x$3.id();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
            }
        });
        List assignments = (List)clusters.toList().sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Object, long[]> x0$1) {
                Tuple2<Object, long[]> tuple2 = x0$1;
                if (tuple2 != null) {
                    long[] v = (long[])tuple2._2();
                    int n = v.length;
                    return n;
                }
                throw new MatchError(tuple2);
            }
        }, (Ordering)Ordering.Int$.MODULE$);
        String assignmentsStr = ((TraversableOnce)assignments.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<Object, long[]> x0$2) {
                Tuple2<Object, long[]> tuple2 = x0$2;
                if (tuple2 != null) {
                    int k = tuple2._1$mcI$sp();
                    long[] v = (long[])tuple2._2();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)k), Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.longArrayOps(v).sorted((Ordering)Ordering.Long$.MODULE$)).mkString("[", ",", "]")}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, List$.MODULE$.canBuildFrom())).mkString(", ");
        String sizesStr = ((TraversableOnce)((SeqLike)assignments.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Object, long[]> x$4) {
                return ((long[])x$4._2()).length;
            }
        }, List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Int$.MODULE$)).mkString("(", ",", ")");
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cluster assignments: ", "\\ncluster sizes: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{assignmentsStr, sizesStr})));
        sc.stop();
    }

    public Seq<Tuple2<Object, Object>> generateCircle(double radius, int n) {
        return (Seq)Seq$.MODULE$.tabulate(n, (Function1)new Serializable(radius, n){
            public static final long serialVersionUID = 0L;
            private final double radius$1;
            private final int n$1;

            public final Tuple2<Object, Object> apply(int i) {
                double theta = 2.0 * package$.MODULE$.Pi() * (double)i / (double)this.n$1;
                return new Tuple2.mcDD.sp(this.radius$1 * package$.MODULE$.cos(theta), this.radius$1 * package$.MODULE$.sin(theta));
            }
            {
                this.radius$1 = radius$1;
                this.n$1 = n$1;
            }
        });
    }

    public RDD<Tuple3<Object, Object, Object>> generateCirclesRdd(SparkContext sc, int nCircles, int nPoints) {
        IndexedSeq points = (IndexedSeq)((IterableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), nCircles).flatMap((Function1)new Serializable(nPoints){
            public static final long serialVersionUID = 0L;
            private final int nPoints$1;

            public final Seq<Tuple2<Object, Object>> apply(int i) {
                return PowerIterationClusteringExample$.MODULE$.generateCircle(i, i * this.nPoints$1);
            }
            {
                this.nPoints$1 = nPoints$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom());
        RDD rdd = sc.parallelize((Seq)points, sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
        RDD distancesRdd = rdd.cartesian(rdd, ClassTag$.MODULE$.apply(Tuple2.class)).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple3<Object, Object, Object>> apply(Tuple2<Tuple2<Tuple2<Object, Object>, Object>, Tuple2<Tuple2<Object, Object>, Object>> x0$3) {
                Tuple2<Tuple2<Tuple2<Object, Object>, Object>, Tuple2<Tuple2<Object, Object>, Object>> tuple2 = x0$3;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        Tuple2 tuple24 = (Tuple2)tuple22._1();
                        int i0 = tuple22._2$mcI$sp();
                        if (tuple24 != null) {
                            double x0 = tuple24._1$mcD$sp();
                            double y0 = tuple24._2$mcD$sp();
                            if (tuple23 != null) {
                                Tuple2 tuple25 = (Tuple2)tuple23._1();
                                int i1 = tuple23._2$mcI$sp();
                                if (tuple25 != null) {
                                    double x1 = tuple25._1$mcD$sp();
                                    double y1 = tuple25._2$mcD$sp();
                                    Iterable iterable = i0 < i1 ? Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)i0), (Object)BoxesRunTime.boxToLong((long)i1), (Object)BoxesRunTime.boxToDouble((double)PowerIterationClusteringExample$.MODULE$.gaussianSimilarity((Tuple2<Object, Object>)new Tuple2.mcDD.sp(x0, y0), (Tuple2<Object, Object>)new Tuple2.mcDD.sp(x1, y1)))))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                                    return iterable;
                                }
                            }
                        }
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        return distancesRdd;
    }

    public double gaussianSimilarity(Tuple2<Object, Object> p1, Tuple2<Object, Object> p2) {
        double ssquares = (p1._1$mcD$sp() - p2._1$mcD$sp()) * (p1._1$mcD$sp() - p2._1$mcD$sp()) + (p1._2$mcD$sp() - p2._2$mcD$sp()) * (p1._2$mcD$sp() - p2._2$mcD$sp());
        return package$.MODULE$.exp(-ssquares / 2.0);
    }

    private PowerIterationClusteringExample$() {
        MODULE$ = this;
    }
}

