/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.classification.NaiveBayes$;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.classification.NaiveBayesModel$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;

public final class NaiveBayesExample$ {
    public static final NaiveBayesExample$ MODULE$;

    static {
        new NaiveBayesExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("NaiveBayesExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = sc.textFile("data/mllib/sample_naive_bayes_data.txt", sc.textFile$default$2());
        RDD parsedData = data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(String line) {
                String[] parts = new StringOps(Predef$.MODULE$.augmentString(line)).split(',');
                return new LabeledPoint(new StringOps(Predef$.MODULE$.augmentString(parts[0])).toDouble(), Vectors$.MODULE$.dense((double[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(parts[1])).split(' ')).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(String x$1) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toDouble();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))));
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        RDD[] splits = parsedData.randomSplit(new double[]{0.6, 0.4}, 11L);
        RDD training = splits[0];
        RDD test = splits[1];
        NaiveBayesModel model = NaiveBayes$.MODULE$.train(training, 1.0, "multinomial");
        RDD predictionAndLabel = test.map((Function1)new Serializable(model){
            public static final long serialVersionUID = 0L;
            private final NaiveBayesModel model$1;

            public final Tuple2<Object, Object> apply(LabeledPoint p) {
                return new Tuple2.mcDD.sp(this.model$1.predict(p.features()), p.label());
            }
            {
                this.model$1 = model$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        double accuracy = 1.0 * (double)predictionAndLabel.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> x) {
                return x._1$mcD$sp() == x._2$mcD$sp();
            }
        }).count() / (double)test.count();
        model.save(sc, "target/tmp/myNaiveBayesModel");
        NaiveBayesModel sameModel = NaiveBayesModel$.MODULE$.load(sc, "target/tmp/myNaiveBayesModel");
    }

    private NaiveBayesExample$() {
        MODULE$ = this;
    }
}

