/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.MultivariateSummarizer;
import org.apache.spark.examples.mllib.MultivariateSummarizer$Params$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;
import scopt.OptionParser;
import scopt.Read$;

public final class MultivariateSummarizer$ {
    public static final MultivariateSummarizer$ MODULE$;

    static {
        new MultivariateSummarizer$();
    }

    public void main(String[] args) {
        MultivariateSummarizer.Params defaultParams = new MultivariateSummarizer.Params(MultivariateSummarizer$Params$.MODULE$.apply$default$1());
        OptionParser<MultivariateSummarizer.Params> parser = new OptionParser<MultivariateSummarizer.Params>(defaultParams){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MultivariateSummarizer: an example app for MultivariateOnlineSummarizer"}));
                this.opt("input", Read$.MODULE$.stringRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input path to labeled examples in LIBSVM format, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultParams$1.input()}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MultivariateSummarizer.Params apply(String x, MultivariateSummarizer.Params c) {
                        return c.copy(x);
                    }
                });
                this.note(new StringOps(Predef$.MODULE$.augmentString("\n        |For example, the following command runs this app on a synthetic dataset:\n        |\n        | bin/spark-submit --class org.apache.spark.examples.mllib.MultivariateSummarizer \\\n        |  examples/target/scala-*/spark-examples-*.jar \\\n        |  --input data/mllib/sample_linear_regression_data.txt\n        ")).stripMargin());
            }
        };
        parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(MultivariateSummarizer.Params params) {
                MultivariateSummarizer$.MODULE$.run(params);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return package$.MODULE$.exit(1);
            }
        });
    }

    public void run(MultivariateSummarizer.Params params) {
        SparkConf conf = new SparkConf().setAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MultivariateSummarizer with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params})));
        SparkContext sc = new SparkContext(conf);
        RDD examples = MLUtils$.MODULE$.loadLibSVMFile(sc, params.input()).cache();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Summary of data file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.input()})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " data points"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)examples.count())})));
        MultivariateOnlineSummarizer labelSummary = (MultivariateOnlineSummarizer)examples.aggregate((Object)new MultivariateOnlineSummarizer(), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final MultivariateOnlineSummarizer apply(MultivariateOnlineSummarizer summary, LabeledPoint lp) {
                return summary.add(Vectors$.MODULE$.dense(lp.label(), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])));
            }
        }, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final MultivariateOnlineSummarizer apply(MultivariateOnlineSummarizer sum1, MultivariateOnlineSummarizer sum2) {
                return sum1.merge(sum2);
            }
        }, ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
        MultivariateOnlineSummarizer featureSummary = (MultivariateOnlineSummarizer)examples.aggregate((Object)new MultivariateOnlineSummarizer(), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final MultivariateOnlineSummarizer apply(MultivariateOnlineSummarizer summary, LabeledPoint lp) {
                return summary.add(lp.features());
            }
        }, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final MultivariateOnlineSummarizer apply(MultivariateOnlineSummarizer sum1, MultivariateOnlineSummarizer sum2) {
                return sum1.merge(sum2);
            }
        }, ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Summary statistics"})).s((Seq)Nil$.MODULE$));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tLabel\\tFeatures"})).s((Seq)Nil$.MODULE$));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mean\\t", "\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)labelSummary.mean().apply(0)), Predef$.MODULE$.doubleArrayOps(featureSummary.mean().toArray()).mkString("\t")})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var\\t", "\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)labelSummary.variance().apply(0)), Predef$.MODULE$.doubleArrayOps(featureSummary.variance().toArray()).mkString("\t")})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"nnz\\t", "\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)labelSummary.numNonzeros().apply(0)), Predef$.MODULE$.doubleArrayOps(featureSummary.numNonzeros().toArray()).mkString("\t")})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"max\\t", "\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)labelSummary.max().apply(0)), Predef$.MODULE$.doubleArrayOps(featureSummary.max().toArray()).mkString("\t")})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"min\\t", "\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)labelSummary.min().apply(0)), Predef$.MODULE$.doubleArrayOps(featureSummary.min().toArray()).mkString("\t")})));
        Predef$.MODULE$.println();
        sc.stop();
    }

    private MultivariateSummarizer$() {
        MODULE$ = this;
    }
}

