/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.FPGrowthExample;
import org.apache.spark.examples.mllib.FPGrowthExample$Params$;
import org.apache.spark.mllib.fpm.FPGrowth;
import org.apache.spark.mllib.fpm.FPGrowthModel;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scopt.OptionParser;
import scopt.Read$;

public final class FPGrowthExample$ {
    public static final FPGrowthExample$ MODULE$;

    static {
        new FPGrowthExample$();
    }

    public void main(String[] args) {
        FPGrowthExample.Params defaultParams = new FPGrowthExample.Params(FPGrowthExample$Params$.MODULE$.apply$default$1(), FPGrowthExample$Params$.MODULE$.apply$default$2(), FPGrowthExample$Params$.MODULE$.apply$default$3());
        OptionParser<FPGrowthExample.Params> parser = new OptionParser<FPGrowthExample.Params>(defaultParams){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FPGrowth: an example FP-growth app."}));
                this.opt("minSupport", Read$.MODULE$.doubleRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"minimal support level, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)defaultParams$1.minSupport())}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FPGrowthExample.Params apply(double x, FPGrowthExample.Params c) {
                        double x$2 = x;
                        String x$3 = c.copy$default$1();
                        int x$4 = c.copy$default$3();
                        return c.copy(x$3, x$2, x$4);
                    }
                });
                this.opt("numPartition", Read$.MODULE$.intRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of partition, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.numPartition())}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FPGrowthExample.Params apply(int x, FPGrowthExample.Params c) {
                        int x$5 = x;
                        String x$6 = c.copy$default$1();
                        double x$7 = c.copy$default$2();
                        return c.copy(x$6, x$7, x$5);
                    }
                });
                this.arg("<input>", Read$.MODULE$.stringRead()).text("input paths to input data set, whose file format is that each line contains a transaction with each item in String and separated by a space").required().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FPGrowthExample.Params apply(String x, FPGrowthExample.Params c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3());
                    }
                });
            }
        };
        parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(FPGrowthExample.Params params) {
                FPGrowthExample$.MODULE$.run(params);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return package$.MODULE$.exit(1);
            }
        });
    }

    public void run(FPGrowthExample.Params params) {
        SparkConf conf = new SparkConf().setAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FPGrowthExample with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params})));
        SparkContext sc = new SparkContext(conf);
        RDD transactions = sc.textFile(params.input(), sc.textFile$default$2()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$1) {
                return x$1.split(" ");
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).cache();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of transactions: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)transactions.count())})));
        FPGrowthModel model = new FPGrowth().setMinSupport(params.minSupport()).setNumPartitions(params.numPartition()).run(transactions, ClassTag$.MODULE$.apply(String.class));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of frequent itemsets: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)model.freqItemsets().count())})));
        Predef$.MODULE$.refArrayOps((Object[])model.freqItemsets().collect()).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(FPGrowth.FreqItemset<String> itemset) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)Predef$.MODULE$.refArrayOps((Object[])itemset.items()).mkString("[", ",", "]")).append((Object)", ").append((Object)BoxesRunTime.boxToLong((long)itemset.freq())).toString());
            }
        });
        sc.stop();
    }

    private FPGrowthExample$() {
        MODULE$ = this;
    }
}

