/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.feature.QuantileDiscretizer;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaQuantileDiscretizerExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaQuantileDiscretizerExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        SQLContext sqlContext = new SQLContext(jsc);
        JavaRDD jrdd = jsc.parallelize(Arrays.asList(RowFactory.create((Object[])new Object[]{0, 18.0}), RowFactory.create((Object[])new Object[]{1, 19.0}), RowFactory.create((Object[])new Object[]{2, 8.0}), RowFactory.create((Object[])new Object[]{3, 5.0}), RowFactory.create((Object[])new Object[]{4, 2.2})));
        StructType schema = new StructType(new StructField[]{new StructField("id", DataTypes.IntegerType, false, Metadata.empty()), new StructField("hour", DataTypes.DoubleType, false, Metadata.empty())});
        DataFrame df = sqlContext.createDataFrame(jrdd, schema);
        QuantileDiscretizer discretizer = new QuantileDiscretizer().setInputCol("hour").setOutputCol("result").setNumBuckets(3);
        DataFrame result = discretizer.fit(df).transform(df);
        result.show();
        jsc.stop();
    }
}

