/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.feature.NGram;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaNGramExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaNGramExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        SQLContext sqlContext = new SQLContext(jsc);
        JavaRDD jrdd = jsc.parallelize(Arrays.asList(RowFactory.create((Object[])new Object[]{0.0, Arrays.asList("Hi", "I", "heard", "about", "Spark")}), RowFactory.create((Object[])new Object[]{1.0, Arrays.asList("I", "wish", "Java", "could", "use", "case", "classes")}), RowFactory.create((Object[])new Object[]{2.0, Arrays.asList("Logistic", "regression", "models", "are", "neat")})));
        StructType schema = new StructType(new StructField[]{new StructField("label", DataTypes.DoubleType, false, Metadata.empty()), new StructField("words", (DataType)DataTypes.createArrayType((DataType)DataTypes.StringType), false, Metadata.empty())});
        DataFrame wordDataFrame = sqlContext.createDataFrame(jrdd, schema);
        NGram ngramTransformer = (NGram)((NGram)new NGram().setInputCol("words")).setOutputCol("ngrams");
        DataFrame ngramDataFrame = ngramTransformer.transform(wordDataFrame);
        for (Row r : ngramDataFrame.select("ngrams", new String[]{"label"}).take(3)) {
            List ngrams = r.getList(0);
            for (String ngram : ngrams) {
                System.out.print(ngram + " --- ");
            }
            System.out.println();
        }
        jsc.stop();
    }
}

