/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import com.google.common.io.Files;
import java.io.File;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.ml.DataFrameExample;
import org.apache.spark.examples.ml.DataFrameExample$;
import org.apache.spark.examples.ml.DataFrameExample$Params$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;
import scala.util.Either;
import scopt.OptionParser;
import scopt.Read$;

public final class DataFrameExample$ {
    public static final DataFrameExample$ MODULE$;

    static {
        new DataFrameExample$();
    }

    public void main(String[] args) {
        DataFrameExample.Params defaultParams = new DataFrameExample.Params(DataFrameExample$Params$.MODULE$.apply$default$1());
        OptionParser<DataFrameExample.Params> parser = new OptionParser<DataFrameExample.Params>(){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DataFrameExample: an example app using DataFrame for ML."}));
                this.opt("input", Read$.MODULE$.stringRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input path to dataframe"})).s((Seq)Nil$.MODULE$)).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DataFrameExample.Params apply(String x, DataFrameExample.Params c) {
                        return c.copy(x);
                    }
                });
                this.checkConfig((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final Either<String, BoxedUnit> apply(DataFrameExample.Params params) {
                        return this.$outer.success();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
        };
        parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(DataFrameExample.Params params) {
                DataFrameExample$.MODULE$.run(params);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return package$.MODULE$.exit(1);
            }
        });
    }

    public void run(DataFrameExample.Params params) {
        SparkConf conf = new SparkConf().setAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DataFrameExample with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params})));
        SparkContext sc = new SparkContext(conf);
        SQLContext sqlContext = new SQLContext(sc);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading LIBSVM file with UDT from ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.input()})));
        DataFrame df = sqlContext.read().format("libsvm").load(params.input()).cache();
        Predef$.MODULE$.println((Object)"Schema from LIBSVM:");
        df.printSchema();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded training data as a DataFrame with ", " records."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)df.count())})));
        DataFrame labelSummary = df.describe((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"}));
        labelSummary.show();
        RDD features = df.select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Vector apply(Row x0$1) {
                Object v;
                Row row = x0$1;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (v = ((SeqLike)some.get()).apply(0)) instanceof Vector) {
                    Vector vector;
                    Vector vector2 = vector = (Vector)v;
                    return vector2;
                }
                throw new MatchError((Object)row);
            }
        }, ClassTag$.MODULE$.apply(Vector.class));
        MultivariateOnlineSummarizer featureSummary = (MultivariateOnlineSummarizer)features.aggregate((Object)new MultivariateOnlineSummarizer(), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final MultivariateOnlineSummarizer apply(MultivariateOnlineSummarizer summary, Vector feat) {
                return summary.add(feat);
            }
        }, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final MultivariateOnlineSummarizer apply(MultivariateOnlineSummarizer sum1, MultivariateOnlineSummarizer sum2) {
                return sum1.merge(sum2);
            }
        }, ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Selected features column with average values:\\n ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{featureSummary.mean().toString()})));
        File tmpDir = Files.createTempDir();
        tmpDir.deleteOnExit();
        String outputDir = new File(tmpDir, "dataframe").toString();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Saving to ", " as Parquet file."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputDir})));
        df.write().parquet(outputDir);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading Parquet file with UDT from ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputDir})));
        DataFrame newDF = sqlContext.read().parquet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{outputDir}));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schema from Parquet:"})).s((Seq)Nil$.MODULE$));
        newDF.printSchema();
        sc.stop();
    }

    private DataFrameExample$() {
        MODULE$ = this;
    }
}

