/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.StorageLevels;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.examples.streaming.StreamingExamples;
import org.apache.spark.streaming.Durations;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import scala.Tuple2;

public class JavaStatefulNetworkWordCount {
    private static final Pattern SPACE = Pattern.compile(" ");

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: JavaStatefulNetworkWordCount <hostname> <port>");
            System.exit(1);
        }
        StreamingExamples.setStreamingLogLevels();
        Function2<List<Integer>, Optional<Integer>, Optional<Integer>> updateFunction = new Function2<List<Integer>, Optional<Integer>, Optional<Integer>>(){

            public Optional<Integer> call(List<Integer> values, Optional<Integer> state) {
                Integer newSum = (Integer)state.or((Object)0);
                for (Integer value : values) {
                    newSum = newSum + value;
                }
                return Optional.of((Object)newSum);
            }
        };
        SparkConf sparkConf = new SparkConf().setAppName("JavaStatefulNetworkWordCount");
        JavaStreamingContext ssc = new JavaStreamingContext(sparkConf, Durations.seconds((long)1L));
        ssc.checkpoint(".");
        List<Tuple2> tuples = Arrays.asList(new Tuple2((Object)"hello", (Object)1), new Tuple2((Object)"world", (Object)1));
        JavaPairRDD initialRDD = ssc.sparkContext().parallelizePairs(tuples);
        JavaReceiverInputDStream lines = ssc.socketTextStream(args[0], Integer.parseInt(args[1]), StorageLevels.MEMORY_AND_DISK_SER_2);
        JavaDStream words = lines.flatMap((FlatMapFunction)new FlatMapFunction<String, String>(){

            public Iterable<String> call(String x) {
                return Lists.newArrayList((Object[])SPACE.split(x));
            }
        });
        JavaPairDStream wordsDstream = words.mapToPair((PairFunction)new PairFunction<String, String, Integer>(){

            public Tuple2<String, Integer> call(String s) {
                return new Tuple2((Object)s, (Object)1);
            }
        });
        JavaPairDStream stateDstream = wordsDstream.updateStateByKey((Function2)updateFunction, (Partitioner)new HashPartitioner(ssc.sparkContext().defaultParallelism().intValue()), initialRDD);
        stateDstream.print();
        ssc.start();
        ssc.awaitTermination();
    }
}

