/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.streaming.Durations;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.api.java.JavaStreamingContextFactory;
import scala.Tuple2;

public final class JavaRecoverableNetworkWordCount {
    private static final Pattern SPACE = Pattern.compile(" ");

    private static JavaStreamingContext createContext(String ip, int port, String checkpointDirectory, String outputPath) {
        System.out.println("Creating new context");
        final File outputFile = new File(outputPath);
        if (outputFile.exists()) {
            outputFile.delete();
        }
        SparkConf sparkConf = new SparkConf().setAppName("JavaRecoverableNetworkWordCount");
        JavaStreamingContext ssc = new JavaStreamingContext(sparkConf, Durations.seconds((long)1L));
        ssc.checkpoint(checkpointDirectory);
        JavaReceiverInputDStream lines = ssc.socketTextStream(ip, port);
        JavaDStream words = lines.flatMap((FlatMapFunction)new FlatMapFunction<String, String>(){

            public Iterable<String> call(String x) {
                return Lists.newArrayList((Object[])SPACE.split(x));
            }
        });
        JavaPairDStream wordCounts = words.mapToPair((PairFunction)new PairFunction<String, String, Integer>(){

            public Tuple2<String, Integer> call(String s) {
                return new Tuple2((Object)s, (Object)1);
            }
        }).reduceByKey((Function2)new Function2<Integer, Integer, Integer>(){

            public Integer call(Integer i1, Integer i2) {
                return i1 + i2;
            }
        });
        wordCounts.foreachRDD((Function2)new Function2<JavaPairRDD<String, Integer>, Time, Void>(){

            public Void call(JavaPairRDD<String, Integer> rdd, Time time) throws IOException {
                String counts = "Counts at time " + time + " " + rdd.collect();
                System.out.println(counts);
                System.out.println("Appending to " + outputFile.getAbsolutePath());
                Files.append((CharSequence)(counts + "\n"), (File)outputFile, (Charset)Charset.defaultCharset());
                return null;
            }
        });
        return ssc;
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            System.err.println("You arguments were " + Arrays.asList(args));
            System.err.println("Usage: JavaRecoverableNetworkWordCount <hostname> <port> <checkpoint-directory>\n     <output-file>. <hostname> and <port> describe the TCP server that Spark\n     Streaming would connect to receive data. <checkpoint-directory> directory to\n     HDFS-compatible file system which checkpoint data <output-file> file to which\n     the word counts will be appended\n\nIn local mode, <master> should be 'local[n]' with n > 1\nBoth <checkpoint-directory> and <output-file> must be absolute paths");
            System.exit(1);
        }
        final String ip = args[0];
        final int port = Integer.parseInt(args[1]);
        final String checkpointDirectory = args[2];
        final String outputPath = args[3];
        JavaStreamingContextFactory factory = new JavaStreamingContextFactory(){

            public JavaStreamingContext create() {
                return JavaRecoverableNetworkWordCount.createContext(ip, port, checkpointDirectory, outputPath);
            }
        };
        JavaStreamingContext ssc = JavaStreamingContext.getOrCreate((String)checkpointDirectory, (JavaStreamingContextFactory)factory);
        ssc.start();
        ssc.awaitTermination();
    }
}

