/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.LDAExample;
import org.apache.spark.examples.mllib.LDAExample$;
import org.apache.spark.examples.mllib.LDAExample$Params$;
import org.apache.spark.examples.mllib.SimpleTokenizer;
import org.apache.spark.mllib.clustering.DistributedLDAModel;
import org.apache.spark.mllib.clustering.EMLDAOptimizer;
import org.apache.spark.mllib.clustering.LDA;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.clustering.OnlineLDAOptimizer;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scopt.OptionParser;
import scopt.Read$;

public final class LDAExample$ {
    public static final LDAExample$ MODULE$;

    static {
        new LDAExample$();
    }

    public void main(String[] args) {
        LDAExample.Params defaultParams = new LDAExample.Params(LDAExample$Params$.MODULE$.apply$default$1(), LDAExample$Params$.MODULE$.apply$default$2(), LDAExample$Params$.MODULE$.apply$default$3(), LDAExample$Params$.MODULE$.apply$default$4(), LDAExample$Params$.MODULE$.apply$default$5(), LDAExample$Params$.MODULE$.apply$default$6(), LDAExample$Params$.MODULE$.apply$default$7(), LDAExample$Params$.MODULE$.apply$default$8(), LDAExample$Params$.MODULE$.apply$default$9(), LDAExample$Params$.MODULE$.apply$default$10());
        OptionParser<LDAExample.Params> parser = new OptionParser<LDAExample.Params>(defaultParams){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LDAExample: an example LDA app for plain text data."}));
                this.opt("k", Read$.MODULE$.intRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of topics. default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.k())}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LDAExample.Params apply(int x, LDAExample.Params c) {
                        int x$11 = x;
                        Seq<String> x$12 = c.copy$default$1();
                        int x$13 = c.copy$default$3();
                        double x$14 = c.copy$default$4();
                        double x$15 = c.copy$default$5();
                        int x$16 = c.copy$default$6();
                        String x$17 = c.copy$default$7();
                        String x$18 = c.copy$default$8();
                        Option<String> x$19 = c.copy$default$9();
                        int x$20 = c.copy$default$10();
                        return c.copy(x$12, x$11, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
                    }
                });
                this.opt("maxIterations", Read$.MODULE$.intRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of iterations of learning. default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.maxIterations())}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LDAExample.Params apply(int x, LDAExample.Params c) {
                        int x$21 = x;
                        Seq<String> x$22 = c.copy$default$1();
                        int x$23 = c.copy$default$2();
                        double x$24 = c.copy$default$4();
                        double x$25 = c.copy$default$5();
                        int x$26 = c.copy$default$6();
                        String x$27 = c.copy$default$7();
                        String x$28 = c.copy$default$8();
                        Option<String> x$29 = c.copy$default$9();
                        int x$30 = c.copy$default$10();
                        return c.copy(x$22, x$23, x$21, x$24, x$25, x$26, x$27, x$28, x$29, x$30);
                    }
                });
                this.opt("docConcentration", Read$.MODULE$.doubleRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount of topic smoothing to use (> 1.0) (-1=auto)."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)defaultParams$1.docConcentration())}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LDAExample.Params apply(double x, LDAExample.Params c) {
                        double x$31 = x;
                        Seq<String> x$32 = c.copy$default$1();
                        int x$33 = c.copy$default$2();
                        int x$34 = c.copy$default$3();
                        double x$35 = c.copy$default$5();
                        int x$36 = c.copy$default$6();
                        String x$37 = c.copy$default$7();
                        String x$38 = c.copy$default$8();
                        Option<String> x$39 = c.copy$default$9();
                        int x$40 = c.copy$default$10();
                        return c.copy(x$32, x$33, x$34, x$31, x$35, x$36, x$37, x$38, x$39, x$40);
                    }
                });
                this.opt("topicConcentration", Read$.MODULE$.doubleRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount of term (word) smoothing to use (> 1.0) (-1=auto)."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)defaultParams$1.topicConcentration())}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LDAExample.Params apply(double x, LDAExample.Params c) {
                        double x$41 = x;
                        Seq<String> x$42 = c.copy$default$1();
                        int x$43 = c.copy$default$2();
                        int x$44 = c.copy$default$3();
                        double x$45 = c.copy$default$4();
                        int x$46 = c.copy$default$6();
                        String x$47 = c.copy$default$7();
                        String x$48 = c.copy$default$8();
                        Option<String> x$49 = c.copy$default$9();
                        int x$50 = c.copy$default$10();
                        return c.copy(x$42, x$43, x$44, x$45, x$41, x$46, x$47, x$48, x$49, x$50);
                    }
                });
                this.opt("vocabSize", Read$.MODULE$.intRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of distinct word types to use, chosen by frequency. (-1=all)"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.vocabSize())}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LDAExample.Params apply(int x, LDAExample.Params c) {
                        int x$51 = x;
                        Seq<String> x$52 = c.copy$default$1();
                        int x$53 = c.copy$default$2();
                        int x$54 = c.copy$default$3();
                        double x$55 = c.copy$default$4();
                        double x$56 = c.copy$default$5();
                        String x$57 = c.copy$default$7();
                        String x$58 = c.copy$default$8();
                        Option<String> x$59 = c.copy$default$9();
                        int x$60 = c.copy$default$10();
                        return c.copy(x$52, x$53, x$54, x$55, x$56, x$51, x$57, x$58, x$59, x$60);
                    }
                });
                this.opt("stopwordFile", Read$.MODULE$.stringRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"filepath for a list of stopwords. Note: This must fit on a single machine."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultParams$1.stopwordFile()}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LDAExample.Params apply(String x, LDAExample.Params c) {
                        String x$61 = x;
                        Seq<String> x$62 = c.copy$default$1();
                        int x$63 = c.copy$default$2();
                        int x$64 = c.copy$default$3();
                        double x$65 = c.copy$default$4();
                        double x$66 = c.copy$default$5();
                        int x$67 = c.copy$default$6();
                        String x$68 = c.copy$default$8();
                        Option<String> x$69 = c.copy$default$9();
                        int x$70 = c.copy$default$10();
                        return c.copy(x$62, x$63, x$64, x$65, x$66, x$67, x$61, x$68, x$69, x$70);
                    }
                });
                this.opt("algorithm", Read$.MODULE$.stringRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"inference algorithm to use. em and online are supported."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultParams$1.algorithm()}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LDAExample.Params apply(String x, LDAExample.Params c) {
                        String x$71 = x;
                        Seq<String> x$72 = c.copy$default$1();
                        int x$73 = c.copy$default$2();
                        int x$74 = c.copy$default$3();
                        double x$75 = c.copy$default$4();
                        double x$76 = c.copy$default$5();
                        int x$77 = c.copy$default$6();
                        String x$78 = c.copy$default$7();
                        Option<String> x$79 = c.copy$default$9();
                        int x$80 = c.copy$default$10();
                        return c.copy(x$72, x$73, x$74, x$75, x$76, x$77, x$78, x$71, x$79, x$80);
                    }
                });
                this.opt("checkpointDir", Read$.MODULE$.stringRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Directory for checkpointing intermediate results."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  Checkpointing helps with recovery and eliminates temporary shuffle files on disk."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultParams$1.checkpointDir()}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LDAExample.Params apply(String x, LDAExample.Params c) {
                        Some x$81 = new Some((Object)x);
                        Seq<String> x$82 = c.copy$default$1();
                        int x$83 = c.copy$default$2();
                        int x$84 = c.copy$default$3();
                        double x$85 = c.copy$default$4();
                        double x$86 = c.copy$default$5();
                        int x$87 = c.copy$default$6();
                        String x$88 = c.copy$default$7();
                        String x$89 = c.copy$default$8();
                        int x$90 = c.copy$default$10();
                        return c.copy(x$82, x$83, x$84, x$85, x$86, x$87, x$88, x$89, (Option<String>)x$81, x$90);
                    }
                });
                this.opt("checkpointInterval", Read$.MODULE$.intRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Iterations between each checkpoint.  Only used if checkpointDir is set."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.checkpointInterval())}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LDAExample.Params apply(int x, LDAExample.Params c) {
                        int x$91 = x;
                        Seq<String> x$92 = c.copy$default$1();
                        int x$93 = c.copy$default$2();
                        int x$94 = c.copy$default$3();
                        double x$95 = c.copy$default$4();
                        double x$96 = c.copy$default$5();
                        int x$97 = c.copy$default$6();
                        String x$98 = c.copy$default$7();
                        String x$99 = c.copy$default$8();
                        Option<String> x$100 = c.copy$default$9();
                        return c.copy(x$92, x$93, x$94, x$95, x$96, x$97, x$98, x$99, x$100, x$91);
                    }
                });
                this.arg("<input>...", Read$.MODULE$.stringRead()).text("input paths (directories) to plain text corpora.  Each text file line should hold 1 document.").unbounded().required().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LDAExample.Params apply(String x, LDAExample.Params c) {
                        return c.copy((Seq<String>)((Seq)c.input().$colon$plus((Object)x, Seq$.MODULE$.canBuildFrom())), c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10());
                    }
                });
            }
        };
        parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(LDAExample.Params params) {
                LDAExample$.MODULE$.org$apache$spark$examples$mllib$LDAExample$$run(params);
            }
        }).getOrElse((Function0)new Serializable((OptionParser)parser){
            public static final long serialVersionUID = 0L;
            private final OptionParser parser$1;

            public final Nothing$ apply() {
                this.parser$1.showUsageAsError();
                return package$.MODULE$.exit(1);
            }
            {
                this.parser$1 = parser$1;
            }
        });
    }

    public void org$apache$spark$examples$mllib$LDAExample$$run(LDAExample.Params params) {
        Tuple3<RDD<Tuple2<Object, Vector>>, String[], Object> tuple3;
        block5: {
            block8: {
                EMLDAOptimizer eMLDAOptimizer;
                LDA lda;
                long actualCorpusSize;
                String[] vocabArray;
                RDD corpus;
                SparkContext sc;
                block7: {
                    String string;
                    block6: {
                        Tuple3 tuple32;
                        SparkConf conf = new SparkConf().setAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LDAExample with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params})));
                        sc = new SparkContext(conf);
                        Logger.getRootLogger().setLevel(Level.WARN);
                        long preprocessStart = System.nanoTime();
                        tuple3 = this.preprocess(sc, params.input(), params.vocabSize(), params.stopwordFile());
                        if (tuple3 == null) break block5;
                        RDD corpus2 = (RDD)tuple3._1();
                        String[] vocabArray2 = (String[])tuple3._2();
                        long actualNumTokens = BoxesRunTime.unboxToLong((Object)tuple3._3());
                        Tuple3 tuple33 = tuple32 = new Tuple3((Object)corpus2, (Object)vocabArray2, (Object)BoxesRunTime.boxToLong((long)actualNumTokens));
                        corpus = (RDD)tuple33._1();
                        vocabArray = (String[])tuple33._2();
                        long actualNumTokens2 = BoxesRunTime.unboxToLong((Object)tuple33._3());
                        corpus.cache();
                        actualCorpusSize = corpus.count();
                        int actualVocabSize = Predef$.MODULE$.refArrayOps((Object[])vocabArray).size();
                        double preprocessElapsed = (double)(System.nanoTime() - preprocessStart) / 1.0E9;
                        Predef$.MODULE$.println();
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corpus summary:"})).s((Seq)Nil$.MODULE$));
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t Training set size: ", " documents"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)actualCorpusSize)})));
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t Vocabulary size: ", " terms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)actualVocabSize)})));
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t Training set size: ", " tokens"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)actualNumTokens2)})));
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t Preprocessing time: ", " sec"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)preprocessElapsed)})));
                        Predef$.MODULE$.println();
                        lda = new LDA();
                        String string2 = string = params.algorithm().toLowerCase();
                        if ("em" != null ? !"em".equals(string2) : string2 != null) break block6;
                        eMLDAOptimizer = new EMLDAOptimizer();
                        break block7;
                    }
                    String string3 = string;
                    if ("online" != null ? !"online".equals(string3) : string3 != null) break block8;
                    eMLDAOptimizer = new OnlineLDAOptimizer().setMiniBatchFraction(0.05 + 1.0 / (double)actualCorpusSize);
                }
                EMLDAOptimizer optimizer = eMLDAOptimizer;
                lda.setOptimizer((LDAOptimizer)optimizer).setK(params.k()).setMaxIterations(params.maxIterations()).setDocConcentration(params.docConcentration()).setTopicConcentration(params.topicConcentration()).setCheckpointInterval(params.checkpointInterval());
                if (params.checkpointDir().nonEmpty()) {
                    sc.setCheckpointDir((String)params.checkpointDir().get());
                }
                long startTime = System.nanoTime();
                LDAModel ldaModel = lda.run(corpus);
                double elapsed = (double)(System.nanoTime() - startTime) / 1.0E9;
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished training LDA model.  Summary:"})).s((Seq)Nil$.MODULE$));
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t Training time: ", " sec"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)elapsed)})));
                if (ldaModel instanceof DistributedLDAModel) {
                    DistributedLDAModel distLDAModel = (DistributedLDAModel)ldaModel;
                    double avgLogLikelihood = distLDAModel.logLikelihood() / (double)actualCorpusSize;
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t Training data average log likelihood: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)avgLogLikelihood)})));
                    Predef$.MODULE$.println();
                }
                Tuple2[] topicIndices = ldaModel.describeTopics(10);
                Tuple2[][] topics = (Tuple2[][])Predef$.MODULE$.refArrayOps((Object[])topicIndices).map((Function1)new Serializable(vocabArray){
                    public static final long serialVersionUID = 0L;
                    public final String[] vocabArray$1;

                    public final Tuple2<String, Object>[] apply(Tuple2<int[], double[]> x0$1) {
                        Tuple2<int[], double[]> tuple2 = x0$1;
                        if (tuple2 != null) {
                            int[] terms = (int[])tuple2._1();
                            double[] termWeights = (double[])tuple2._2();
                            Tuple2[] tuple2Array = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(terms).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(termWeights), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.13 $outer;

                                public final Tuple2<String, Object> apply(Tuple2<Object, Object> x0$2) {
                                    Tuple2<Object, Object> tuple2 = x0$2;
                                    if (tuple2 != null) {
                                        int term = tuple2._1$mcI$sp();
                                        double weight = tuple2._2$mcD$sp();
                                        Tuple2 tuple22 = new Tuple2((Object)this.$outer.vocabArray$1[term], (Object)BoxesRunTime.boxToDouble((double)weight));
                                        return tuple22;
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                            return tuple2Array;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.vocabArray$1 = vocabArray$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class))));
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " topics:"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)params.k())})));
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])topics).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Tuple2<Tuple2<String, Object>[], Object> x0$3) {
                        Tuple2<Tuple2<String, Object>[], Object> tuple2 = x0$3;
                        if (tuple2 != null) {
                            Tuple2[] topic = (Tuple2[])tuple2._1();
                            int i = tuple2._2$mcI$sp();
                            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TOPIC ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
                            Predef$.MODULE$.refArrayOps((Object[])topic).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply(Tuple2<String, Object> x0$4) {
                                    Tuple2<String, Object> tuple2 = x0$4;
                                    if (tuple2 != null) {
                                        String term = (String)tuple2._1();
                                        double weight = tuple2._2$mcD$sp();
                                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{term, BoxesRunTime.boxToDouble((double)weight)})));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return;
                                    }
                                    throw new MatchError(tuple2);
                                }
                            });
                            Predef$.MODULE$.println();
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                });
                sc.stop();
                return;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only em, online are supported but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.algorithm()})));
        }
        throw new MatchError(tuple3);
    }

    private Tuple3<RDD<Tuple2<Object, Vector>>, String[], Object> preprocess(SparkContext sc, Seq<String> paths, int vocabSize, String stopwordFile) {
        RDD textRDD = sc.textFile(paths.mkString(","), sc.textFile$default$2());
        SimpleTokenizer tokenizer = new SimpleTokenizer(sc, stopwordFile);
        RDD tokenized = textRDD.zipWithIndex().map((Function1)new Serializable(tokenizer){
            public static final long serialVersionUID = 0L;
            private final SimpleTokenizer tokenizer$1;

            public final Tuple2<Object, IndexedSeq<String>> apply(Tuple2<String, Object> x0$5) {
                Tuple2<String, Object> tuple2 = x0$5;
                if (tuple2 != null) {
                    String text = (String)tuple2._1();
                    long id = tuple2._2$mcJ$sp();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToLong((long)id)), this.tokenizer$1.getWords(text));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.tokenizer$1 = tokenizer$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        tokenized.cache();
        RDD wordCounts = RDD$.MODULE$.rddToPairRDDFunctions(tokenized.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final IndexedSeq<Tuple2<String, Object>> apply(Tuple2<Object, IndexedSeq<String>> x0$6) {
                Tuple2<Object, IndexedSeq<String>> tuple2 = x0$6;
                if (tuple2 != null) {
                    IndexedSeq tokens = (IndexedSeq)tuple2._2();
                    IndexedSeq indexedSeq = (IndexedSeq)tokens.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<String, Object> apply(String x$2) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)x$2), (Object)BoxesRunTime.boxToLong((long)1L));
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                    return indexedSeq;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Long(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(long x$3, long x$4) {
                return this.apply$mcJJJ$sp(x$3, x$4);
            }

            public long apply$mcJJJ$sp(long x$3, long x$4) {
                return x$3 + x$4;
            }
        });
        wordCounts.cache();
        long fullVocabSize = wordCounts.count();
        Tuple2[] tmpSortedWC = vocabSize == -1 || fullVocabSize <= (long)vocabSize ? (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])wordCounts.collect()).sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<String, Object> x$5) {
                return -x$5._2$mcJ$sp();
            }
        }, (Ordering)Ordering.Long$.MODULE$) : (Tuple2[])wordCounts.sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<String, Object> x$6) {
                return x$6._2$mcJ$sp();
            }
        }, false, wordCounts.sortBy$default$3(), (Ordering)Ordering.Long$.MODULE$, ClassTag$.MODULE$.Long()).take(vocabSize);
        Tuple2 tuple2 = new Tuple2((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])tmpSortedWC).map((Function1)new anonfun.18(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.conforms()), Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])tmpSortedWC).map((Function1)new anonfun.19(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        if (tuple2 != null) {
            Map vocab = (Map)tuple2._1();
            long selectedTokenCount = tuple2._2$mcJ$sp();
            if (vocab != null) {
                Tuple2 tuple22;
                Map map = vocab;
                long l = selectedTokenCount;
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)map, (Object)BoxesRunTime.boxToLong((long)l));
                Map vocab2 = (Map)tuple23._1();
                long selectedTokenCount2 = tuple23._2$mcJ$sp();
                RDD documents = tokenized.map((Function1)new Serializable(vocab2){
                    public static final long serialVersionUID = 0L;
                    public final Map vocab$1;

                    public final Tuple2<Object, Vector> apply(Tuple2<Object, IndexedSeq<String>> x0$7) {
                        Tuple2<Object, IndexedSeq<String>> tuple2 = x0$7;
                        if (tuple2 != null) {
                            long id = tuple2._1$mcJ$sp();
                            IndexedSeq tokens = (IndexedSeq)tuple2._2();
                            HashMap wc = new HashMap();
                            tokens.foreach((Function1)new Serializable(this, wc){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.20 $outer;
                                private final HashMap wc$1;

                                public final void apply(String term) {
                                    if (this.$outer.vocab$1.contains((Object)term)) {
                                        int termIndex = BoxesRunTime.unboxToInt((Object)this.$outer.vocab$1.apply((Object)term));
                                        this.wc$1.update((Object)BoxesRunTime.boxToInteger((int)termIndex), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.wc$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)termIndex), (Function0)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final int apply() {
                                                return this.apply$mcI$sp();
                                            }

                                            public int apply$mcI$sp() {
                                                return 0;
                                            }
                                        })) + 1)));
                                    }
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.wc$1 = wc$1;
                                }
                            });
                            int[] indices = (int[])Predef$.MODULE$.intArrayOps((int[])wc.keys().toArray(ClassTag$.MODULE$.Int())).sorted((Ordering)Ordering.Int$.MODULE$);
                            double[] values = (double[])Predef$.MODULE$.intArrayOps(indices).map((Function1)new Serializable(this, wc){
                                public static final long serialVersionUID = 0L;
                                private final HashMap wc$1;

                                public final double apply(int i) {
                                    return this.apply$mcDI$sp(i);
                                }

                                public double apply$mcDI$sp(int i) {
                                    return BoxesRunTime.unboxToInt((Object)this.wc$1.apply((Object)BoxesRunTime.boxToInteger((int)i)));
                                }
                                {
                                    this.wc$1 = wc$1;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                            Vector sb = Vectors$.MODULE$.sparse(this.vocab$1.size(), indices, values);
                            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)id), (Object)sb);
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.vocab$1 = vocab$1;
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class));
                String[] vocabArray = new String[vocab2.size()];
                vocab2.foreach((Function1)new Serializable(vocabArray){
                    public static final long serialVersionUID = 0L;
                    private final String[] vocabArray$2;

                    public final void apply(Tuple2<String, Object> x0$8) {
                        Tuple2<String, Object> tuple2 = x0$8;
                        if (tuple2 != null) {
                            String term = (String)tuple2._1();
                            int i = tuple2._2$mcI$sp();
                            this.vocabArray$2[i] = term;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.vocabArray$2 = vocabArray$2;
                    }
                });
                return new Tuple3((Object)documents, (Object)vocabArray, (Object)BoxesRunTime.boxToLong((long)selectedTokenCount2));
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private LDAExample$() {
        MODULE$ = this;
    }
}

