/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.util.HashMap;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.RandomForest;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.mllib.util.MLUtils;
import scala.Tuple2;

public final class JavaRandomForestExample {
    private static void testClassification(JavaRDD<LabeledPoint> trainingData, JavaRDD<LabeledPoint> testData) {
        Integer numClasses = 2;
        HashMap categoricalFeaturesInfo = new HashMap();
        Integer numTrees = 3;
        String featureSubsetStrategy = "auto";
        String impurity = "gini";
        Integer maxDepth = 4;
        Integer maxBins = 32;
        Integer seed = 12345;
        final RandomForestModel model = RandomForest.trainClassifier(trainingData, (int)numClasses, categoricalFeaturesInfo, (int)numTrees, (String)featureSubsetStrategy, (String)impurity, (int)maxDepth, (int)maxBins, (int)seed);
        JavaPairRDD predictionAndLabel = testData.mapToPair((PairFunction)new PairFunction<LabeledPoint, Double, Double>(){

            public Tuple2<Double, Double> call(LabeledPoint p) {
                return new Tuple2((Object)model.predict(p.features()), (Object)p.label());
            }
        });
        Double testErr = 1.0 * (double)predictionAndLabel.filter((Function)new Function<Tuple2<Double, Double>, Boolean>(){

            public Boolean call(Tuple2<Double, Double> pl) {
                return !((Double)pl._1()).equals(pl._2());
            }
        }).count() / (double)testData.count();
        System.out.println("Test Error: " + testErr);
        System.out.println("Learned classification forest model:\n" + model.toDebugString());
    }

    private static void testRegression(JavaRDD<LabeledPoint> trainingData, JavaRDD<LabeledPoint> testData) {
        HashMap categoricalFeaturesInfo = new HashMap();
        Integer numTrees = 3;
        String featureSubsetStrategy = "auto";
        String impurity = "variance";
        Integer maxDepth = 4;
        Integer maxBins = 32;
        Integer seed = 12345;
        final RandomForestModel model = RandomForest.trainRegressor(trainingData, categoricalFeaturesInfo, (int)numTrees, (String)featureSubsetStrategy, (String)impurity, (int)maxDepth, (int)maxBins, (int)seed);
        JavaPairRDD predictionAndLabel = testData.mapToPair((PairFunction)new PairFunction<LabeledPoint, Double, Double>(){

            public Tuple2<Double, Double> call(LabeledPoint p) {
                return new Tuple2((Object)model.predict(p.features()), (Object)p.label());
            }
        });
        Double testMSE = (Double)predictionAndLabel.map((Function)new Function<Tuple2<Double, Double>, Double>(){

            public Double call(Tuple2<Double, Double> pl) {
                Double diff = (Double)pl._1() - (Double)pl._2();
                return diff * diff;
            }
        }).reduce((Function2)new Function2<Double, Double, Double>(){

            public Double call(Double a, Double b) {
                return a + b;
            }
        }) / (double)testData.count();
        System.out.println("Test Mean Squared Error: " + testMSE);
        System.out.println("Learned regression forest model:\n" + model.toDebugString());
    }

    public static void main(String[] args) {
        SparkConf sparkConf = new SparkConf().setAppName("JavaRandomForestExample");
        JavaSparkContext sc = new JavaSparkContext(sparkConf);
        String datapath = "data/mllib/sample_libsvm_data.txt";
        JavaRDD data = MLUtils.loadLibSVMFile((SparkContext)sc.sc(), (String)datapath).toJavaRDD();
        JavaRDD[] splits = data.randomSplit(new double[]{0.7, 0.3});
        JavaRDD trainingData = splits[0];
        JavaRDD testData = splits[1];
        System.out.println("\nRunning example of classification using RandomForest\n");
        JavaRandomForestExample.testClassification((JavaRDD<LabeledPoint>)trainingData, (JavaRDD<LabeledPoint>)testData);
        System.out.println("\nRunning example of regression using RandomForest\n");
        JavaRandomForestExample.testRegression((JavaRDD<LabeledPoint>)trainingData, (JavaRDD<LabeledPoint>)testData);
        sc.stop();
    }
}

