/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.mllib.clustering.PowerIterationClustering;
import org.apache.spark.mllib.clustering.PowerIterationClusteringModel;
import scala.Tuple3;

public class JavaPowerIterationClusteringExample {
    public static void main(String[] args) {
        SparkConf sparkConf = new SparkConf().setAppName("JavaPowerIterationClusteringExample");
        JavaSparkContext sc = new JavaSparkContext(sparkConf);
        JavaRDD similarities = sc.parallelize((List)Lists.newArrayList((Object[])new Tuple3[]{new Tuple3((Object)0L, (Object)1L, (Object)0.9), new Tuple3((Object)1L, (Object)2L, (Object)0.9), new Tuple3((Object)2L, (Object)3L, (Object)0.9), new Tuple3((Object)3L, (Object)4L, (Object)0.1), new Tuple3((Object)4L, (Object)5L, (Object)0.9)}));
        PowerIterationClustering pic = new PowerIterationClustering().setK(2).setMaxIterations(10);
        PowerIterationClusteringModel model = pic.run(similarities);
        for (PowerIterationClustering.Assignment a : model.assignments().toJavaRDD().collect()) {
            System.out.println(a.id() + " -> " + a.cluster());
        }
        sc.stop();
    }
}

