/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.util.HashMap;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.DecisionTree;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.util.MLUtils;
import scala.Tuple2;

public final class JavaDecisionTree {
    public static void main(String[] args) {
        String datapath = "data/mllib/sample_libsvm_data.txt";
        if (args.length == 1) {
            datapath = args[0];
        } else if (args.length > 1) {
            System.err.println("Usage: JavaDecisionTree <libsvm format data file>");
            System.exit(1);
        }
        SparkConf sparkConf = new SparkConf().setAppName("JavaDecisionTree");
        JavaSparkContext sc = new JavaSparkContext(sparkConf);
        JavaRDD data = MLUtils.loadLibSVMFile((SparkContext)sc.sc(), (String)datapath).toJavaRDD().cache();
        Integer numClasses = data.map((Function)new Function<LabeledPoint, Double>(){

            public Double call(LabeledPoint p) {
                return p.label();
            }
        }).countByValue().size();
        HashMap categoricalFeaturesInfo = new HashMap();
        String impurity = "gini";
        Integer maxDepth = 5;
        Integer maxBins = 32;
        final DecisionTreeModel model = DecisionTree.trainClassifier((JavaRDD)data, (int)numClasses, categoricalFeaturesInfo, (String)impurity, (int)maxDepth, (int)maxBins);
        JavaPairRDD predictionAndLabel = data.mapToPair((PairFunction)new PairFunction<LabeledPoint, Double, Double>(){

            public Tuple2<Double, Double> call(LabeledPoint p) {
                return new Tuple2((Object)model.predict(p.features()), (Object)p.label());
            }
        });
        Double trainErr = 1.0 * (double)predictionAndLabel.filter((Function)new Function<Tuple2<Double, Double>, Boolean>(){

            public Boolean call(Tuple2<Double, Double> pl) {
                return !((Double)pl._1()).equals(pl._2());
            }
        }).count() / (double)data.count();
        System.out.println("Training error: " + trainErr);
        System.out.println("Learned classification tree model:\n" + model);
        impurity = "variance";
        final DecisionTreeModel regressionModel = DecisionTree.trainRegressor((JavaRDD)data, categoricalFeaturesInfo, (String)impurity, (int)maxDepth, (int)maxBins);
        JavaPairRDD regressorPredictionAndLabel = data.mapToPair((PairFunction)new PairFunction<LabeledPoint, Double, Double>(){

            public Tuple2<Double, Double> call(LabeledPoint p) {
                return new Tuple2((Object)regressionModel.predict(p.features()), (Object)p.label());
            }
        });
        Double trainMSE = (Double)regressorPredictionAndLabel.map((Function)new Function<Tuple2<Double, Double>, Double>(){

            public Double call(Tuple2<Double, Double> pl) {
                Double diff = (Double)pl._1() - (Double)pl._2();
                return diff * diff;
            }
        }).reduce((Function2)new Function2<Double, Double, Double>(){

            public Double call(Double a, Double b) {
                return a + b;
            }
        }) / (double)data.count();
        System.out.println("Training Mean Squared Error: " + trainMSE);
        System.out.println("Learned regression tree model:\n" + regressionModel);
        sc.stop();
    }
}

