/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import com.google.common.io.Files;
import java.io.File;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.DatasetExample;
import org.apache.spark.examples.mllib.DatasetExample$;
import org.apache.spark.examples.mllib.DatasetExample$Params$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scopt.OptionParser;
import scopt.Read$;

public final class DatasetExample$ {
    public static final DatasetExample$ MODULE$;

    static {
        new DatasetExample$();
    }

    public void main(String[] args) {
        DatasetExample.Params defaultParams = new DatasetExample.Params(DatasetExample$Params$.MODULE$.apply$default$1(), DatasetExample$Params$.MODULE$.apply$default$2());
        OptionParser<DatasetExample.Params> parser = new OptionParser<DatasetExample.Params>(){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dataset: an example app using DataFrame as a Dataset for ML."}));
                this.opt("input", Read$.MODULE$.stringRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input path to dataset"})).s((Seq)Nil$.MODULE$)).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DatasetExample.Params apply(String x, DatasetExample.Params c) {
                        return c.copy(x, c.copy$default$2());
                    }
                });
                this.opt("dataFormat", Read$.MODULE$.stringRead()).text("data format: libsvm (default), dense (deprecated in Spark v1.1)").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DatasetExample.Params apply(String x, DatasetExample.Params c) {
                        return c.copy(x, c.copy$default$2());
                    }
                });
                this.checkConfig((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final Either<String, BoxedUnit> apply(DatasetExample.Params params) {
                        return this.$outer.success();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
        };
        parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(DatasetExample.Params params) {
                DatasetExample$.MODULE$.run(params);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return scala.sys.package$.MODULE$.exit(1);
            }
        });
    }

    public void run(DatasetExample.Params params) {
        String string;
        block4: {
            RDD rDD;
            SQLContext sqlContext;
            SparkContext sc;
            block3: {
                block2: {
                    SparkConf conf = new SparkConf().setAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DatasetExample with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params})));
                    sc = new SparkContext(conf);
                    sqlContext = new SQLContext(sc);
                    String string2 = string = params.dataFormat();
                    if ("dense" != null ? !"dense".equals(string2) : string2 != null) break block2;
                    rDD = MLUtils$.MODULE$.loadLabeledPoints(sc, params.input());
                    break block3;
                }
                String string3 = string;
                if ("libsvm" != null ? !"libsvm".equals(string3) : string3 != null) break block4;
                rDD = MLUtils$.MODULE$.loadLibSVMFile(sc, params.input());
            }
            RDD origData = rDD;
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded ", " instances from file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)origData.count()), params.input()})));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Org_apache_spark_examples_mllib_DatasetExample$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.regression.LabeledPoint")).asType()).toTypeConstructor();
                }

                public Org_apache_spark_examples_mllib_DatasetExample$$typecreator2$1() {
                }
            }
            DataFrame df = sqlContext.implicits().rddToDataFrameHolder(origData, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_mllib_DatasetExample$$typecreator2$1())).toDF();
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Inferred schema:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{df.schema().prettyJson()})));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Converted to DataFrame with ", " records"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)df.count())})));
            DataFrame labelsDf = df.select("label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            RDD labels = labelsDf.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(Row x0$1) {
                    Object v;
                    Row row = x0$1;
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (v = ((SeqLike)some.get()).apply(0)) instanceof Double) {
                        double d;
                        double d2 = d = BoxesRunTime.unboxToDouble((Object)v);
                        return d2;
                    }
                    throw new MatchError((Object)row);
                }
            }, ClassTag$.MODULE$.Double());
            long numLabels = labels.count();
            double meanLabel = BoxesRunTime.unboxToDouble((Object)labels.fold((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(double x$1, double x$2) {
                    return this.apply$mcDDD$sp(x$1, x$2);
                }

                public double apply$mcDDD$sp(double x$1, double x$2) {
                    return x$1 + x$2;
                }
            })) / (double)numLabels;
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Selected label column with average value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)meanLabel)})));
            DataFrame featuresDf = df.select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            RDD features = featuresDf.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Vector apply(Row x0$2) {
                    Object v;
                    Row row = x0$2;
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (v = ((SeqLike)some.get()).apply(0)) instanceof Vector) {
                        Vector vector;
                        Vector vector2 = vector = (Vector)v;
                        return vector2;
                    }
                    throw new MatchError((Object)row);
                }
            }, ClassTag$.MODULE$.apply(Vector.class));
            MultivariateOnlineSummarizer featureSummary = (MultivariateOnlineSummarizer)features.aggregate((Object)new MultivariateOnlineSummarizer(), (Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final MultivariateOnlineSummarizer apply(MultivariateOnlineSummarizer summary, Vector feat) {
                    return summary.add(feat);
                }
            }, (Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final MultivariateOnlineSummarizer apply(MultivariateOnlineSummarizer sum1, MultivariateOnlineSummarizer sum2) {
                    return sum1.merge(sum2);
                }
            }, ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Selected features column with average values:\\n ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{featureSummary.mean().toString()})));
            File tmpDir = Files.createTempDir();
            tmpDir.deleteOnExit();
            String outputDir = new File(tmpDir, "dataset").toString();
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Saving to ", " as Parquet file."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputDir})));
            df.write().parquet(outputDir);
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading Parquet file with UDT from ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputDir})));
            DataFrame newDataset = sqlContext.read().parquet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{outputDir}));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schema from Parquet: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newDataset.schema().prettyJson()})));
            RDD newFeatures = newDataset.select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Vector apply(Row x0$3) {
                    Object v;
                    Row row = x0$3;
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (v = ((SeqLike)some.get()).apply(0)) instanceof Vector) {
                        Vector vector;
                        Vector vector2 = vector = (Vector)v;
                        return vector2;
                    }
                    throw new MatchError((Object)row);
                }
            }, ClassTag$.MODULE$.apply(Vector.class));
            MultivariateOnlineSummarizer newFeaturesSummary = (MultivariateOnlineSummarizer)newFeatures.aggregate((Object)new MultivariateOnlineSummarizer(), (Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final MultivariateOnlineSummarizer apply(MultivariateOnlineSummarizer summary, Vector feat) {
                    return summary.add(feat);
                }
            }, (Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final MultivariateOnlineSummarizer apply(MultivariateOnlineSummarizer sum1, MultivariateOnlineSummarizer sum2) {
                    return sum1.merge(sum2);
                }
            }, ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Selected features column with average values:\\n ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newFeaturesSummary.mean().toString()})));
            sc.stop();
            return;
        }
        throw new MatchError((Object)string);
    }

    private DatasetExample$() {
        MODULE$ = this;
    }
}

