/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.ml.clustering.KMeans;
import org.apache.spark.ml.clustering.KMeansModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class KMeansExample$ {
    public static final KMeansExample$ MODULE$;
    private final String FEATURES_COL;

    static {
        new KMeansExample$();
    }

    public final String FEATURES_COL() {
        return "features";
    }

    public void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: ml.KMeansExample <file> <k>");
            System.exit(1);
        }
        String input = args[0];
        int k = new StringOps(Predef$.MODULE$.augmentString(args[1])).toInt();
        SparkConf conf = new SparkConf().setAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getSimpleName()})));
        SparkContext sc = new SparkContext(conf);
        SQLContext sqlContext = new SQLContext(sc);
        RDD rowRDD = sc.textFile(input, sc.textFile$default$2()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).nonEmpty();
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double[] apply(String x$2) {
                return (double[])Predef$.MODULE$.refArrayOps((Object[])x$2.split(" ")).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(String x$3) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toDouble();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Vector apply(double[] values) {
                return Vectors$.MODULE$.dense(values);
            }
        }, ClassTag$.MODULE$.apply(Vector.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Row apply(Vector x$4) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x$4}));
            }
        }, ClassTag$.MODULE$.apply(Row.class));
        StructType schema = new StructType((StructField[])((Object[])new StructField[]{new StructField("features", (DataType)new VectorUDT(), false, StructField$.MODULE$.apply$default$4())}));
        DataFrame dataset = sqlContext.createDataFrame(rowRDD, schema);
        KMeans kmeans = new KMeans().setK(k).setFeaturesCol("features");
        KMeansModel model = kmeans.fit(dataset);
        Predef$.MODULE$.println((Object)"Final Centers: ");
        Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object x) {
                Predef$.MODULE$.println(x);
            }
        });
        sc.stop();
    }

    private KMeansExample$() {
        MODULE$ = this;
    }
}

