/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.evaluation.RegressionEvaluator;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.regression.LinearRegression;
import org.apache.spark.ml.tuning.ParamGridBuilder;
import org.apache.spark.ml.tuning.TrainValidationSplit;
import org.apache.spark.ml.tuning.TrainValidationSplitModel;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;

public class JavaTrainValidationSplitExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaTrainValidationSplitExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        SQLContext jsql = new SQLContext(jsc);
        DataFrame data = jsql.createDataFrame(MLUtils.loadLibSVMFile((SparkContext)jsc.sc(), (String)"data/mllib/sample_libsvm_data.txt"), LabeledPoint.class);
        DataFrame[] splits = data.randomSplit(new double[]{0.9, 0.1}, 12345L);
        DataFrame training = splits[0];
        DataFrame test = splits[1];
        LinearRegression lr = new LinearRegression();
        ParamMap[] paramGrid = new ParamGridBuilder().addGrid(lr.regParam(), new double[]{0.1, 0.01}).addGrid(lr.fitIntercept()).addGrid(lr.elasticNetParam(), new double[]{0.0, 0.5, 1.0}).build();
        TrainValidationSplit trainValidationSplit = new TrainValidationSplit().setEstimator((Estimator)lr).setEvaluator((Evaluator)new RegressionEvaluator()).setEstimatorParamMaps(paramGrid);
        trainValidationSplit.setTrainRatio(0.8);
        TrainValidationSplitModel model = trainValidationSplit.fit(training);
        model.transform(test).select("features", new String[]{"label", "prediction"}).show();
        jsc.stop();
    }
}

