/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.SparkExitCode$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.TraitSetter;

public final class SparkUncaughtExceptionHandler$
implements Thread.UncaughtExceptionHandler,
Logging {
    public static final SparkUncaughtExceptionHandler$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparkUncaughtExceptionHandler$();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging$class.initializeLogIfNecessary(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging$class.initializeLogIfNecessary$default$2(this);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable exception2) {
        try {
            String inShutdownMsg = ShutdownHookManager$.MODULE$.inShutdown() ? "[Container in shutdown] " : "";
            String errMsg = "Uncaught exception in thread ";
            this.logError((Function0<String>)new Serializable(thread, inShutdownMsg, errMsg){
                public static final long serialVersionUID = 0L;
                private final Thread thread$1;
                private final String inShutdownMsg$1;
                private final String errMsg$1;

                public final String apply() {
                    return new StringBuilder().append((Object)this.inShutdownMsg$1).append((Object)this.errMsg$1).append((Object)this.thread$1).toString();
                }
                {
                    this.thread$1 = thread$1;
                    this.inShutdownMsg$1 = inShutdownMsg$1;
                    this.errMsg$1 = errMsg$1;
                }
            }, exception2);
            if (!ShutdownHookManager$.MODULE$.inShutdown()) {
                if (exception2 instanceof OutOfMemoryError) {
                    System.exit(SparkExitCode$.MODULE$.OOM());
                } else {
                    System.exit(SparkExitCode$.MODULE$.UNCAUGHT_EXCEPTION());
                }
            }
        }
        catch (Throwable throwable) {
            Runtime.getRuntime().halt(SparkExitCode$.MODULE$.UNCAUGHT_EXCEPTION_TWICE());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Runtime.getRuntime().halt(SparkExitCode$.MODULE$.OOM());
        }
    }

    public void uncaughtException(Throwable exception2) {
        this.uncaughtException(Thread.currentThread(), exception2);
    }

    private SparkUncaughtExceptionHandler$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

