/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.spark.util.AccumulatorV2;
import org.apache.spark.util.AccumulatorV2Kryo;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001\u0017\t)2i\u001c7mK\u000e$\u0018n\u001c8BG\u000e,X.\u001e7bi>\u0014(BA\u0002\u0005\u0003\u0011)H/\u001b7\u000b\u0005\u00151\u0011!B:qCJ\\'BA\u0004\t\u0003\u0019\t\u0007/Y2iK*\t\u0011\"A\u0002pe\u001e\u001c\u0001!\u0006\u0002\r'M\u0019\u0001!\u0004\u0014\u0011\t9y\u0011cH\u0007\u0002\u0005%\u0011\u0001C\u0001\u0002\u0012\u0003\u000e\u001cW/\\;mCR|'O\u0016\u001aLef|\u0007C\u0001\n\u0014\u0019\u0001!Q\u0001\u0006\u0001C\u0002U\u0011\u0011\u0001V\t\u0003-q\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011qAT8uQ&tw\r\u0005\u0002\u0018;%\u0011a\u0004\u0007\u0002\u0004\u0003:L\bc\u0001\u0011%#5\t\u0011E\u0003\u0002\u0004E)\t1%\u0001\u0003kCZ\f\u0017BA\u0013\"\u0005\u0011a\u0015n\u001d;\u0011\u0005\u001drS\"\u0001\u0015\u000b\u0005%R\u0013\u0001B6ss>T!a\u000b\u0017\u0002!\u0015\u001cx\u000e^3sS\u000e\u001cxN\u001a;xCJ,'\"A\u0017\u0002\u0007\r|W.\u0003\u00020Q\t\u00012J]=p'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006c\u0001!\tAM\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u00022A\u0004\u0001\u0012\u0011\u001d)\u0004A1A\u0005\nY\nQa\u00187jgR,\u0012a\b\u0005\u0007q\u0001\u0001\u000b\u0011B\u0010\u0002\r}c\u0017n\u001d;!\u0011\u0015Q\u0004\u0001\"\u0011<\u0003\u0019I7OW3s_V\tA\b\u0005\u0002\u0018{%\u0011a\b\u0007\u0002\b\u0005>|G.Z1o\u0011\u0015\u0001\u0005\u0001\"\u00113\u00031\u0019w\u000e]=B]\u0012\u0014Vm]3u\u0011\u0015\u0011\u0005\u0001\"\u00113\u0003\u0011\u0019w\u000e]=\t\u000b\u0011\u0003A\u0011I#\u0002\u000bI,7/\u001a;\u0015\u0003\u0019\u0003\"aF$\n\u0005!C\"\u0001B+oSRDQA\u0013\u0001\u0005B-\u000b1!\u00193e)\t1E\nC\u0003N\u0013\u0002\u0007\u0011#A\u0001w\u0011\u0015y\u0005\u0001\"\u0011Q\u0003\u0015iWM]4f)\t1\u0015\u000bC\u0003S\u001d\u0002\u00071+A\u0003pi\",'\u000f\u0005\u0003\u000f)Fy\u0012BA+\u0003\u00055\t5mY;nk2\fGo\u001c:We!)q\u000b\u0001C!m\u0005)a/\u00197vK\"1\u0011\f\u0001C\u0001\ti\u000b\u0001b]3u-\u0006dW/\u001a\u000b\u0003\rnCQ\u0001\u0018-A\u0002}\t\u0001B\\3x-\u0006dW/\u001a\u0005\u0006=\u0002!\teX\u0001\noJLG/Z&ss>$2A\u00121e\u0011\u0015IS\f1\u0001b!\t9#-\u0003\u0002dQ\t!1J]=p\u0011\u0015)W\f1\u0001g\u0003\u0019yW\u000f\u001e9viB\u0011qM[\u0007\u0002Q*\u0011\u0011\u000eK\u0001\u0003S>L!a\u001b5\u0003\r=+H\u000f];u\u0011\u0015i\u0007\u0001\"\u0011o\u0003!\u0011X-\u00193Lef|Gc\u0001$pa\")\u0011\u0006\u001ca\u0001C\")\u0011\u000f\u001ca\u0001e\u0006)\u0011N\u001c9viB\u0011qm]\u0005\u0003i\"\u0014Q!\u00138qkR\u0004")
public class CollectionAccumulator<T>
extends AccumulatorV2Kryo<T, List<T>> {
    private final List<T> _list = Collections.synchronizedList(new ArrayList());

    private List<T> _list() {
        return this._list;
    }

    @Override
    public boolean isZero() {
        return this._list().isEmpty();
    }

    public CollectionAccumulator<T> copyAndReset() {
        return new CollectionAccumulator<T>();
    }

    /*
     * WARNING - void declaration
     */
    public CollectionAccumulator<T> copy() {
        CollectionAccumulator<T> newAcc = new CollectionAccumulator<T>();
        List<T> list = this._list();
        synchronized (list) {
            void var1_1;
            BoxesRunTime.boxToBoolean((boolean)super._list().addAll(this._list()));
            return var1_1;
        }
    }

    @Override
    public void reset() {
        this._list().clear();
    }

    @Override
    public void add(T v) {
        this._list().add(v);
    }

    @Override
    public void merge(AccumulatorV2<T, List<T>> other) {
        AccumulatorV2<T, List<T>> accumulatorV2 = other;
        if (accumulatorV2 instanceof CollectionAccumulator) {
            CollectionAccumulator collectionAccumulator = (CollectionAccumulator)accumulatorV2;
            this._list().addAll((Collection<T>)collectionAccumulator.value());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot merge ", " with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getName(), other.getClass().getName()})));
    }

    @Override
    public List<T> value() {
        List<T> list = this._list();
        synchronized (list) {
            List<T> list2 = Collections.unmodifiableList(new ArrayList<T>(this._list()));
            return list2;
        }
    }

    public void setValue(List<T> newValue) {
        this._list().clear();
        this._list().addAll(newValue);
    }

    @Override
    public void writeKryo(Kryo kryo, Output output) {
        Object[] items = this._list().toArray();
        output.writeVarInt(items.length, true);
        for (int i = 0; i < items.length; ++i) {
            kryo.writeClassAndObject(output, items[i]);
        }
    }

    @Override
    public void readKryo(Kryo kryo, Input input) {
        int len = input.readVarInt(true);
        if (!this._list().isEmpty()) {
            this._list().clear();
        }
        while (len > 0) {
            this._list().add(kryo.readClassAndObject(input));
            --len;
        }
    }
}

