/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.util.AccumulatorV2;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class AccumulatorContext$ {
    public static final AccumulatorContext$ MODULE$;
    private final ConcurrentHashMap<Object, WeakReference<AccumulatorV2<?, ?>>> originals;
    private final AtomicLong nextId;
    private final String SQL_ACCUM_IDENTIFIER;

    static {
        new AccumulatorContext$();
    }

    private ConcurrentHashMap<Object, WeakReference<AccumulatorV2<?, ?>>> originals() {
        return this.originals;
    }

    public long newId() {
        return this.nextId.getAndIncrement();
    }

    public int numAccums() {
        return this.originals().size();
    }

    public void register(AccumulatorV2<?, ?> a) {
        this.originals().putIfAbsent(BoxesRunTime.boxToLong((long)a.id()), new WeakReference(a));
    }

    public void remove(long id) {
        this.originals().remove(BoxesRunTime.boxToLong((long)id));
    }

    public Option<AccumulatorV2<?, ?>> get(long id) {
        return Option$.MODULE$.apply(this.originals().get(BoxesRunTime.boxToLong((long)id))).map((Function1)new Serializable(id){
            public static final long serialVersionUID = 0L;
            private final long id$1;

            /*
             * WARNING - void declaration
             */
            public final AccumulatorV2<?, ?> apply(WeakReference<AccumulatorV2<?, ?>> ref) {
                void var2_2;
                AccumulatorV2 acc = (AccumulatorV2)ref.get();
                if (acc == null) {
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempted to access garbage collected accumulator ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.id$1)})));
                }
                return var2_2;
            }
            {
                this.id$1 = id$1;
            }
        });
    }

    public void clear() {
        this.originals().clear();
    }

    public Option<AccumulatorV2<?, ?>> lookForAccumulatorByName(String name) {
        return ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.originals().values()).asScala()).find((Function1)new Serializable(name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(WeakReference<AccumulatorV2<?, ?>> ref) {
                AccumulatorV2 acc = (AccumulatorV2)ref.get();
                if (acc == null) return false;
                if (!acc.name().isDefined()) return false;
                Object object = acc.name().get();
                String string = this.name$1;
                if (object != null) {
                    if (!object.equals(string)) return false;
                    return true;
                }
                if (string == null) return true;
                return false;
            }
            {
                this.name$1 = name$1;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final AccumulatorV2<?, ?> apply(WeakReference<AccumulatorV2<?, ?>> x$3) {
                return (AccumulatorV2)x$3.get();
            }
        });
    }

    public String SQL_ACCUM_IDENTIFIER() {
        return this.SQL_ACCUM_IDENTIFIER;
    }

    private AccumulatorContext$() {
        MODULE$ = this;
        this.originals = new ConcurrentHashMap();
        this.nextId = new AtomicLong(0L);
        this.SQL_ACCUM_IDENTIFIER = "sql";
    }
}

