/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.security;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.crypto.random.CryptoRandomFactory;
import org.apache.commons.crypto.stream.CryptoInputStream;
import org.apache.commons.crypto.stream.CryptoOutputStream;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.internal.config.package$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

public final class CryptoStreamUtils$
implements Logging {
    public static final CryptoStreamUtils$ MODULE$;
    private final int IV_LENGTH_IN_BYTES;
    private final String SPARK_IO_ENCRYPTION_COMMONS_CONFIG_PREFIX;
    private final String COMMONS_CRYPTO_CONF_PREFIX;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new CryptoStreamUtils$();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging$class.initializeLogIfNecessary(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging$class.initializeLogIfNecessary$default$2(this);
    }

    public int IV_LENGTH_IN_BYTES() {
        return this.IV_LENGTH_IN_BYTES;
    }

    public String SPARK_IO_ENCRYPTION_COMMONS_CONFIG_PREFIX() {
        return this.SPARK_IO_ENCRYPTION_COMMONS_CONFIG_PREFIX;
    }

    public String COMMONS_CRYPTO_CONF_PREFIX() {
        return this.COMMONS_CRYPTO_CONF_PREFIX;
    }

    public OutputStream createCryptoOutputStream(OutputStream os, SparkConf sparkConf, byte[] key) {
        Properties properties = this.toCryptoConf(sparkConf);
        byte[] iv = this.createInitializationVector(properties);
        os.write(iv);
        String transformationStr = sparkConf.get(package$.MODULE$.IO_CRYPTO_CIPHER_TRANSFORMATION());
        return new CryptoOutputStream(transformationStr, properties, os, (Key)new SecretKeySpec(key, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(iv));
    }

    public InputStream createCryptoInputStream(InputStream is, SparkConf sparkConf, byte[] key) {
        Properties properties = this.toCryptoConf(sparkConf);
        byte[] iv = new byte[this.IV_LENGTH_IN_BYTES()];
        is.read(iv, 0, iv.length);
        String transformationStr = sparkConf.get(package$.MODULE$.IO_CRYPTO_CIPHER_TRANSFORMATION());
        return new CryptoInputStream(transformationStr, properties, is, (Key)new SecretKeySpec(key, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(iv));
    }

    /*
     * WARNING - void declaration
     */
    public Properties toCryptoConf(SparkConf conf) {
        void var2_2;
        Properties props = new Properties();
        Predef$.MODULE$.refArrayOps((Object[])conf.getAll()).foreach((Function1)new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    BoxedUnit boxedUnit = k.startsWith(CryptoStreamUtils$.MODULE$.SPARK_IO_ENCRYPTION_COMMONS_CONFIG_PREFIX()) ? this.props$1.put(new StringBuilder().append((Object)CryptoStreamUtils$.MODULE$.COMMONS_CRYPTO_CONF_PREFIX()).append((Object)k.substring(CryptoStreamUtils$.MODULE$.SPARK_IO_ENCRYPTION_COMMONS_CONFIG_PREFIX().length())).toString(), v) : BoxedUnit.UNIT;
                    return boxedUnit;
                }
                throw new MatchError(tuple2);
            }
            {
                this.props$1 = props$1;
            }
        });
        return var2_2;
    }

    public byte[] createKey(SparkConf conf) {
        int keyLen = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.IO_ENCRYPTION_KEY_SIZE_BITS()));
        String ioKeyGenAlgorithm = conf.get(package$.MODULE$.IO_ENCRYPTION_KEYGEN_ALGORITHM());
        KeyGenerator keyGen = KeyGenerator.getInstance(ioKeyGenAlgorithm);
        keyGen.init(keyLen);
        return keyGen.generateKey().getEncoded();
    }

    /*
     * WARNING - void declaration
     */
    private byte[] createInitializationVector(Properties properties) {
        void var2_2;
        byte[] iv = new byte[this.IV_LENGTH_IN_BYTES()];
        long initialIVStart = System.currentTimeMillis();
        CryptoRandomFactory.getCryptoRandom((Properties)properties).nextBytes(iv);
        long initialIVFinish = System.currentTimeMillis();
        long initialIVTime = initialIVFinish - initialIVStart;
        if (initialIVTime > 2000L) {
            this.logWarning((Function0<String>)new Serializable(initialIVTime){
                public static final long serialVersionUID = 0L;
                private final long initialIVTime$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"It costs ", " milliseconds to create the Initialization Vector "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.initialIVTime$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"used by CryptoStream"})).s((Seq)Nil$.MODULE$)).toString();
                }
                {
                    this.initialIVTime$1 = initialIVTime$1;
                }
            });
        }
        return var2_2;
    }

    private CryptoStreamUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.IV_LENGTH_IN_BYTES = 16;
        this.SPARK_IO_ENCRYPTION_COMMONS_CONFIG_PREFIX = "spark.io.encryption.commons.config.";
        this.COMMONS_CRYPTO_CONF_PREFIX = "commons.crypto.";
    }
}

