/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.nio.ByteBuffer;
import java.util.Properties;
import org.apache.spark.InternalAccumulator$;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.TaskContextImpl;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.metrics.MetricsSystem;
import org.apache.spark.scheduler.Task$;
import org.apache.spark.scheduler.TaskData;
import org.apache.spark.scheduler.TaskData$;
import org.apache.spark.scheduler.TaskLocation;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.storage.memory.MemoryStore;
import org.apache.spark.util.AccumulatorV2;
import org.apache.spark.util.CallerContext;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0011\rbAB\u0001\u0003\u0003\u0003!!B\u0001\u0003UCN\\'BA\u0002\u0005\u0003%\u00198\r[3ek2,'O\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\u0007CB\f7\r[3\u000b\u0003%\t1a\u001c:h+\rY\u0011qJ\n\u0004\u00011\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u000e'%\u0011AC\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t-\u0001\u0011\t\u0019!C\u00051\u0005Aql\u001d;bO\u0016LEm\u0001\u0001\u0016\u0003e\u0001\"!\u0004\u000e\n\u0005mq!aA%oi\"AQ\u0004\u0001BA\u0002\u0013%a$\u0001\u0007`gR\fw-Z%e?\u0012*\u0017\u000f\u0006\u0002 EA\u0011Q\u0002I\u0005\u0003C9\u0011A!\u00168ji\"91\u0005HA\u0001\u0002\u0004I\u0012a\u0001=%c!AQ\u0005\u0001B\u0001B\u0003&\u0011$A\u0005`gR\fw-Z%eA!Aq\u0005\u0001BA\u0002\u0013%\u0001$A\b`gR\fw-Z!ui\u0016l\u0007\u000f^%e\u0011!I\u0003A!a\u0001\n\u0013Q\u0013aE0ti\u0006<W-\u0011;uK6\u0004H/\u00133`I\u0015\fHCA\u0010,\u0011\u001d\u0019\u0003&!AA\u0002eA\u0001\"\f\u0001\u0003\u0002\u0003\u0006K!G\u0001\u0011?N$\u0018mZ3BiR,W\u000e\u001d;JI\u0002B\u0001b\f\u0001\u0003\u0002\u0004%I\u0001G\u0001\r?B\f'\u000f^5uS>t\u0017\n\u001a\u0005\tc\u0001\u0011\t\u0019!C\u0005e\u0005\u0001r\f]1si&$\u0018n\u001c8JI~#S-\u001d\u000b\u0003?MBqa\t\u0019\u0002\u0002\u0003\u0007\u0011\u0004\u0003\u00056\u0001\t\u0005\t\u0015)\u0003\u001a\u00035y\u0006/\u0019:uSRLwN\\%eA!Iq\u0007\u0001BA\u0002\u0013\u0005A\u0001O\u0001\ti\u0006\u001c8\u000eR1uCV\t\u0011\b\u0005\u0002;w5\t!!\u0003\u0002=\u0005\tAA+Y:l\t\u0006$\u0018\rC\u0005?\u0001\t\u0005\r\u0011\"\u0001\u0005\u007f\u0005aA/Y:l\t\u0006$\u0018m\u0018\u0013fcR\u0011q\u0004\u0011\u0005\bGu\n\t\u00111\u0001:\u0011!\u0011\u0005A!A!B\u0013I\u0014!\u0003;bg.$\u0015\r^1!Q\t\tE\t\u0005\u0002\u000e\u000b&\u0011aI\u0004\u0002\niJ\fgn]5f]RD\u0001\u0002\u0013\u0001\u0003\u0002\u0004%\t\"S\u0001\u000bi\u0006\u001c8NQ5oCJLX#\u0001&\u0011\u00075YU*\u0003\u0002M\u001d\t1q\n\u001d;j_:\u00042AT)T\u001b\u0005y%B\u0001)\u0005\u0003%\u0011'o\\1eG\u0006\u001cH/\u0003\u0002S\u001f\nI!I]8bI\u000e\f7\u000f\u001e\t\u0004\u001bQ3\u0016BA+\u000f\u0005\u0015\t%O]1z!\tiq+\u0003\u0002Y\u001d\t!!)\u001f;f\u0011!Q\u0006A!a\u0001\n#Y\u0016A\u0004;bg.\u0014\u0015N\\1ss~#S-\u001d\u000b\u0003?qCqaI-\u0002\u0002\u0003\u0007!\n\u0003\u0005_\u0001\t\u0005\t\u0015)\u0003K\u0003-!\u0018m]6CS:\f'/\u001f\u0011\t\u0011\u0001\u0004!\u00111A\u0005\n\u0005\f\u0001bX7fiJL7m]\u000b\u0002EB\u00111MZ\u0007\u0002I*\u0011Q\rB\u0001\tKb,7-\u001e;pe&\u0011q\r\u001a\u0002\f)\u0006\u001c8.T3ue&\u001c7\u000f\u0003\u0005j\u0001\t\u0005\r\u0011\"\u0003k\u00031yV.\u001a;sS\u000e\u001cx\fJ3r)\ty2\u000eC\u0004$Q\u0006\u0005\t\u0019\u00012\t\u00115\u0004!\u0011!Q!\n\t\f\u0011bX7fiJL7m\u001d\u0011\t\u0011=\u0004!\u00111A\u0005\u0002A\fq\u0002\\8dC2\u0004&o\u001c9feRLWm]\u000b\u0002cB\u0011!o^\u0007\u0002g*\u0011A/^\u0001\u0005kRLGNC\u0001w\u0003\u0011Q\u0017M^1\n\u0005a\u001c(A\u0003)s_B,'\u000f^5fg\"A!\u0010\u0001BA\u0002\u0013\u000510A\nm_\u000e\fG\u000e\u0015:pa\u0016\u0014H/[3t?\u0012*\u0017\u000f\u0006\u0002 y\"91%_A\u0001\u0002\u0004\t\b\u0002\u0003@\u0001\u0005\u0003\u0005\u000b\u0015B9\u0002!1|7-\u00197Qe>\u0004XM\u001d;jKN\u0004\u0003FA?E\u0011%\t\u0019\u0001\u0001BA\u0002\u0013%\u0001$\u0001\u0004`U>\u0014\u0017\n\u001a\u0005\u000b\u0003\u000f\u0001!\u00111A\u0005\n\u0005%\u0011AC0k_\nLEm\u0018\u0013fcR\u0019q$a\u0003\t\u0011\r\n)!!AA\u0002eA\u0011\"a\u0004\u0001\u0005\u0003\u0005\u000b\u0015B\r\u0002\u000f}SwNY%eA!Q\u00111\u0003\u0001\u0003\u0002\u0004%I!!\u0006\u0002\r}\u000b\u0007\u000f]%e+\t\t9\u0002\u0005\u0003\u000e\u0017\u0006e\u0001\u0003BA\u000e\u0003Cq1!DA\u000f\u0013\r\tyBD\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0012Q\u0005\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005}a\u0002\u0003\u0006\u0002*\u0001\u0011\t\u0019!C\u0005\u0003W\t!bX1qa&#w\fJ3r)\ry\u0012Q\u0006\u0005\nG\u0005\u001d\u0012\u0011!a\u0001\u0003/A!\"!\r\u0001\u0005\u0003\u0005\u000b\u0015BA\f\u0003\u001dy\u0016\r\u001d9JI\u0002B!\"!\u000e\u0001\u0005\u0003\u0007I\u0011BA\u000b\u00035y\u0016\r\u001d9BiR,W\u000e\u001d;JI\"Q\u0011\u0011\b\u0001\u0003\u0002\u0004%I!a\u000f\u0002#}\u000b\u0007\u000f]!ui\u0016l\u0007\u000f^%e?\u0012*\u0017\u000fF\u0002 \u0003{A\u0011bIA\u001c\u0003\u0003\u0005\r!a\u0006\t\u0015\u0005\u0005\u0003A!A!B\u0013\t9\"\u0001\b`CB\u0004\u0018\t\u001e;f[B$\u0018\n\u001a\u0011\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H\u00051A(\u001b8jiz\"b#!\u0013\u0002b\u0005\r\u0014QMA4\u0003S\nY'!\u001c\u0002p\u0005E\u00141\u000f\t\u0005u\u0001\tY\u0005\u0005\u0003\u0002N\u0005=C\u0002\u0001\u0003\b\u0003#\u0002!\u0019AA*\u0005\u0005!\u0016\u0003BA+\u00037\u00022!DA,\u0013\r\tIF\u0004\u0002\b\u001d>$\b.\u001b8h!\ri\u0011QL\u0005\u0004\u0003?r!aA!os\"1a#a\u0011A\u0002eAaaJA\"\u0001\u0004I\u0002BB\u0018\u0002D\u0001\u0007\u0011\u0004\u0003\u00058\u0003\u0007\u0002\n\u00111\u0001:\u0011!A\u00151\tI\u0001\u0002\u0004Q\u0005\u0002\u00031\u0002DA\u0005\t\u0019\u00012\t\u0011=\f\u0019\u0005%AA\u0002ED\u0011\"a\u0001\u0002DA\u0005\t\u0019A\r\t\u0015\u0005M\u00111\tI\u0001\u0002\u0004\t9\u0002\u0003\u0006\u00026\u0005\r\u0003\u0013!a\u0001\u0003/Aa!a\u001e\u0001\t\u000bA\u0012aB:uC\u001e,\u0017\n\u001a\u0005\u0007\u0003w\u0002AQ\u0001\r\u0002\u001dM$\u0018mZ3BiR,W\u000e\u001d;JI\"1\u0011q\u0010\u0001\u0005\u0006a\t1\u0002]1si&$\u0018n\u001c8JI\"1\u00111\u0011\u0001\u0005\u0006a\tQA[8c\u0013\u0012Da!a\"\u0001\t\u000b\t\u0017aB7fiJL7m\u001d\u0005\b\u0003\u0017\u0003AQAAG\u0003\u0015\t\u0007\u000f]%e+\t\tI\u0002C\u0004\u0002\u0012\u0002!)!!$\u0002\u0019\u0005\u0004\b/\u0011;uK6\u0004H/\u00133\t\u0019\u0005U\u0005\u00011AA\u0002\u0013\u0005A!a&\u0002\u001bQ\f7o\u001b#bi\u0006\u0014\u0015\u0010^3t+\u0005\u0019\u0006\u0002DAN\u0001\u0001\u0007\t\u0019!C\u0001\t\u0005u\u0015!\u0005;bg.$\u0015\r^1CsR,7o\u0018\u0013fcR\u0019q$a(\t\u0011\r\nI*!AA\u0002MCq!a)\u0001A\u0003&1+\u0001\buCN\\G)\u0019;b\u0005f$Xm\u001d\u0011)\u0007\u0005\u0005F\tC\u0006\u0002*\u0002\u0001\r\u00111A\u0005\u0002\u0011A\u0012aC2qkN\u0004VM\u001d+bg.DA\"!,\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0005\u0003_\u000bqb\u00199vgB+'\u000fV1tW~#S-\u001d\u000b\u0004?\u0005E\u0006\u0002C\u0012\u0002,\u0006\u0005\t\u0019A\r\t\u000f\u0005U\u0006\u0001)Q\u00053\u0005a1\r];t!\u0016\u0014H+Y:lA!\u001a\u00111\u0017#\t\u000f\u0005m\u0006\u0001\"\u0006\u0002\u0018\u0006aq-\u001a;UCN\\')\u001f;fg\"9\u0011q\u0018\u0001\u0005\u0006\u0005\u0005\u0017a\u0001:v]RA\u00111JAb\u0003\u001b\f\t\u000e\u0003\u0005\u0002F\u0006u\u0006\u0019AAd\u00035!\u0018m]6BiR,W\u000e\u001d;JIB\u0019Q\"!3\n\u0007\u0005-gB\u0001\u0003M_:<\u0007bBAh\u0003{\u0003\r!G\u0001\u000eCR$X-\u001c9u\u001dVl'-\u001a:\t\u0011\u0005M\u0017Q\u0018a\u0001\u0003+\fQ\"\\3ue&\u001c7oU=ti\u0016l\u0007\u0003BAl\u00037l!!!7\u000b\u0007\u0005\u001dE!\u0003\u0003\u0002^\u0006e'!D'fiJL7m]*zgR,W\u000eC\u0006\u0002b\u0002\u0001\r\u00111A\u0005\n\u0005\r\u0018!\u0005;bg.lU-\\8ss6\u000bg.Y4feV\u0011\u0011Q\u001d\t\u0005\u0003O\fi/\u0004\u0002\u0002j*\u0019\u00111\u001e\u0003\u0002\r5,Wn\u001c:z\u0013\u0011\ty/!;\u0003#Q\u000b7o['f[>\u0014\u00180T1oC\u001e,'\u000fC\u0006\u0002t\u0002\u0001\r\u00111A\u0005\n\u0005U\u0018!\u0006;bg.lU-\\8ss6\u000bg.Y4fe~#S-\u001d\u000b\u0004?\u0005]\b\"C\u0012\u0002r\u0006\u0005\t\u0019AAs\u0011!\tY\u0010\u0001Q!\n\u0005\u0015\u0018A\u0005;bg.lU-\\8ss6\u000bg.Y4fe\u0002B3!!?E\u0011\u001d\u0011\t\u0001\u0001C\u0001\u0005\u0007\tAc]3u)\u0006\u001c8.T3n_JLX*\u00198bO\u0016\u0014HcA\u0010\u0003\u0006!A\u0011\u0011]A\u0000\u0001\u0004\t)\u000fC\u0004\u0003\n\u00011\tAa\u0003\u0002\u000fI,h\u000eV1tWR!\u00111\nB\u0007\u0011!\u0011yAa\u0002A\u0002\tE\u0011aB2p]R,\u0007\u0010\u001e\t\u0005\u0005'\u0011)\"D\u0001\u0005\u0013\r\u00119\u0002\u0002\u0002\f)\u0006\u001c8nQ8oi\u0016DH\u000fC\u0004\u0003\u001c\u0001!\tA!\b\u0002%A\u0014XMZ3se\u0016$Gj\\2bi&|gn]\u000b\u0003\u0005?\u0001bA!\t\u00032\t]b\u0002\u0002B\u0012\u0005[qAA!\n\u0003,5\u0011!q\u0005\u0006\u0004\u0005S9\u0012A\u0002\u001fs_>$h(C\u0001\u0010\u0013\r\u0011yCD\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\u0019D!\u000e\u0003\u0007M+\u0017OC\u0002\u000309\u00012A\u000fB\u001d\u0013\r\u0011YD\u0001\u0002\r)\u0006\u001c8\u000eT8dCRLwN\u001c\u0005\n\u0005\u007f\u0001\u0001\u0019!C\u0001\u0005\u0003\nQ!\u001a9pG\",\"!a2\t\u0013\t\u0015\u0003\u00011A\u0005\u0002\t\u001d\u0013!C3q_\u000eDw\fJ3r)\ry\"\u0011\n\u0005\nG\t\r\u0013\u0011!a\u0001\u0003\u000fD\u0001B!\u0014\u0001A\u0003&\u0011qY\u0001\u0007KB|7\r\u001b\u0011\t\u0017\t=\u0001\u00011AA\u0002\u0013E!\u0011K\u000b\u0003\u0005'\u0002BAa\u0005\u0003V%\u0019!q\u000b\u0003\u0003\u001fQ\u000b7o[\"p]R,\u0007\u0010^%na2D1Ba\u0017\u0001\u0001\u0004\u0005\r\u0011\"\u0005\u0003^\u0005Y1m\u001c8uKb$x\fJ3r)\ry\"q\f\u0005\nG\te\u0013\u0011!a\u0001\u0005'B\u0001Ba\u0019\u0001A\u0003&!1K\u0001\tG>tG/\u001a=uA!\u001a!\u0011\r#\t\u0017\t%\u0004\u00011AA\u0002\u0013%!1N\u0001\u000bi\u0006\u001c8\u000e\u00165sK\u0006$WC\u0001B7!\u0011\u0011yG!\u001e\u000e\u0005\tE$b\u0001B:k\u0006!A.\u00198h\u0013\u0011\u00119H!\u001d\u0003\rQC'/Z1e\u0011-\u0011Y\b\u0001a\u0001\u0002\u0004%IA! \u0002\u001dQ\f7o\u001b+ie\u0016\fGm\u0018\u0013fcR\u0019qDa \t\u0013\r\u0012I(!AA\u0002\t5\u0004\u0002\u0003BB\u0001\u0001\u0006KA!\u001c\u0002\u0017Q\f7o\u001b+ie\u0016\fG\r\t\u0015\u0004\u0005\u0003#\u0005\u0006\u0002BA\u0005\u0013\u00032!\u0004BF\u0013\r\u0011iI\u0004\u0002\tm>d\u0017\r^5mK\"I!\u0011\u0013\u0001A\u0002\u0013%!1S\u0001\b?.LG\u000e\\3e+\t\u0011)\nE\u0002\u000e\u0005/K1A!'\u000f\u0005\u001d\u0011un\u001c7fC:D\u0011B!(\u0001\u0001\u0004%IAa(\u0002\u0017}[\u0017\u000e\u001c7fI~#S-\u001d\u000b\u0004?\t\u0005\u0006\"C\u0012\u0003\u001c\u0006\u0005\t\u0019\u0001BK\u0011!\u0011)\u000b\u0001Q!\n\tU\u0015\u0001C0lS2dW\r\u001a\u0011)\u0007\t\rF\t\u000b\u0003\u0003$\n%\u0005\"\u0003BW\u0001\u0001\u0007I\u0011\u0003B!\u0003ayV\r_3dkR|'\u000fR3tKJL\u0017\r\\5{KRKW.\u001a\u0005\n\u0005c\u0003\u0001\u0019!C\t\u0005g\u000bAdX3yK\u000e,Ho\u001c:EKN,'/[1mSj,G+[7f?\u0012*\u0017\u000fF\u0002 \u0005kC\u0011b\tBX\u0003\u0003\u0005\r!a2\t\u0011\te\u0006\u0001)Q\u0005\u0003\u000f\f\u0011dX3yK\u000e,Ho\u001c:EKN,'/[1mSj,G+[7fA!I!Q\u0018\u0001A\u0002\u0013E!\u0011I\u0001\u001c?\u0016DXmY;u_J$Um]3sS\u0006d\u0017N_3DaV$\u0016.\\3\t\u0013\t\u0005\u0007\u00011A\u0005\u0012\t\r\u0017aH0fq\u0016\u001cW\u000f^8s\t\u0016\u001cXM]5bY&TXm\u00119v)&lWm\u0018\u0013fcR\u0019qD!2\t\u0013\r\u0012y,!AA\u0002\u0005\u001d\u0007\u0002\u0003Be\u0001\u0001\u0006K!a2\u00029}+\u00070Z2vi>\u0014H)Z:fe&\fG.\u001b>f\u0007B,H+[7fA!9!Q\u001a\u0001\u0005\u0002\tM\u0015AB6jY2,G\rC\u0004\u0003R\u0002!\tA!\u0011\u0002/\u0015DXmY;u_J$Um]3sS\u0006d\u0017N_3US6,\u0007b\u0002Bk\u0001\u0011\u0005!\u0011I\u0001\u001bKb,7-\u001e;pe\u0012+7/\u001a:jC2L'0Z\"qkRKW.\u001a\u0005\b\u00053\u0004A\u0011\u0001Bn\u0003e\u0019w\u000e\u001c7fGR\f5mY;nk2\fGo\u001c:Va\u0012\fG/Z:\u0015\t\tu'q\u001f\t\u0007\u0005C\u0011\tDa81\r\t\u0005(Q\u001eBz!!\u0011\u0019Oa:\u0003l\nEXB\u0001Bs\u0015\t!H!\u0003\u0003\u0003j\n\u0015(!D!dGVlW\u000f\\1u_J4&\u0007\u0005\u0003\u0002N\t5H\u0001\u0004Bx\u0005/\f\t\u0011!A\u0003\u0002\u0005M#aA0%cA!\u0011Q\nBz\t1\u0011)Pa6\u0002\u0002\u0003\u0005)\u0011AA*\u0005\ryFE\r\u0005\u000b\u0005s\u00149\u000e%AA\u0002\tU\u0015A\u0003;bg.4\u0015-\u001b7fI\"9!Q \u0001\u0005\u0002\t}\u0018\u0001B6jY2$2aHB\u0001\u0011!\u0019\u0019Aa?A\u0002\tU\u0015aD5oi\u0016\u0014(/\u001e9u)\"\u0014X-\u00193\t\u000f\r\u001d\u0001\u0001\"\u0005\u0004\n\u0005IqO]5uK.\u0013\u0018p\u001c\u000b\u0006?\r-1\u0011\u0005\u0005\t\u0007\u001b\u0019)\u00011\u0001\u0004\u0010\u0005!1N]=p!\u0011\u0019\tb!\b\u000e\u0005\rM!\u0002BB\u0007\u0007+QAaa\u0006\u0004\u001a\u0005\u0001Rm]8uKJL7m]8gi^\f'/\u001a\u0006\u0003\u00077\t1aY8n\u0013\u0011\u0019yba\u0005\u0003\t-\u0013\u0018p\u001c\u0005\t\u0007G\u0019)\u00011\u0001\u0004&\u00051q.\u001e;qkR\u0004Baa\n\u0004.5\u00111\u0011\u0006\u0006\u0005\u0007W\u0019\u0019\"\u0001\u0002j_&!1qFB\u0015\u0005\u0019yU\u000f\u001e9vi\"911\u0007\u0001\u0005\u0002\rU\u0012\u0001\u0003:fC\u0012\\%/_8\u0015\u000b}\u00199d!\u000f\t\u0011\r51\u0011\u0007a\u0001\u0007\u001fA\u0001ba\u000f\u00042\u0001\u00071QH\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0007O\u0019y$\u0003\u0003\u0004B\r%\"!B%oaV$\b\"CB#\u0001E\u0005I\u0011AB$\u0003\r\u001aw\u000e\u001c7fGR\f5mY;nk2\fGo\u001c:Va\u0012\fG/Z:%I\u00164\u0017-\u001e7uIE*\"a!\u0013+\t\tU51J\u0016\u0003\u0007\u001b\u0002Baa\u0014\u0004Z5\u00111\u0011\u000b\u0006\u0005\u0007'\u001a)&A\u0005v]\u000eDWmY6fI*\u00191q\u000b\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004\\\rE#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u001eA1q\f\u0002\t\u0002\u0011\u0019\t'\u0001\u0003UCN\\\u0007c\u0001\u001e\u0004d\u00199\u0011A\u0001E\u0001\t\r\u00154\u0003BB2\u0019IA\u0001\"!\u0012\u0004d\u0011\u00051\u0011\u000e\u000b\u0003\u0007CB\u0001b!\u001c\u0004d\u0011\u00051qN\u0001\u001ag\u0016\u0014\u0018.\u00197ju\u0016<\u0016\u000e\u001e5EKB,g\u000eZ3oG&,7\u000f\u0006\u0006\u0004r\ru41RBP\u0007G\u0003Baa\u001d\u0004z5\u00111Q\u000f\u0006\u0004\u0007o*\u0018a\u00018j_&!11PB;\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\t\u0007\u007f\u001aY\u00071\u0001\u0004\u0002\u0006!A/Y:la\u0011\u0019\u0019ia\"\u0011\ti\u00021Q\u0011\t\u0005\u0003\u001b\u001a9\t\u0002\u0007\u0004\n\u000eu\u0014\u0011!A\u0001\u0006\u0003\t\u0019FA\u0002`IMB\u0001b!$\u0004l\u0001\u00071qR\u0001\rGV\u0014(/\u001a8u\r&dWm\u001d\t\t\u0007#\u001bY*!\u0007\u0002H6\u001111\u0013\u0006\u0005\u0007+\u001b9*A\u0004nkR\f'\r\\3\u000b\u0007\ree\"\u0001\u0006d_2dWm\u0019;j_:LAa!(\u0004\u0014\n\u0019Q*\u00199\t\u0011\r\u000561\u000ea\u0001\u0007\u001f\u000b1bY;se\u0016tGOS1sg\"A1QUB6\u0001\u0004\u00199+\u0001\u0006tKJL\u0017\r\\5{KJ\u0004Ba!+\u0004.6\u001111\u0016\u0006\u0004\u0007K#\u0011\u0002BBX\u0007W\u0013!cU3sS\u0006d\u0017N_3s\u0013:\u001cH/\u00198dK\"A11WB2\t\u0003\u0019),A\u000eeKN,'/[1mSj,w+\u001b;i\t\u0016\u0004XM\u001c3f]\u000eLWm\u001d\u000b\u0005\u0007o\u001b\u0019\r\u0005\u0006\u000e\u0007s\u001bil!0r\u0007cJ1aa/\u000f\u0005\u0019!V\u000f\u001d7fiAA1\u0011SB`\u00033\t9-\u0003\u0003\u0004B\u000eM%a\u0002%bg\"l\u0015\r\u001d\u0005\t\u0007\u000b\u001c\t\f1\u0001\u0004r\u0005q1/\u001a:jC2L'0\u001a3UCN\\\u0007BCBe\u0007G\n\n\u0011\"\u0001\u0004L\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*Ba!4\u0004RV\u00111q\u001a\u0016\u0004s\r-C\u0001CA)\u0007\u000f\u0014\r!a\u0015\t\u0015\rU71MI\u0001\n\u0003\u00199.A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0005\u00073\u001ci.\u0006\u0002\u0004\\*\u001a!ja\u0013\u0005\u0011\u0005E31\u001bb\u0001\u0003'B!b!9\u0004dE\u0005I\u0011ABr\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU!1Q]Bu+\t\u00199OK\u0002c\u0007\u0017\"\u0001\"!\u0015\u0004`\n\u0007\u00111\u000b\u0005\u000b\u0007[\u001c\u0019'%A\u0005\u0002\r=\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$s'\u0006\u0003\u0004r\u000eUXCABzU\r\t81\n\u0003\t\u0003#\u001aYO1\u0001\u0002T!Q1\u0011`B2#\u0003%\taa?\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00139+\u0011\u0019i\u0010\"\u0001\u0016\u0005\r}(fA\r\u0004L\u0011A\u0011\u0011KB|\u0005\u0004\t\u0019\u0006\u0003\u0006\u0005\u0006\r\r\u0014\u0013!C\u0001\t\u000f\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012JT\u0003\u0002C\u0005\t\u001b)\"\u0001b\u0003+\t\u0005]11\n\u0003\t\u0003#\"\u0019A1\u0001\u0002T!QA\u0011CB2#\u0003%\t\u0001b\u0005\u00029\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132aU!A\u0011\u0002C\u000b\t!\t\t\u0006b\u0004C\u0002\u0005M\u0003B\u0003C\r\u0007G\n\t\u0011\"\u0003\u0005\u001c\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t!i\u0002\u0005\u0003\u0003p\u0011}\u0011\u0002\u0002C\u0011\u0005c\u0012aa\u00142kK\u000e$\b")
public abstract class Task<T>
implements Serializable {
    private int _stageId;
    private int _stageAttemptId;
    private int _partitionId;
    private transient TaskData taskData;
    private Option<Broadcast<byte[]>> taskBinary;
    private TaskMetrics _metrics;
    private transient Properties localProperties;
    private int _jobId;
    private Option<String> _appId;
    private Option<String> _appAttemptId;
    private transient byte[] taskDataBytes;
    private transient int cpusPerTask;
    private transient TaskMemoryManager taskMemoryManager;
    private long epoch;
    private transient TaskContextImpl context;
    private volatile transient Thread taskThread;
    private volatile transient boolean _killed;
    private long _executorDeserializeTime;
    private long _executorDeserializeCpuTime;

    public static <T> Option<String> $lessinit$greater$default$10() {
        return Task$.MODULE$.$lessinit$greater$default$10();
    }

    public static <T> Option<String> $lessinit$greater$default$9() {
        return Task$.MODULE$.$lessinit$greater$default$9();
    }

    public static <T> int $lessinit$greater$default$8() {
        return Task$.MODULE$.$lessinit$greater$default$8();
    }

    public static <T> Properties $lessinit$greater$default$7() {
        return Task$.MODULE$.$lessinit$greater$default$7();
    }

    public static <T> TaskMetrics $lessinit$greater$default$6() {
        return Task$.MODULE$.$lessinit$greater$default$6();
    }

    public static <T> Option<Broadcast<byte[]>> $lessinit$greater$default$5() {
        return Task$.MODULE$.$lessinit$greater$default$5();
    }

    public static <T> TaskData $lessinit$greater$default$4() {
        return Task$.MODULE$.$lessinit$greater$default$4();
    }

    public static Tuple4<HashMap<String, Object>, HashMap<String, Object>, Properties, ByteBuffer> deserializeWithDependencies(ByteBuffer byteBuffer) {
        return Task$.MODULE$.deserializeWithDependencies(byteBuffer);
    }

    public static ByteBuffer serializeWithDependencies(Task<?> task, Map<String, Object> map2, Map<String, Object> map3, SerializerInstance serializerInstance) {
        return Task$.MODULE$.serializeWithDependencies(task, map2, map3, serializerInstance);
    }

    private int _stageId() {
        return this._stageId;
    }

    private void _stageId_$eq(int x$1) {
        this._stageId = x$1;
    }

    private int _stageAttemptId() {
        return this._stageAttemptId;
    }

    private void _stageAttemptId_$eq(int x$1) {
        this._stageAttemptId = x$1;
    }

    private int _partitionId() {
        return this._partitionId;
    }

    private void _partitionId_$eq(int x$1) {
        this._partitionId = x$1;
    }

    public TaskData taskData() {
        return this.taskData;
    }

    public void taskData_$eq(TaskData x$1) {
        this.taskData = x$1;
    }

    public Option<Broadcast<byte[]>> taskBinary() {
        return this.taskBinary;
    }

    public void taskBinary_$eq(Option<Broadcast<byte[]>> x$1) {
        this.taskBinary = x$1;
    }

    private TaskMetrics _metrics() {
        return this._metrics;
    }

    private void _metrics_$eq(TaskMetrics x$1) {
        this._metrics = x$1;
    }

    public Properties localProperties() {
        return this.localProperties;
    }

    public void localProperties_$eq(Properties x$1) {
        this.localProperties = x$1;
    }

    private int _jobId() {
        return this._jobId;
    }

    private void _jobId_$eq(int x$1) {
        this._jobId = x$1;
    }

    private Option<String> _appId() {
        return this._appId;
    }

    private void _appId_$eq(Option<String> x$1) {
        this._appId = x$1;
    }

    private Option<String> _appAttemptId() {
        return this._appAttemptId;
    }

    private void _appAttemptId_$eq(Option<String> x$1) {
        this._appAttemptId = x$1;
    }

    public final int stageId() {
        return this._stageId();
    }

    public final int stageAttemptId() {
        return this._stageAttemptId();
    }

    public final int partitionId() {
        return this._partitionId();
    }

    public final int jobId() {
        return this._jobId();
    }

    public final TaskMetrics metrics() {
        return this._metrics();
    }

    public final String appId() {
        return this._appId().isDefined() ? (String)this._appId().get() : null;
    }

    public final String appAttemptId() {
        return this._appAttemptId().isDefined() ? (String)this._appAttemptId().get() : null;
    }

    public byte[] taskDataBytes() {
        return this.taskDataBytes;
    }

    public void taskDataBytes_$eq(byte[] x$1) {
        this.taskDataBytes = x$1;
    }

    public int cpusPerTask() {
        return this.cpusPerTask;
    }

    public void cpusPerTask_$eq(int x$1) {
        this.cpusPerTask = x$1;
    }

    public final byte[] getTaskBytes() {
        byte[] bytes = this.taskDataBytes();
        return bytes != null && bytes.length > 0 ? bytes : (byte[])((Broadcast)this.taskBinary().get()).value();
    }

    public final T run(long taskAttemptId, int attemptNumber, MetricsSystem metricsSystem) {
        T t;
        SparkEnv$.MODULE$.get().blockManager().registerTask(taskAttemptId);
        this.context_$eq(new TaskContextImpl(this.stageId(), this.stageAttemptId(), this.partitionId(), taskAttemptId, attemptNumber, this.taskMemoryManager(), this.localProperties(), metricsSystem, this.metrics()));
        TaskContext$.MODULE$.setTaskContext(this.context());
        this.taskThread_$eq(Thread.currentThread());
        if (this._killed()) {
            this.kill(false);
        }
        new CallerContext("TASK", this._appId(), this._appAttemptId(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.jobId())), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.stageId())), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.stageAttemptId())), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)taskAttemptId)), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)attemptNumber))).setCurrentContext();
        try {
            t = this.runTask(this.context());
            this.context().markTaskCompleted();
        }
        catch (Throwable throwable) {
            try {
                try {
                    this.context().markTaskFailed(throwable);
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                this.context().markTaskCompleted();
                try {
                    Utils$.MODULE$.tryLogNonFatalError((Function0<BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            MemoryManager memoryManager;
                            MemoryStore qual$1 = SparkEnv$.MODULE$.get().blockManager().memoryStore();
                            MemoryMode x$3 = MemoryMode.ON_HEAP;
                            long x$4 = qual$1.releaseUnrollMemoryForThisTask$default$2();
                            qual$1.releaseUnrollMemoryForThisTask(x$3, x$4);
                            MemoryStore qual$2 = SparkEnv$.MODULE$.get().blockManager().memoryStore();
                            MemoryMode x$5 = MemoryMode.OFF_HEAP;
                            long x$6 = qual$2.releaseUnrollMemoryForThisTask$default$2();
                            qual$2.releaseUnrollMemoryForThisTask(x$5, x$6);
                            MemoryManager memoryManager2 = memoryManager = SparkEnv$.MODULE$.get().memoryManager();
                            synchronized (memoryManager2) {
                                memoryManager.notifyAll();
                                return;
                            }
                        }
                    });
                }
                finally {
                    TaskContext$.MODULE$.unset();
                }
                throw throwable3;
            }
        }
        try {
            Utils$.MODULE$.tryLogNonFatalError((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */);
            return t;
        }
        finally {
            TaskContext$.MODULE$.unset();
        }
    }

    private TaskMemoryManager taskMemoryManager() {
        return this.taskMemoryManager;
    }

    private void taskMemoryManager_$eq(TaskMemoryManager x$1) {
        this.taskMemoryManager = x$1;
    }

    public void setTaskMemoryManager(TaskMemoryManager taskMemoryManager) {
        this.taskMemoryManager_$eq(taskMemoryManager);
    }

    public abstract T runTask(TaskContext var1);

    public Seq<TaskLocation> preferredLocations() {
        return Nil$.MODULE$;
    }

    public long epoch() {
        return this.epoch;
    }

    public void epoch_$eq(long x$1) {
        this.epoch = x$1;
    }

    public TaskContextImpl context() {
        return this.context;
    }

    public void context_$eq(TaskContextImpl x$1) {
        this.context = x$1;
    }

    private Thread taskThread() {
        return this.taskThread;
    }

    private void taskThread_$eq(Thread x$1) {
        this.taskThread = x$1;
    }

    private boolean _killed() {
        return this._killed;
    }

    private void _killed_$eq(boolean x$1) {
        this._killed = x$1;
    }

    public long _executorDeserializeTime() {
        return this._executorDeserializeTime;
    }

    public void _executorDeserializeTime_$eq(long x$1) {
        this._executorDeserializeTime = x$1;
    }

    public long _executorDeserializeCpuTime() {
        return this._executorDeserializeCpuTime;
    }

    public void _executorDeserializeCpuTime_$eq(long x$1) {
        this._executorDeserializeCpuTime = x$1;
    }

    public boolean killed() {
        return this._killed();
    }

    public long executorDeserializeTime() {
        return this._executorDeserializeTime();
    }

    public long executorDeserializeCpuTime() {
        return this._executorDeserializeCpuTime();
    }

    public Seq<AccumulatorV2<?, ?>> collectAccumulatorUpdates(boolean taskFailed) {
        return this.context() == null ? (Seq)Seq$.MODULE$.empty() : (Seq)((TraversableLike)this.context().taskMetrics().internalAccums().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(AccumulatorV2<?, ?> a) {
                if (!a.isZero()) return true;
                Option<String> option = a.name();
                Some some = new Some((Object)InternalAccumulator$.MODULE$.RESULT_SIZE());
                if (option == null) {
                    if (some == null) return true;
                    return false;
                } else if (option.equals((Object)some)) return true;
                return false;
            }
        })).$plus$plus((GenTraversableOnce)this.context().taskMetrics().externalAccums().filter((Function1)new Serializable(this, taskFailed){
            public static final long serialVersionUID = 0L;
            private final boolean taskFailed$1;

            public final boolean apply(AccumulatorV2<?, ?> a) {
                return !this.taskFailed$1 || a.countFailedValues();
            }
            {
                this.taskFailed$1 = taskFailed$1;
            }
        }), Seq$.MODULE$.canBuildFrom());
    }

    public boolean collectAccumulatorUpdates$default$1() {
        return false;
    }

    public void kill(boolean interruptThread) {
        this._killed_$eq(true);
        if (this.context() != null) {
            this.context().markInterrupted();
        }
        if (interruptThread && this.taskThread() != null) {
            this.taskThread().interrupt();
        }
    }

    public void writeKryo(Kryo kryo, Output output) {
        output.writeInt(this._stageId());
        output.writeVarInt(this._stageAttemptId(), true);
        output.writeVarInt(this._partitionId(), true);
        output.writeVarInt(this._jobId(), true);
        output.writeLong(this.epoch());
        output.writeLong(this._executorDeserializeTime());
        output.writeLong(this._executorDeserializeCpuTime());
        if (this.taskData() != null && this.taskData().uncompressedLen() > 0) {
            output.writeBoolean(true);
        } else {
            output.writeBoolean(false);
            kryo.writeClassAndObject(output, this.taskBinary().get());
        }
        this._metrics().write(kryo, output);
        output.writeString(this.appId());
        output.writeString(this.appAttemptId());
    }

    public void readKryo(Kryo kryo, Input input) {
        this._stageId_$eq(input.readInt());
        this._stageAttemptId_$eq(input.readVarInt(true));
        this._partitionId_$eq(input.readVarInt(true));
        this._jobId_$eq(input.readVarInt(true));
        this.epoch_$eq(input.readLong());
        this._executorDeserializeTime_$eq(input.readLong());
        this._executorDeserializeCpuTime_$eq(input.readLong());
        this.taskData_$eq(TaskData$.MODULE$.EMPTY());
        if (input.readBoolean()) {
            this.taskBinary_$eq((Option<Broadcast<byte[]>>)None$.MODULE$);
        } else {
            this.taskBinary_$eq((Option<Broadcast<byte[]>>)new Some((Object)((Broadcast)kryo.readClassAndObject(input))));
        }
        this._metrics_$eq(new TaskMetrics());
        this._metrics().read(kryo, input);
        this._appId_$eq((Option<String>)Option$.MODULE$.apply((Object)input.readString()));
        this._appAttemptId_$eq((Option<String>)Option$.MODULE$.apply((Object)input.readString()));
    }

    public Task(int _stageId, int _stageAttemptId, int _partitionId, TaskData taskData, Option<Broadcast<byte[]>> taskBinary, TaskMetrics _metrics, Properties localProperties, int _jobId, Option<String> _appId, Option<String> _appAttemptId) {
        this._stageId = _stageId;
        this._stageAttemptId = _stageAttemptId;
        this._partitionId = _partitionId;
        this.taskData = taskData;
        this.taskBinary = taskBinary;
        this._metrics = _metrics;
        this.localProperties = localProperties;
        this._jobId = _jobId;
        this._appId = _appId;
        this._appAttemptId = _appAttemptId;
        this.epoch = -1L;
        this._killed = false;
        this._executorDeserializeTime = 0L;
        this._executorDeserializeCpuTime = 0L;
    }
}

