/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.internal;

import java.net.URL;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;

public abstract class Logging$class {
    public static String logName(Logging $this) {
        return new StringOps(Predef$.MODULE$.augmentString($this.getClass().getName())).stripSuffix("$");
    }

    public static Logger log(Logging $this) {
        if ($this.org$apache$spark$internal$Logging$$log_() == null) {
            $this.initializeLogIfNecessary(false);
            $this.org$apache$spark$internal$Logging$$log__$eq(LoggerFactory.getLogger((String)$this.logName()));
        }
        return $this.org$apache$spark$internal$Logging$$log_();
    }

    public static void logInfo(Logging $this, Function0 msg) {
        if ($this.log().isInfoEnabled()) {
            $this.log().info((String)msg.apply());
        }
    }

    public static void logDebug(Logging $this, Function0 msg) {
        if ($this.log().isDebugEnabled()) {
            $this.log().debug((String)msg.apply());
        }
    }

    public static void logTrace(Logging $this, Function0 msg) {
        if ($this.log().isTraceEnabled()) {
            $this.log().trace((String)msg.apply());
        }
    }

    public static void logWarning(Logging $this, Function0 msg) {
        if ($this.log().isWarnEnabled()) {
            $this.log().warn((String)msg.apply());
        }
    }

    public static void logError(Logging $this, Function0 msg) {
        if ($this.log().isErrorEnabled()) {
            $this.log().error((String)msg.apply());
        }
    }

    public static void logInfo(Logging $this, Function0 msg, Throwable throwable) {
        if ($this.log().isInfoEnabled()) {
            $this.log().info((String)msg.apply(), throwable);
        }
    }

    public static void logDebug(Logging $this, Function0 msg, Throwable throwable) {
        if ($this.log().isDebugEnabled()) {
            $this.log().debug((String)msg.apply(), throwable);
        }
    }

    public static void logTrace(Logging $this, Function0 msg, Throwable throwable) {
        if ($this.log().isTraceEnabled()) {
            $this.log().trace((String)msg.apply(), throwable);
        }
    }

    public static void logWarning(Logging $this, Function0 msg, Throwable throwable) {
        if ($this.log().isWarnEnabled()) {
            $this.log().warn((String)msg.apply(), throwable);
        }
    }

    public static void logError(Logging $this, Function0 msg, Throwable throwable) {
        if ($this.log().isErrorEnabled()) {
            $this.log().error((String)msg.apply(), throwable);
        }
    }

    public static boolean isTraceEnabled(Logging $this) {
        return $this.log().isTraceEnabled();
    }

    public static void initializeLogIfNecessary(Logging $this, boolean isInterpreter) {
        $this.initializeLogIfNecessary(isInterpreter, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean initializeLogIfNecessary(Logging $this, boolean isInterpreter, boolean silent) {
        BoxedUnit boxedUnit;
        if (Logging$.MODULE$.org$apache$spark$internal$Logging$$initialized()) {
            boxedUnit = BoxedUnit.UNIT;
            return false;
        }
        Object object = Logging$.MODULE$.initLock();
        synchronized (object) {
            if (Logging$.MODULE$.org$apache$spark$internal$Logging$$initialized()) {
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                // MONITOREXIT @DISABLED, blocks:[0, 2, 5] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                boxedUnit = boxedUnit2;
                return false;
            }
            {
                Logging$class.initializeLogging($this, isInterpreter, silent);
                return true;
            }
        }
    }

    public static boolean initializeLogIfNecessary$default$2(Logging $this) {
        return false;
    }

    private static void initializeLogging(Logging $this, boolean isInterpreter, boolean silent) {
        if (Logging$.MODULE$.org$apache$spark$internal$Logging$$isLog4j2()) {
            org.apache.logging.log4j.core.Logger rootLogger = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
            if (Logging$.MODULE$.islog4j2DefaultConfigured()) {
                Logging$.MODULE$.org$apache$spark$internal$Logging$$defaultSparkLog4jConfig_$eq(true);
                String defaultLogProps = "org/apache/spark/log4j2-defaults.properties";
                Option option = Option$.MODULE$.apply((Object)Utils$.MODULE$.getSparkClassLoader().getResource(defaultLogProps));
                if (option instanceof Some) {
                    BoxedUnit boxedUnit;
                    Some some = (Some)option;
                    URL url = (URL)some.x();
                    LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
                    context.setConfigLocation(url.toURI());
                    if (silent) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using Spark's default log4j profile: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultLogProps})));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else if (None$.MODULE$.equals(option)) {
                    System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Spark was unable to load ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultLogProps})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
            }
            if (Logging$.MODULE$.org$apache$spark$internal$Logging$$defaultRootLevel() == null) {
                Logging$.MODULE$.org$apache$spark$internal$Logging$$defaultRootLevel_$eq(rootLogger.getLevel());
            }
            if (isInterpreter) {
                Level replLevel;
                org.apache.logging.log4j.core.Logger replLogger = (org.apache.logging.log4j.core.Logger)LogManager.getLogger((String)$this.logName());
                Level level = replLevel = Logging$.MODULE$.org$apache$spark$internal$Logging$$loggerWithCustomConfig(replLogger) ? replLogger.getLevel() : Level.WARN;
                Level level2 = rootLogger.getLevel();
                if (level == null ? level2 != null : !level.equals(level2)) {
                    if (!silent) {
                        System.err.printf("Setting default log level to \"%s\".\n", replLevel);
                        System.err.println("To adjust logging level use sc.setLogLevel(newLevel). For SparkR, use setLogLevel(newLevel).");
                    }
                    Logging$.MODULE$.sparkShellThresholdLevel_$eq(replLevel);
                    ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(rootLogger.getAppenders()).asScala()).foreach((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Tuple2<String, Appender> x0$1) {
                            Appender ca;
                            Tuple2<String, Appender> tuple2 = x0$1;
                            if (tuple2 != null && (ca = (Appender)tuple2._2()) instanceof ConsoleAppender) {
                                ConsoleAppender consoleAppender = (ConsoleAppender)ca;
                                consoleAppender.addFilter((Filter)new Logging.SparkShellLoggingFilter());
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                    });
                }
            }
        }
        Logging$.MODULE$.org$apache$spark$internal$Logging$$initialized_$eq(true);
        $this.log();
    }

    public static void $init$(Logging $this) {
        $this.org$apache$spark$internal$Logging$$log__$eq(null);
    }
}

