/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.spark.MapOutputTracker$$anonfun$org$apache$spark$MapOutputTracker$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.broadcast.BroadcastManager;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.shuffle.MetadataFetchFailedException;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class MapOutputTracker$
implements Logging {
    public static final MapOutputTracker$ MODULE$;
    private final String ENDPOINT_NAME;
    private final int DIRECT;
    private final int BROADCAST;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new MapOutputTracker$();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging$class.initializeLogIfNecessary(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging$class.initializeLogIfNecessary$default$2(this);
    }

    public String ENDPOINT_NAME() {
        return this.ENDPOINT_NAME;
    }

    private int DIRECT() {
        return this.DIRECT;
    }

    private int BROADCAST() {
        return this.BROADCAST;
    }

    public Tuple2<byte[], Broadcast<byte[]>> serializeMapStatuses(MapStatus[] statuses, BroadcastManager broadcastManager, boolean isLocal, int minBroadcastSize) {
        Tuple2 tuple2;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(this.DIRECT());
        ObjectOutputStream objOut = new ObjectOutputStream(new GZIPOutputStream(out));
        Utils$.MODULE$.tryWithSafeFinally(new Serializable(statuses, objOut){
            public static final long serialVersionUID = 0L;
            private final MapStatus[] statuses$2;
            private final ObjectOutputStream objOut$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MapStatus[] mapStatusArray = this.statuses$2;
                synchronized (this.statuses$2) {
                    this.objOut$1.writeObject(this.statuses$2);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
            {
                this.statuses$2 = statuses$2;
                this.objOut$1 = objOut$1;
            }
        }, (Function0<BoxedUnit>)new Serializable(objOut){
            public static final long serialVersionUID = 0L;
            private final ObjectOutputStream objOut$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.objOut$1.close();
            }
            {
                this.objOut$1 = objOut$1;
            }
        });
        byte[] arr = out.toByteArray();
        if (arr.length >= minBroadcastSize) {
            Broadcast<byte[]> bcast = broadcastManager.newBroadcast(arr, isLocal, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            out.reset();
            out.write(this.BROADCAST());
            ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream(out));
            oos.writeObject(bcast);
            oos.close();
            byte[] outArr = out.toByteArray();
            this.logInfo((Function0<String>)new Serializable(arr, outArr){
                public static final long serialVersionUID = 0L;
                private final byte[] arr$1;
                private final byte[] outArr$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Broadcast mapstatuses size = ").append((Object)BoxesRunTime.boxToInteger((int)this.outArr$1.length)).append((Object)", actual size = ").append((Object)BoxesRunTime.boxToInteger((int)this.arr$1.length)).toString();
                }
                {
                    this.arr$1 = arr$1;
                    this.outArr$1 = outArr$1;
                }
            });
            tuple2 = new Tuple2((Object)outArr, bcast);
        } else {
            tuple2 = new Tuple2((Object)arr, null);
        }
        return tuple2;
    }

    public MapStatus[] deserializeMapStatuses(byte[] bytes) {
        block4: {
            MapStatus[] mapStatusArray;
            block3: {
                byte by;
                block2: {
                    Predef$.MODULE$.assert(bytes.length > 0);
                    by = bytes[0];
                    if (this.DIRECT() != by) break block2;
                    mapStatusArray = (MapStatus[])this.deserializeObject$1(bytes, 1, bytes.length - 1);
                    break block3;
                }
                if (this.BROADCAST() != by) break block4;
                Broadcast bcast = (Broadcast)this.deserializeObject$1(bytes, 1, bytes.length - 1);
                this.logInfo((Function0<String>)new Serializable(bytes, bcast){
                    public static final long serialVersionUID = 0L;
                    private final byte[] bytes$1;
                    private final Broadcast bcast$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Broadcast mapstatuses size = ").append((Object)BoxesRunTime.boxToInteger((int)this.bytes$1.length)).append((Object)", actual size = ").append((Object)BoxesRunTime.boxToInteger((int)((byte[])this.bcast$1.value()).length)).toString();
                    }
                    {
                        this.bytes$1 = bytes$1;
                        this.bcast$1 = bcast$1;
                    }
                });
                mapStatusArray = (MapStatus[])this.deserializeObject$1((byte[])bcast.value(), 1, ((byte[])bcast.value()).length - 1);
            }
            return mapStatusArray;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Unexpected byte tag = ").append((Object)BoxesRunTime.boxToByte((byte)bytes[0])).toString());
    }

    public Seq<Tuple2<BlockManagerId, Seq<Tuple2<BlockId, Object>>>> org$apache$spark$MapOutputTracker$$convertMapStatuses(int shuffleId, int startPartition, int endPartition, MapStatus[] statuses) {
        Predef$.MODULE$.assert(statuses != null);
        HashMap splitsByAddress = new HashMap();
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])statuses).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<MapStatus, Object> check$ifrefutable$1) {
                Tuple2<MapStatus, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(shuffleId, startPartition, endPartition, splitsByAddress){
            public static final long serialVersionUID = 0L;
            public final int shuffleId$3;
            private final int startPartition$2;
            private final int endPartition$2;
            public final HashMap splitsByAddress$1;

            public final void apply(Tuple2<MapStatus, Object> x$3) {
                Tuple2<MapStatus, Object> tuple2 = x$3;
                if (tuple2 != null) {
                    MapStatus status = (MapStatus)tuple2._1();
                    int mapId = tuple2._2$mcI$sp();
                    if (status == null) {
                        String errorMessage = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing an output location for shuffle ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.shuffleId$3)}));
                        MapOutputTracker$.MODULE$.logError((Function0<String>)new Serializable(this, errorMessage){
                            public static final long serialVersionUID = 0L;
                            private final String errorMessage$1;

                            public final String apply() {
                                return this.errorMessage$1;
                            }
                            {
                                this.errorMessage$1 = errorMessage$1;
                            }
                        });
                        throw new MetadataFetchFailedException(this.shuffleId$3, this.startPartition$2, errorMessage);
                    }
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.startPartition$2), this.endPartition$2).foreach((Function1)new Serializable(this, status, mapId){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun$org$apache$spark$MapOutputTracker$$convertMapStatuses$2 $outer;
                        private final MapStatus status$1;
                        private final int mapId$1;

                        public final ArrayBuffer<Tuple2<BlockId, Object>> apply(int part) {
                            return ((ArrayBuffer)this.$outer.splitsByAddress$1.getOrElseUpdate((Object)this.status$1.location(), (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final ArrayBuffer<Tuple2<BlockId, Object>> apply() {
                                    return (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                                }
                            })).$plus$eq((Object)new Tuple2((Object)new ShuffleBlockId(this.$outer.shuffleId$3, this.mapId$1, part), (Object)BoxesRunTime.boxToLong((long)this.status$1.getSizeForBlock(part))));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.status$1 = status$1;
                            this.mapId$1 = mapId$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.shuffleId$3 = shuffleId$3;
                this.startPartition$2 = startPartition$2;
                this.endPartition$2 = endPartition$2;
                this.splitsByAddress$1 = splitsByAddress$1;
            }
        });
        return splitsByAddress.toSeq();
    }

    private final Object deserializeObject$1(byte[] arr, int off, int len) {
        ObjectInputStream objIn = new ObjectInputStream(new GZIPInputStream(new ByteArrayInputStream(arr, off, len)));
        return Utils$.MODULE$.tryWithSafeFinally(new Serializable(objIn){
            public static final long serialVersionUID = 0L;
            private final ObjectInputStream objIn$1;

            public final Object apply() {
                return this.objIn$1.readObject();
            }
            {
                this.objIn$1 = objIn$1;
            }
        }, (Function0<BoxedUnit>)new Serializable(objIn){
            public static final long serialVersionUID = 0L;
            private final ObjectInputStream objIn$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.objIn$1.close();
            }
            {
                this.objIn$1 = objIn$1;
            }
        });
    }

    private MapOutputTracker$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.ENDPOINT_NAME = "MapOutputTracker";
        this.DIRECT = 0;
        this.BROADCAST = 1;
    }
}

