/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rpc.netty;

import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.client.StreamCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientBootstrap;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.sasl.SaslClientBootstrap;
import org.apache.spark.network.sasl.SaslServerBootstrap;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.NoOpRpcHandler;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.server.TransportServerBootstrap;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointAddress;
import org.apache.spark.rpc.RpcEndpointAddress$;
import org.apache.spark.rpc.RpcEndpointNotFoundException;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.RpcEnvFileServer;
import org.apache.spark.rpc.RpcEnvStoppedException;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.rpc.netty.Dispatcher;
import org.apache.spark.rpc.netty.NettyRpcEndpointRef;
import org.apache.spark.rpc.netty.NettyRpcEnv$;
import org.apache.spark.rpc.netty.NettyRpcHandler;
import org.apache.spark.rpc.netty.NettyStreamManager;
import org.apache.spark.rpc.netty.OneWayOutboxMessage;
import org.apache.spark.rpc.netty.Outbox;
import org.apache.spark.rpc.netty.OutboxMessage;
import org.apache.spark.rpc.netty.RequestMessage;
import org.apache.spark.rpc.netty.RpcEndpointVerifier;
import org.apache.spark.rpc.netty.RpcEndpointVerifier$;
import org.apache.spark.rpc.netty.RpcFailure;
import org.apache.spark.rpc.netty.RpcOutboxMessage;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0011-b!B\u0001\u0003\u0001\ta!a\u0003(fiRL(\u000b]2F]ZT!a\u0001\u0003\u0002\u000b9,G\u000f^=\u000b\u0005\u00151\u0011a\u0001:qG*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bE\u0001\"AD\b\u000e\u0003\u0011I!\u0001\u0005\u0003\u0003\rI\u00038-\u00128w!\t\u0011R#D\u0001\u0014\u0015\t!b!\u0001\u0005j]R,'O\\1m\u0013\t12CA\u0004M_\u001e<\u0017N\\4\t\u0011a\u0001!Q1A\u0005\u0002i\tAaY8oM\u000e\u0001Q#A\u000e\u0011\u0005qiR\"\u0001\u0004\n\u0005y1!!C*qCJ\\7i\u001c8g\u0011!\u0001\u0003A!A!\u0002\u0013Y\u0012!B2p]\u001a\u0004\u0003\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002\u0015M,'/[1mSj,'\u000f\u0005\u0002%M5\tQE\u0003\u0002#\r%\u0011q%\n\u0002\u000b'\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\u0002\t!|7\u000f\u001e\t\u0003WEr!\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\na\u0001\u0015:fI\u00164\u0017B\u0001\u001a4\u0005\u0019\u0019FO]5oO*\u0011\u0001'\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m\u0005y1/Z2ve&$\u00180T1oC\u001e,'\u000f\u0005\u0002\u001do%\u0011\u0001H\u0002\u0002\u0010'\u0016\u001cWO]5us6\u000bg.Y4fe\")!\b\u0001C\u0001w\u00051A(\u001b8jiz\"R\u0001\u0010 @\u0001\u0006\u0003\"!\u0010\u0001\u000e\u0003\tAQ\u0001G\u001dA\u0002mAQAI\u001dA\u0002\rBQ!K\u001dA\u0002)BQ!N\u001dA\u0002YB\u0001b\u0011\u0001C\u0002\u0013\u0005!\u0001R\u0001\u000eiJ\fgn\u001d9peR\u001cuN\u001c4\u0016\u0003\u0015\u0003\"AR&\u000e\u0003\u001dS!\u0001S%\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0015\u001a\tqA\\3uo>\u00148.\u0003\u0002M\u000f\niAK]1ogB|'\u000f^\"p]\u001aDaA\u0014\u0001!\u0002\u0013)\u0015A\u0004;sC:\u001c\bo\u001c:u\u0007>tg\r\t\u0005\b!\u0002\u0011\r\u0011\"\u0003R\u0003I\u0019XM]5bY&TXM]%ogR\fgnY3\u0016\u0003I\u00032a\u0015-[\u001b\u0005!&BA+W\u0003\u0011a\u0017M\\4\u000b\u0003]\u000bAA[1wC&\u0011\u0011\f\u0016\u0002\f)\"\u0014X-\u00193M_\u000e\fG\u000e\u0005\u0002%7&\u0011A,\n\u0002\u0013'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018J\\:uC:\u001cW\r\u0003\u0004_\u0001\u0001\u0006IAU\u0001\u0014g\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018J\\:uC:\u001cW\r\t\u0005\bA\u0002\u0011\r\u0011\"\u0003b\u0003)!\u0017n\u001d9bi\u000eDWM]\u000b\u0002EB\u0011QhY\u0005\u0003I\n\u0011!\u0002R5ta\u0006$8\r[3s\u0011\u00191\u0007\u0001)A\u0005E\u0006YA-[:qCR\u001c\u0007.\u001a:!\u0011\u001dA\u0007A1A\u0005\n%\fQb\u001d;sK\u0006lW*\u00198bO\u0016\u0014X#\u00016\u0011\u0005uZ\u0017B\u00017\u0003\u0005IqU\r\u001e;z'R\u0014X-Y7NC:\fw-\u001a:\t\r9\u0004\u0001\u0015!\u0003k\u00039\u0019HO]3b[6\u000bg.Y4fe\u0002Bq\u0001\u001d\u0001C\u0002\u0013%\u0011/\u0001\tue\u0006t7\u000f]8si\u000e{g\u000e^3yiV\t!\u000f\u0005\u0002ti6\t\u0011*\u0003\u0002v\u0013\n\u0001BK]1ogB|'\u000f^\"p]R,\u0007\u0010\u001e\u0005\u0007o\u0002\u0001\u000b\u0011\u0002:\u0002#Q\u0014\u0018M\\:q_J$8i\u001c8uKb$\b\u0005C\u0003z\u0001\u0011%!0\u0001\fde\u0016\fG/Z\"mS\u0016tGOQ8piN$(/\u00199t)\u0005Y\b\u0003\u0002?\u007f\u0003\u0003i\u0011! \u0006\u0003\u0011ZK!a`?\u0003\t1K7\u000f\u001e\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011qA%\u0002\r\rd\u0017.\u001a8u\u0013\u0011\tY!!\u0002\u00031Q\u0013\u0018M\\:q_J$8\t\\5f]R\u0014un\u001c;tiJ\f\u0007\u000fC\u0005\u0002\u0010\u0001\u0011\r\u0011\"\u0003\u0002\u0012\u0005i1\r\\5f]R4\u0015m\u0019;pef,\"!a\u0005\u0011\t\u0005\r\u0011QC\u0005\u0005\u0003/\t)A\u0001\fUe\u0006t7\u000f]8si\u000ec\u0017.\u001a8u\r\u0006\u001cGo\u001c:z\u0011!\tY\u0002\u0001Q\u0001\n\u0005M\u0011AD2mS\u0016tGOR1di>\u0014\u0018\u0010\t\u0005\f\u0003?\u0001\u0001\u0019!a\u0001\n\u0013\t\t\"A\ngS2,Gi\\<oY>\fGMR1di>\u0014\u0018\u0010C\u0006\u0002$\u0001\u0001\r\u00111A\u0005\n\u0005\u0015\u0012a\u00064jY\u0016$un\u001e8m_\u0006$g)Y2u_JLx\fJ3r)\u0011\t9#!\f\u0011\u00071\nI#C\u0002\u0002,5\u0012A!\u00168ji\"Q\u0011qFA\u0011\u0003\u0003\u0005\r!a\u0005\u0002\u0007a$\u0013\u0007\u0003\u0005\u00024\u0001\u0001\u000b\u0015BA\n\u0003Q1\u0017\u000e\\3E_^tGn\\1e\r\u0006\u001cGo\u001c:zA!\"\u0011\u0011GA\u001c!\ra\u0013\u0011H\u0005\u0004\u0003wi#\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0013\u0005}\u0002A1A\u0005\u0002\u0005\u0005\u0013\u0001\u0005;j[\u0016|W\u000f^*dQ\u0016$W\u000f\\3s+\t\t\u0019\u0005\u0005\u0003\u0002F\u0005-SBAA$\u0015\r\tI%`\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA'\u0003\u000f\u0012\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011!\t\t\u0006\u0001Q\u0001\n\u0005\r\u0013!\u0005;j[\u0016|W\u000f^*dQ\u0016$W\u000f\\3sA!Q\u0011Q\u000b\u0001C\u0002\u0013\u0005!!a\u0016\u00021\rd\u0017.\u001a8u\u0007>tg.Z2uS>tW\t_3dkR|'/\u0006\u0002\u0002ZA!\u0011QIA.\u0013\u0011\ti&a\u0012\u0003%QC'/Z1e!>|G.\u0012=fGV$xN\u001d\u0005\t\u0003C\u0002\u0001\u0015!\u0003\u0002Z\u0005I2\r\\5f]R\u001cuN\u001c8fGRLwN\\#yK\u000e,Ho\u001c:!\u0011-\t)\u0007\u0001a\u0001\u0002\u0004%I!a\u001a\u0002\rM,'O^3s+\t\tI\u0007\u0005\u0003\u0002l\u0005=TBAA7\u0015\r\t)'S\u0005\u0005\u0003c\niGA\bUe\u0006t7\u000f]8siN+'O^3s\u0011-\t)\b\u0001a\u0001\u0002\u0004%I!a\u001e\u0002\u0015M,'O^3s?\u0012*\u0017\u000f\u0006\u0003\u0002(\u0005e\u0004BCA\u0018\u0003g\n\t\u00111\u0001\u0002j!A\u0011Q\u0010\u0001!B\u0013\tI'A\u0004tKJ4XM\u001d\u0011)\t\u0005m\u0014q\u0007\u0005\n\u0003\u0007\u0003!\u0019!C\u0005\u0003\u000b\u000bqa\u001d;paB,G-\u0006\u0002\u0002\bB!\u0011\u0011RAH\u001b\t\tYI\u0003\u0003\u0002\u000e\u0006\u001d\u0013AB1u_6L7-\u0003\u0003\u0002\u0012\u0006-%!D!u_6L7MQ8pY\u0016\fg\u000e\u0003\u0005\u0002\u0016\u0002\u0001\u000b\u0011BAD\u0003!\u0019Ho\u001c9qK\u0012\u0004\u0003\"CAM\u0001\t\u0007I\u0011BAN\u0003!yW\u000f\u001e2pq\u0016\u001cXCAAO!!\t)%a(\u0002$\u0006%\u0016\u0002BAQ\u0003\u000f\u0012\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\rq\u0011QU\u0005\u0004\u0003O#!A\u0003*qG\u0006#GM]3tgB\u0019Q(a+\n\u0007\u00055&A\u0001\u0004PkR\u0014w\u000e\u001f\u0005\t\u0003c\u0003\u0001\u0015!\u0003\u0002\u001e\u0006Iq.\u001e;c_b,7\u000f\t\u0005\t\u0003k\u0003A\u0011\u0001\u0002\u00028\u0006a!/Z7pm\u0016|U\u000f\u001e2pqR!\u0011qEA]\u0011!\tY,a-A\u0002\u0005\r\u0016aB1eIJ,7o\u001d\u0005\b\u0003\u007f\u0003A\u0011AAa\u0003-\u0019H/\u0019:u'\u0016\u0014h/\u001a:\u0015\r\u0005\u001d\u00121YAd\u0011\u001d\t)-!0A\u0002)\n1BY5oI\u0006#GM]3tg\"A\u0011\u0011ZA_\u0001\u0004\tY-\u0001\u0003q_J$\bc\u0001\u0017\u0002N&\u0019\u0011qZ\u0017\u0003\u0007%sG\u000f\u0003\u0006\u0002<\u0002A)\u0019!C!\u0003',\"!a)\t\u0015\u0005]\u0007\u0001#A!B\u0013\t\u0019+\u0001\u0005bI\u0012\u0014Xm]:!Q\u0011\t).a7\u0011\t\u0005u\u0017q]\u0007\u0003\u0003?TA!!9\u0002d\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\u0005\u0015\u0018!\u00026bm\u0006D\u0018\u0002BAu\u0003?\u0014\u0001BT;mY\u0006\u0014G.\u001a\u0005\b\u0003[\u0004A\u0011IAx\u00035\u0019X\r^;q\u000b:$\u0007o\\5oiR1\u0011\u0011_A|\u0003w\u00042ADAz\u0013\r\t)\u0010\u0002\u0002\u000f%B\u001cWI\u001c3q_&tGOU3g\u0011\u001d\tI0a;A\u0002)\nAA\\1nK\"A\u0011Q`Av\u0001\u0004\ty0\u0001\u0005f]\u0012\u0004x.\u001b8u!\rq!\u0011A\u0005\u0004\u0005\u0007!!a\u0003*qG\u0016sG\r]8j]RDqAa\u0002\u0001\t\u0003\u0011I!\u0001\u000ebgft7mU3ukB,e\u000e\u001a9pS:$(+\u001a4CsV\u0013\u0016\n\u0006\u0003\u0003\f\tU\u0001C\u0002B\u0007\u0005#\t\t0\u0004\u0002\u0003\u0010)\u0019\u0011\u0011J\u0017\n\t\tM!q\u0002\u0002\u0007\rV$XO]3\t\u000f\t]!Q\u0001a\u0001U\u0005\u0019QO]5\t\u000f\tm\u0001\u0001\"\u0011\u0003\u001e\u0005!1\u000f^8q)\u0011\t9Ca\b\t\u0011\t\u0005\"\u0011\u0004a\u0001\u0003c\f1\"\u001a8ea>Lg\u000e\u001e*fM\"9!Q\u0005\u0001\u0005\n\t\u001d\u0012\u0001\u00049pgR$vnT;uE>DHCBA\u0014\u0005S\u0011\u0019\u0004\u0003\u0005\u0003,\t\r\u0002\u0019\u0001B\u0017\u0003!\u0011XmY3jm\u0016\u0014\bcA\u001f\u00030%\u0019!\u0011\u0007\u0002\u0003'9+G\u000f^=Sa\u000e,e\u000e\u001a9pS:$(+\u001a4\t\u0011\tU\"1\u0005a\u0001\u0005o\tq!\\3tg\u0006<W\rE\u0002>\u0005sI1Aa\u000f\u0003\u00055yU\u000f\u001e2pq6+7o]1hK\"A!q\b\u0001\u0005\u0002\t\u0011\t%\u0001\u0003tK:$G\u0003BA\u0014\u0005\u0007B\u0001B!\u000e\u0003>\u0001\u0007!Q\t\t\u0004{\t\u001d\u0013b\u0001B%\u0005\tq!+Z9vKN$X*Z:tC\u001e,\u0007\u0002\u0003B'\u0001\u0011\u0005!Aa\u0014\u0002\u0019\r\u0014X-\u0019;f\u00072LWM\u001c;\u0015\t\tE#q\u000b\t\u0005\u0003\u0007\u0011\u0019&\u0003\u0003\u0003V\u0005\u0015!a\u0004+sC:\u001c\bo\u001c:u\u00072LWM\u001c;\t\u0011\u0005m&1\na\u0001\u0003GC\u0001Ba\u0017\u0001\t\u0003\u0011!QL\u0001\u0004CN\\W\u0003\u0002B0\u0005S\"bA!\u0019\u0003\f\n5E\u0003\u0002B2\u0005w\u0002bA!\u0004\u0003\u0012\t\u0015\u0004\u0003\u0002B4\u0005Sb\u0001\u0001\u0002\u0005\u0003l\te#\u0019\u0001B7\u0005\u0005!\u0016\u0003\u0002B8\u0005k\u00022\u0001\fB9\u0013\r\u0011\u0019(\f\u0002\b\u001d>$\b.\u001b8h!\ra#qO\u0005\u0004\u0005sj#aA!os\"Q!Q\u0010B-\u0003\u0003\u0005\u001dAa \u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007\u0005\u0004\u0003\u0002\n\u001d%QM\u0007\u0003\u0005\u0007S1A!\".\u0003\u001d\u0011XM\u001a7fGRLAA!#\u0003\u0004\nA1\t\\1tgR\u000bw\r\u0003\u0005\u00036\te\u0003\u0019\u0001B#\u0011!\u0011yI!\u0017A\u0002\tE\u0015a\u0002;j[\u0016|W\u000f\u001e\t\u0004\u001d\tM\u0015b\u0001BK\t\tQ!\u000b]2US6,w.\u001e;\t\u0011\te\u0005\u0001\"\u0001\u0003\u00057\u000b\u0011b]3sS\u0006d\u0017N_3\u0015\t\tu%\u0011\u0016\t\u0005\u0005?\u0013)+\u0004\u0002\u0003\"*\u0019!1\u0015,\u0002\u00079Lw.\u0003\u0003\u0003(\n\u0005&A\u0003\"zi\u0016\u0014UO\u001a4fe\"A!1\u0016BL\u0001\u0004\u0011)(A\u0004d_:$XM\u001c;\t\u0011\t=\u0006\u0001\"\u0001\u0003\u0005c\u000b1\u0002Z3tKJL\u0017\r\\5{KV!!1\u0017B])\u0019\u0011)L!1\u0003DR!!q\u0017B^!\u0011\u00119G!/\u0005\u0011\t-$Q\u0016b\u0001\u0005[B!B!0\u0003.\u0006\u0005\t9\u0001B`\u0003))g/\u001b3f]\u000e,GE\r\t\u0007\u0005\u0003\u00139Ia.\t\u0011\u0005\u001d!Q\u0016a\u0001\u0005#B\u0001B!2\u0003.\u0002\u0007!QT\u0001\u0006Ef$Xm\u001d\u0005\b\u0005C\u0001A\u0011\tBe)\u0011\t\tPa3\t\u0011\u0005u(q\u0019a\u0001\u0003\u007fDqAa4\u0001\t\u0003\u0012\t.\u0001\u0005tQV$Hm\\<o)\t\t9\u0003C\u0004\u0003V\u0002!\tE!5\u0002!\u0005<\u0018-\u001b;UKJl\u0017N\\1uS>t\u0007b\u0002Bm\u0001\u0011%!\u0011[\u0001\bG2,\u0017M\\;q\u0011\u001d\u0011y\u000b\u0001C!\u0005;,BAa8\u0003dR!!\u0011\u001dBs!\u0011\u00119Ga9\u0005\u0011\t-$1\u001cb\u0001\u0005[B\u0001Ba:\u0003\\\u0002\u0007!\u0011^\u0001\u0016I\u0016\u001cXM]5bY&T\u0018\r^5p]\u0006\u001bG/[8o!\u0015a#1\u001eBq\u0013\r\u0011i/\f\u0002\n\rVt7\r^5p]BBqA!=\u0001\t\u0003\u0012\u00190\u0001\u0006gS2,7+\u001a:wKJ,\"A!>\u0011\u00079\u001190C\u0002\u0003z\u0012\u0011\u0001C\u00159d\u000b:4h)\u001b7f'\u0016\u0014h/\u001a:\t\u000f\tu\b\u0001\"\u0011\u0003\u0000\u0006Yq\u000e]3o\u0007\"\fgN\\3m)\u0011\u0019\ta!\u0004\u0011\t\r\r1\u0011B\u0007\u0003\u0007\u000bQAaa\u0002\u0003\"\u0006A1\r[1o]\u0016d7/\u0003\u0003\u0004\f\r\u0015!a\u0005*fC\u0012\f'\r\\3CsR,7\t[1o]\u0016d\u0007b\u0002B\f\u0005w\u0004\rA\u000b\u0005\b\u0005{\u0004A\u0011IB\t)\u0019\u0019\taa\u0005\u0004\u0016!9!qCB\b\u0001\u0004Q\u0003\u0002CB\f\u0007\u001f\u0001\ra!\u0007\u0002\u001bI,\u0017\r\u001a+j[\u0016|W\u000f^'t!\ra31D\u0005\u0004\u0007;i#\u0001\u0002'p]\u001eDqa!\t\u0001\t\u0013\u0019\u0019#\u0001\be_^tGn\\1e\u00072LWM\u001c;\u0015\r\tE3QEB\u0014\u0011\u0019I3q\u0004a\u0001U!A\u0011\u0011ZB\u0010\u0001\u0004\tYM\u0002\u0004\u0004,\u0001!1Q\u0006\u0002\u0014\r&dW\rR8x]2|\u0017\rZ\"iC:tW\r\\\n\u0007\u0007S\u0019yc!\u0001\u0011\u0007M\u001b\t$C\u0002\u00044Q\u0013aa\u00142kK\u000e$\bbCB\u001c\u0007S\u0011\t\u0011)A\u0005\u0007\u0003\taa]8ve\u000e,\u0007b\u0002\u001e\u0004*\u0011\u000511\b\u000b\u0005\u0007{\u0019\t\u0005\u0005\u0003\u0004@\r%R\"\u0001\u0001\t\u0011\r]2\u0011\ba\u0001\u0007\u0003AAb!\u0012\u0004*\u0001\u0007\t\u0019!C\u0005\u0007\u000f\nQ!\u001a:s_J,\"a!\u0013\u0011\t\r-31\f\b\u0005\u0007\u001b\u001a9F\u0004\u0003\u0004P\rUSBAB)\u0015\r\u0019\u0019&G\u0001\u0007yI|w\u000e\u001e \n\u00039J1a!\u0017.\u0003\u001d\u0001\u0018mY6bO\u0016LAa!\u0018\u0004`\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u00073j\u0003\u0002DB2\u0007S\u0001\r\u00111A\u0005\n\r\u0015\u0014!C3se>\u0014x\fJ3r)\u0011\t9ca\u001a\t\u0015\u0005=2\u0011MA\u0001\u0002\u0004\u0019I\u0005C\u0005\u0004l\r%\u0002\u0015)\u0003\u0004J\u00051QM\u001d:pe\u0002BCa!\u001b\u00028!a1\u0011OB\u0015\u0001\u0004\u0005\r\u0011\"\u0003\u0004t\u0005IA/[7f_V$Xj]\u000b\u0003\u00073AAba\u001e\u0004*\u0001\u0007\t\u0019!C\u0005\u0007s\nQ\u0002^5nK>,H/T:`I\u0015\fH\u0003BA\u0014\u0007wB!\"a\f\u0004v\u0005\u0005\t\u0019AB\r\u0011%\u0019yh!\u000b!B\u0013\u0019I\"\u0001\u0006uS6,w.\u001e;Ng\u0002B\u0001ba!\u0004*\u0011\u00051QQ\u0001\tg\u0016$XI\u001d:peR!\u0011qEBD\u0011!\u0019Ii!!A\u0002\r%\u0013!A3\t\u0011\r55\u0011\u0006C\u0001\u0007\u001f\u000bAb]3u)&lWm\\;u\u001bN$B!a\n\u0004\u0012\"A11SBF\u0001\u0004\u0019I\"\u0001\u0004nS2d\u0017n\u001d\u0005\t\u0007/\u001bI\u0003\"\u0011\u0004\u001a\u0006!!/Z1e)\u0011\tYma'\t\u0011\ru5Q\u0013a\u0001\u0005;\u000b1\u0001Z:u\u0011!\u0019\tk!\u000b\u0005B\tE\u0017!B2m_N,\u0007\u0002CBS\u0007S!\tea*\u0002\r%\u001cx\n]3o)\t\u0019I\u000bE\u0002-\u0007WK1a!,.\u0005\u001d\u0011un\u001c7fC:4aa!-\u0001\t\rM&\u0001\u0006$jY\u0016$un\u001e8m_\u0006$7)\u00197mE\u0006\u001c7n\u0005\u0004\u00040\u000e=2Q\u0017\t\u0005\u0003\u0007\u00199,\u0003\u0003\u0004:\u0006\u0015!AD*ue\u0016\fWnQ1mY\n\f7m\u001b\u0005\f\u0007{\u001byK!A!\u0002\u0013\u0019y,\u0001\u0003tS:\\\u0007\u0003BB\u0002\u0007\u0003LAaa1\u0004\u0006\t\u0019rK]5uC\ndWMQ=uK\u000eC\u0017M\u001c8fY\"Y1qGBX\u0005\u0003\u0005\u000b\u0011BB\u001f\u0011-\t9aa,\u0003\u0002\u0003\u0006IA!\u0015\t\u000fi\u001ay\u000b\"\u0001\u0004LRA1QZBh\u0007#\u001c\u0019\u000e\u0005\u0003\u0004@\r=\u0006\u0002CB_\u0007\u0013\u0004\raa0\t\u0011\r]2\u0011\u001aa\u0001\u0007{A\u0001\"a\u0002\u0004J\u0002\u0007!\u0011\u000b\u0005\t\u0007/\u001cy\u000b\"\u0011\u0004Z\u00061qN\u001c#bi\u0006$b!a\n\u0004\\\u000e}\u0007bBBo\u0007+\u0004\rAK\u0001\tgR\u0014X-Y7JI\"A1\u0011]Bk\u0001\u0004\u0011i*A\u0002ck\u001aD\u0001b!:\u00040\u0012\u00053q]\u0001\u000b_:\u001cu.\u001c9mKR,G\u0003BA\u0014\u0007SDqa!8\u0004d\u0002\u0007!\u0006\u0003\u0005\u0004n\u000e=F\u0011IBx\u0003%ygNR1jYV\u0014X\r\u0006\u0004\u0002(\rE81\u001f\u0005\b\u0007;\u001cY\u000f1\u0001+\u0011!\u0019)pa;A\u0002\r%\u0013!B2bkN,w\u0001CB}\u0005!\u0005!aa?\u0002\u00179+G\u000f^=Sa\u000e,eN\u001e\t\u0004{\ruhaB\u0001\u0003\u0011\u0003\u00111q`\n\u0006\u0007{$\t!\u0005\t\u0004Y\u0011\r\u0011b\u0001C\u0003[\t1\u0011I\\=SK\u001aDqAOB\u007f\t\u0003!I\u0001\u0006\u0002\u0004|\"YAQBB\u007f\u0005\u0004%\tA\u0001C\b\u0003)\u0019WO\u001d:f]R,eN^\u000b\u0003\t#\u0001R\u0001b\u0005\u0005\u0018qj!\u0001\"\u0006\u000b\u0005!k\u0013\u0002\u0002C\r\t+\u0011q\u0002R=oC6L7MV1sS\u0006\u0014G.\u001a\u0005\n\t;\u0019i\u0010)A\u0005\t#\t1bY;se\u0016tG/\u00128wA!YA\u0011EB\u007f\u0005\u0004%\tA\u0001C\u0012\u00035\u0019WO\u001d:f]R\u001cE.[3oiV\u0011AQ\u0005\t\u0007\t'!9B!\u0015\t\u0013\u0011%2Q Q\u0001\n\u0011\u0015\u0012AD2veJ,g\u000e^\"mS\u0016tG\u000f\t")
public class NettyRpcEnv
extends RpcEnv
implements Logging {
    private final SparkConf conf;
    public final Serializer org$apache$spark$rpc$netty$NettyRpcEnv$$serializer;
    private final String host;
    private final SecurityManager securityManager;
    private final TransportConf transportConf;
    private final ThreadLocal<SerializerInstance> org$apache$spark$rpc$netty$NettyRpcEnv$$serializerInstance;
    private final Dispatcher dispatcher;
    private final NettyStreamManager streamManager;
    private final TransportContext transportContext;
    private final TransportClientFactory clientFactory;
    private volatile TransportClientFactory fileDownloadFactory;
    private final ScheduledExecutorService timeoutScheduler;
    private final ThreadPoolExecutor clientConnectionExecutor;
    private volatile TransportServer server;
    private final AtomicBoolean stopped;
    private final ConcurrentHashMap<RpcAddress, Outbox> outboxes;
    @Nullable
    private RpcAddress address;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    private RpcAddress address$lzycompute() {
        NettyRpcEnv nettyRpcEnv = this;
        synchronized (nettyRpcEnv) {
            if (!this.bitmap$0) {
                this.address = this.server() == null ? null : new RpcAddress(this.host, this.server().getPort());
                this.bitmap$0 = true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
            this.host = null;
            return this.address;
        }
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public SparkConf conf() {
        return this.conf;
    }

    public TransportConf transportConf() {
        return this.transportConf;
    }

    public ThreadLocal<SerializerInstance> org$apache$spark$rpc$netty$NettyRpcEnv$$serializerInstance() {
        return this.org$apache$spark$rpc$netty$NettyRpcEnv$$serializerInstance;
    }

    private Dispatcher dispatcher() {
        return this.dispatcher;
    }

    private NettyStreamManager streamManager() {
        return this.streamManager;
    }

    private TransportContext transportContext() {
        return this.transportContext;
    }

    private List<TransportClientBootstrap> createClientBootstraps() {
        return this.securityManager.isAuthenticationEnabled() ? Arrays.asList((Object[])new TransportClientBootstrap[]{new SaslClientBootstrap(this.transportConf(), "", (SecretKeyHolder)this.securityManager, this.securityManager.isSaslEncryptionEnabled())}) : Collections.emptyList();
    }

    private TransportClientFactory clientFactory() {
        return this.clientFactory;
    }

    private TransportClientFactory fileDownloadFactory() {
        return this.fileDownloadFactory;
    }

    private void fileDownloadFactory_$eq(TransportClientFactory x$1) {
        this.fileDownloadFactory = x$1;
    }

    public ScheduledExecutorService timeoutScheduler() {
        return this.timeoutScheduler;
    }

    public ThreadPoolExecutor clientConnectionExecutor() {
        return this.clientConnectionExecutor;
    }

    private TransportServer server() {
        return this.server;
    }

    private void server_$eq(TransportServer x$1) {
        this.server = x$1;
    }

    private AtomicBoolean stopped() {
        return this.stopped;
    }

    private ConcurrentHashMap<RpcAddress, Outbox> outboxes() {
        return this.outboxes;
    }

    public void removeOutbox(RpcAddress address) {
        Outbox outbox = this.outboxes().remove(address);
        if (outbox != null) {
            outbox.stop();
        }
    }

    public void startServer(String bindAddress, int port) {
        List bootstraps = this.securityManager.isAuthenticationEnabled() ? Arrays.asList((Object[])new TransportServerBootstrap[]{new SaslServerBootstrap(this.transportConf(), (SecretKeyHolder)this.securityManager)}) : Collections.emptyList();
        this.server_$eq(this.transportContext().createServer(bindAddress, port, bootstraps));
        this.dispatcher().registerRpcEndpoint(RpcEndpointVerifier$.MODULE$.NAME(), new RpcEndpointVerifier(this, this.dispatcher()));
    }

    @Override
    public RpcAddress address() {
        return this.bitmap$0 ? this.address : this.address$lzycompute();
    }

    @Override
    public RpcEndpointRef setupEndpoint(String name, RpcEndpoint endpoint) {
        return this.dispatcher().registerRpcEndpoint(name, endpoint);
    }

    @Override
    public Future<RpcEndpointRef> asyncSetupEndpointRefByURI(String uri) {
        RpcEndpointAddress addr = RpcEndpointAddress$.MODULE$.apply(uri);
        NettyRpcEndpointRef endpointRef = new NettyRpcEndpointRef(this.conf(), addr, this);
        NettyRpcEndpointRef verifier = new NettyRpcEndpointRef(this.conf(), new RpcEndpointAddress(addr.rpcAddress(), RpcEndpointVerifier$.MODULE$.NAME()), this);
        return verifier.ask(new RpcEndpointVerifier.CheckExistence(endpointRef.name()), ClassTag$.MODULE$.Boolean()).flatMap((Function1)new Serializable(this, uri, endpointRef){
            public static final long serialVersionUID = 0L;
            private final String uri$1;
            private final NettyRpcEndpointRef endpointRef$1;

            public final Future<NettyRpcEndpointRef> apply(boolean find) {
                return find ? Future$.MODULE$.successful((Object)this.endpointRef$1) : Future$.MODULE$.failed((Throwable)new RpcEndpointNotFoundException(this.uri$1));
            }
            {
                this.uri$1 = uri$1;
                this.endpointRef$1 = endpointRef$1;
            }
        }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    @Override
    public void stop(RpcEndpointRef endpointRef) {
        Predef$.MODULE$.require(endpointRef instanceof NettyRpcEndpointRef);
        this.dispatcher().stop(endpointRef);
    }

    private void postToOutbox(NettyRpcEndpointRef receiver, OutboxMessage message) {
        if (receiver.client() == null) {
            Outbox targetOutbox;
            Outbox outbox;
            Predef$.MODULE$.require(receiver.address() != null, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Cannot send message to client endpoint with no listen address.";
                }
            });
            Outbox outbox2 = this.outboxes().get(receiver.address());
            if (outbox2 == null) {
                Outbox newOutbox = new Outbox(this, receiver.address());
                Outbox oldOutbox = this.outboxes().putIfAbsent(receiver.address(), newOutbox);
                outbox = oldOutbox == null ? newOutbox : oldOutbox;
            } else {
                outbox = targetOutbox = outbox2;
            }
            if (this.stopped().get()) {
                this.outboxes().remove(receiver.address());
                targetOutbox.stop();
            } else {
                targetOutbox.send(message);
            }
        } else {
            message.sendWith(receiver.client());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(RequestMessage message) {
        RpcAddress remoteAddr;
        RpcAddress rpcAddress = remoteAddr = message.receiver().address();
        RpcAddress rpcAddress2 = this.address();
        if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
            try {
                this.dispatcher().postOneWayMessage(message);
                return;
            }
            catch (RpcEnvStoppedException rpcEnvStoppedException) {
                this.logWarning((Function0<String>)new Serializable(this, rpcEnvStoppedException){
                    public static final long serialVersionUID = 0L;
                    private final RpcEnvStoppedException e$1;

                    public final String apply() {
                        return this.e$1.getMessage();
                    }
                    {
                        this.e$1 = e$1;
                    }
                });
                return;
            }
        } else {
            this.postToOutbox(message.receiver(), new OneWayOutboxMessage(this.serialize(message)));
            return;
        }
    }

    public TransportClient createClient(RpcAddress address) {
        return this.clientFactory().createClient(address.host(), address.port());
    }

    public <T> Future<T> ask(RequestMessage message, RpcTimeout timeout, ClassTag<T> evidence$1) {
        Promise promise = Promise$.MODULE$.apply();
        RpcAddress remoteAddr = message.receiver().address();
        try {
            RpcAddress rpcAddress = remoteAddr;
            RpcAddress rpcAddress2 = this.address();
            if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
                Promise p = Promise$.MODULE$.apply();
                p.future().onComplete((Function1)new Serializable(this, promise){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ NettyRpcEnv $outer;
                    private final Promise promise$1;

                    public final void apply(Try<Object> x0$1) {
                        Try<Object> try_;
                        block4: {
                            block3: {
                                block2: {
                                    try_ = x0$1;
                                    if (!(try_ instanceof Success)) break block2;
                                    Success success = (Success)try_;
                                    Object response = success.value();
                                    this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$onSuccess$1(response, this.promise$1);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                if (!(try_ instanceof Failure)) break block4;
                                Failure failure = (Failure)try_;
                                Throwable e = failure.exception();
                                this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(e, this.promise$1);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            return;
                        }
                        throw new MatchError(try_);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.promise$1 = promise$1;
                    }
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
                this.dispatcher().postLocalMessage(message, (Promise<Object>)p);
            } else {
                RpcOutboxMessage rpcMessage = new RpcOutboxMessage(this.serialize(message), (Function1<Throwable, BoxedUnit>)new Serializable(this, promise){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ NettyRpcEnv $outer;
                    private final Promise promise$1;

                    public final void apply(Throwable e) {
                        this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(e, this.promise$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.promise$1 = promise$1;
                    }
                }, (Function2<TransportClient, ByteBuffer, BoxedUnit>)new Serializable(this, promise){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ NettyRpcEnv $outer;
                    private final Promise promise$1;

                    public final void apply(TransportClient client, ByteBuffer response) {
                        this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$onSuccess$1(this.$outer.deserialize(client, response, ClassTag$.MODULE$.Any()), this.promise$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.promise$1 = promise$1;
                    }
                });
                this.postToOutbox(message.receiver(), rpcMessage);
                promise.future().onFailure((PartialFunction)new Serializable(this, rpcMessage){
                    public static final long serialVersionUID = 0L;
                    private final RpcOutboxMessage rpcMessage$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        BoxedUnit boxedUnit;
                        A1 A1 = x1;
                        if (A1 instanceof TimeoutException) {
                            this.rpcMessage$1.onTimeout();
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return (B1)boxedUnit;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = throwable instanceof TimeoutException ? true : true;
                        return bl;
                    }
                    {
                        this.rpcMessage$1 = rpcMessage$1;
                    }
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            }
            ScheduledFuture<?> timeoutCancelable = this.timeoutScheduler().schedule(new Runnable(this, timeout, promise){
                private final /* synthetic */ NettyRpcEnv $outer;
                private final RpcTimeout timeout$1;
                private final Promise promise$1;

                public void run() {
                    this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(new TimeoutException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot receive any reply in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timeout$1.duration()}))), this.promise$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timeout$1 = timeout$1;
                    this.promise$1 = promise$1;
                }
            }, timeout.duration().toNanos(), TimeUnit.NANOSECONDS);
            promise.future().onComplete((Function1)new Serializable(this, timeoutCancelable){
                public static final long serialVersionUID = 0L;
                private final ScheduledFuture timeoutCancelable$1;

                public final boolean apply(Try<Object> v) {
                    return this.timeoutCancelable$1.cancel(true);
                }
                {
                    this.timeoutCancelable$1 = timeoutCancelable$1;
                }
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return promise.future().mapTo(evidence$1).recover(timeout.addMessageIfTimeout(), (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    public ByteBuffer serialize(Object content) {
        return this.org$apache$spark$rpc$netty$NettyRpcEnv$$serializerInstance().get().serialize(content, ClassTag$.MODULE$.Any());
    }

    public <T> T deserialize(TransportClient client, ByteBuffer bytes, ClassTag<T> evidence$2) {
        return (T)NettyRpcEnv$.MODULE$.currentClient().withValue((Object)client, (Function0)new Serializable(this, bytes, evidence$2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NettyRpcEnv $outer;
            public final ByteBuffer bytes$1;
            public final ClassTag evidence$2$1;

            public final T apply() {
                return this.$outer.deserialize(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deserialize$1 $outer;

                    public final T apply() {
                        return this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$anonfun$$$outer().org$apache$spark$rpc$netty$NettyRpcEnv$$serializerInstance().get().deserialize(this.$outer.bytes$1, this.$outer.evidence$2$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ NettyRpcEnv org$apache$spark$rpc$netty$NettyRpcEnv$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bytes$1 = bytes$1;
                this.evidence$2$1 = evidence$2$1;
            }
        });
    }

    @Override
    public RpcEndpointRef endpointRef(RpcEndpoint endpoint) {
        return this.dispatcher().getRpcEndpointRef(endpoint);
    }

    @Override
    public void shutdown() {
        this.cleanup();
    }

    @Override
    public void awaitTermination() {
        this.dispatcher().awaitTermination();
    }

    private void cleanup() {
        if (this.stopped().compareAndSet(false, true)) {
            for (Outbox outbox : this.outboxes().values()) {
                this.outboxes().remove(outbox.address());
                outbox.stop();
            }
            Object object = this.timeoutScheduler() == null ? BoxedUnit.UNIT : this.timeoutScheduler().shutdownNow();
            if (this.dispatcher() != null) {
                this.dispatcher().stop();
            }
            if (this.server() != null) {
                this.server().close();
            }
            if (this.clientFactory() != null) {
                this.clientFactory().close();
            }
            Object object2 = this.clientConnectionExecutor() == null ? BoxedUnit.UNIT : this.clientConnectionExecutor().shutdownNow();
            if (this.fileDownloadFactory() != null) {
                this.fileDownloadFactory().close();
            }
            return;
        }
    }

    @Override
    public <T> T deserialize(Function0<T> deserializationAction) {
        return (T)NettyRpcEnv$.MODULE$.currentEnv().withValue((Object)this, deserializationAction);
    }

    @Override
    public RpcEnvFileServer fileServer() {
        return this.streamManager();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ReadableByteChannel openChannel(String uri) {
        URI parsedUri = new URI(uri);
        Predef$.MODULE$.require(parsedUri.getHost() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Host name must be defined.";
            }
        });
        Predef$.MODULE$.require(parsedUri.getPort() > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Port must be defined.";
            }
        });
        Predef$.MODULE$.require(parsedUri.getPath() != null && new StringOps(Predef$.MODULE$.augmentString(parsedUri.getPath())).nonEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Path must be defined.";
            }
        });
        Pipe pipe2 = Pipe.open();
        FileDownloadChannel source = new FileDownloadChannel(this, pipe2.source());
        try {
            TransportClient client = this.downloadClient(parsedUri.getHost(), parsedUri.getPort());
            FileDownloadCallback callback = new FileDownloadCallback(this, pipe2.sink(), source, client);
            client.stream(parsedUri.getPath(), (StreamCallback)callback);
            return source;
        }
        catch (Exception exception2) {
            void var4_4;
            void var3_3;
            var3_3.sink().close();
            var4_4.close();
            throw exception2;
        }
    }

    @Override
    public ReadableByteChannel openChannel(String uri, long readTimeoutMs) {
        ReadableByteChannel source = this.openChannel(uri);
        if (readTimeoutMs > 0L) {
            ((FileDownloadChannel)source).setTimeoutMs(readTimeoutMs);
        }
        return source;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TransportClient downloadClient(String host, int port) {
        BoxedUnit boxedUnit;
        if (this.fileDownloadFactory() != null) {
            boxedUnit = BoxedUnit.UNIT;
            return this.fileDownloadFactory().createClient(host, port);
        }
        NettyRpcEnv nettyRpcEnv = this;
        synchronized (nettyRpcEnv) {
            BoxedUnit boxedUnit2;
            if (this.fileDownloadFactory() == null) {
                String module = "files";
                String prefix = "spark.rpc.io.";
                SparkConf clone2 = this.conf().clone();
                Predef$.MODULE$.refArrayOps((Object[])this.conf().getAll()).foreach((Function1)new Serializable(this, module, prefix, clone2){
                    public static final long serialVersionUID = 0L;
                    private final String module$1;
                    private final String prefix$1;
                    private final SparkConf clone$1;

                    public final Object apply(Tuple2<String, String> x0$2) {
                        Tuple2<String, String> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Object object;
                            String key = (String)tuple2._1();
                            String value2 = (String)tuple2._2();
                            if (key.startsWith(this.prefix$1)) {
                                String opt = key.substring(this.prefix$1.length());
                                object = this.clone$1.setIfMissing(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark.", ".io.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.module$1, opt})), value2);
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit = object;
                            return boxedUnit;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.module$1 = module$1;
                        this.prefix$1 = prefix$1;
                        this.clone$1 = clone$1;
                    }
                });
                int ioThreads = clone2.getInt("spark.files.io.threads", 1);
                TransportConf downloadConf = SparkTransportConf$.MODULE$.fromSparkConf(clone2, module, ioThreads);
                TransportContext downloadContext = new TransportContext(downloadConf, (RpcHandler)new NoOpRpcHandler(), true);
                this.fileDownloadFactory_$eq(downloadContext.createClientFactory(this.createClientBootstraps()));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit2;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl20 : MonitorExitStatement: MONITOREXIT : nettyRpcEnv
            boxedUnit = boxedUnit3;
            return this.fileDownloadFactory().createClient(host, port);
        }
    }

    public final void org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(Throwable e, Promise promise$1) {
        if (!promise$1.tryFailure(e)) {
            this.logWarning((Function0<String>)new Serializable(this, e){
                public static final long serialVersionUID = 0L;
                private final Throwable e$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignored failure: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$2}));
                }
                {
                    this.e$2 = e$2;
                }
            });
        }
    }

    public final void org$apache$spark$rpc$netty$NettyRpcEnv$$onSuccess$1(Object reply, Promise promise$1) {
        Object object = reply;
        if (object instanceof RpcFailure) {
            RpcFailure rpcFailure = (RpcFailure)object;
            Throwable e = rpcFailure.e();
            this.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (promise$1.trySuccess(object)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logWarning((Function0<String>)new Serializable(this, reply){
                    public static final long serialVersionUID = 0L;
                    private final Object reply$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignored message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.reply$1}));
                    }
                    {
                        this.reply$1 = reply$1;
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public NettyRpcEnv(SparkConf conf, Serializer serializer, String host, SecurityManager securityManager) {
        this.conf = conf;
        this.org$apache$spark$rpc$netty$NettyRpcEnv$$serializer = serializer;
        this.host = host;
        this.securityManager = securityManager;
        super(conf);
        Logging$class.$init$(this);
        this.transportConf = SparkTransportConf$.MODULE$.fromSparkConf(conf.clone().set("spark.rpc.io.numConnectionsPerPeer", "1"), "rpc", conf.getInt("spark.rpc.io.threads", 0));
        this.org$apache$spark$rpc$netty$NettyRpcEnv$$serializerInstance = new ThreadLocal<SerializerInstance>(this){
            private final /* synthetic */ NettyRpcEnv $outer;

            public SerializerInstance initialValue() {
                return this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$serializer.newInstance();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.dispatcher = new Dispatcher(this);
        this.streamManager = new NettyStreamManager(this);
        this.transportContext = new TransportContext(this.transportConf(), (RpcHandler)new NettyRpcHandler(this.dispatcher(), this, this.streamManager()));
        this.clientFactory = this.transportContext().createClientFactory(this.createClientBootstraps());
        this.timeoutScheduler = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("netty-rpc-env-timeout");
        this.clientConnectionExecutor = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("netty-rpc-connection", conf.getInt("spark.rpc.connect.threads", 64), ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3());
        this.stopped = new AtomicBoolean(false);
        this.outboxes = new ConcurrentHashMap();
    }

    public class FileDownloadChannel
    implements ReadableByteChannel {
        public final ReadableByteChannel org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$source;
        private volatile Throwable error;
        private long timeoutMs;
        public final /* synthetic */ NettyRpcEnv $outer;

        private Throwable error() {
            return this.error;
        }

        private void error_$eq(Throwable x$1) {
            this.error = x$1;
        }

        private long timeoutMs() {
            return this.timeoutMs;
        }

        private void timeoutMs_$eq(long x$1) {
            this.timeoutMs = x$1;
        }

        public void setError(Throwable e) {
            this.error_$eq(e);
            this.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$source.close();
        }

        public void setTimeoutMs(long millis) {
            this.timeoutMs_$eq(millis);
        }

        @Override
        public int read(ByteBuffer dst) {
            Try try_ = Try$.MODULE$.apply((Function0)new Serializable(this, dst){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileDownloadChannel $outer;
                private final ByteBuffer dst$1;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$readBuffer$1(this.dst$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.dst$1 = dst$1;
                }
            });
            if (try_ instanceof Success) {
                int bytesRead;
                Success success = (Success)try_;
                int n = bytesRead = BoxesRunTime.unboxToInt((Object)success.value());
                return n;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable readErr = failure.exception();
                if (this.error() == null) {
                    throw readErr;
                }
                throw this.error();
            }
            throw new MatchError((Object)try_);
        }

        @Override
        public void close() {
            this.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$source.close();
        }

        @Override
        public boolean isOpen() {
            return this.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$source.isOpen();
        }

        public /* synthetic */ NettyRpcEnv org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$$outer() {
            return this.$outer;
        }

        public final int org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$readBuffer$1(ByteBuffer dst$1) {
            int n;
            if (this.timeoutMs() > 0L) {
                ExecutionContextExecutorService context = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)this.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$$outer().clientConnectionExecutor());
                Future future = Future$.MODULE$.apply((Function0)new Serializable(this, dst$1){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileDownloadChannel $outer;
                    private final ByteBuffer dst$1;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$source.read(this.dst$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dst$1 = dst$1;
                    }
                }, (ExecutionContext)context);
                n = BoxesRunTime.unboxToInt(ThreadUtils$.MODULE$.awaitResult(future, (Duration)Duration$.MODULE$.apply(this.timeoutMs(), TimeUnit.MILLISECONDS)));
            } else {
                n = this.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$source.read(dst$1);
            }
            return n;
        }

        public FileDownloadChannel(NettyRpcEnv $outer, ReadableByteChannel source) {
            this.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$source = source;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class FileDownloadCallback
    implements StreamCallback {
        private final WritableByteChannel sink;
        private final FileDownloadChannel source;
        public final /* synthetic */ NettyRpcEnv $outer;

        public void onData(String streamId, ByteBuffer buf) {
            while (buf.remaining() > 0) {
                this.sink.write(buf);
            }
        }

        public void onComplete(String streamId) {
            this.sink.close();
        }

        public void onFailure(String streamId, Throwable cause) {
            this.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadCallback$$$outer().logDebug((Function0<String>)new Serializable(this, streamId){
                public static final long serialVersionUID = 0L;
                private final String streamId$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error downloading stream ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.streamId$1}));
                }
                {
                    this.streamId$1 = streamId$1;
                }
            }, cause);
            this.source.setError(cause);
            this.sink.close();
        }

        public /* synthetic */ NettyRpcEnv org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadCallback$$$outer() {
            return this.$outer;
        }

        public FileDownloadCallback(NettyRpcEnv $outer, WritableByteChannel sink, FileDownloadChannel source, TransportClient client) {
            this.sink = sink;
            this.source = source;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

