/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.netty;

import java.nio.ByteBuffer;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.network.BlockDataManager;
import org.apache.spark.network.BlockTransferService;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.netty.NettyBlockRpcServer;
import org.apache.spark.network.netty.NettyBlockTransferService$;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.sasl.SaslClientBootstrap;
import org.apache.spark.network.sasl.SaslServerBootstrap;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.server.TransportServerBootstrap;
import org.apache.spark.network.shuffle.BlockFetchingListener;
import org.apache.spark.network.shuffle.OneForOneBlockFetcher;
import org.apache.spark.network.shuffle.RetryingBlockFetcher;
import org.apache.spark.network.shuffle.protocol.UploadBlock;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dg!B\u0001\u0003\u0001\u0019a!!\u0007(fiRL(\t\\8dWR\u0013\u0018M\\:gKJ\u001cVM\u001d<jG\u0016T!a\u0001\u0003\u0002\u000b9,G\u000f^=\u000b\u0005\u00151\u0011a\u00028fi^|'o\u001b\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0011\u0001!\u0004\t\u0003\u001d=i\u0011\u0001B\u0005\u0003!\u0011\u0011AC\u00117pG.$&/\u00198tM\u0016\u00148+\u001a:wS\u000e,\u0007\u0002\u0003\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000b\u0002\t\r|gNZ\u0002\u0001!\t)b#D\u0001\u0007\u0013\t9bAA\u0005Ta\u0006\u00148nQ8oM\"A\u0011\u0004\u0001B\u0001B\u0003%!$A\btK\u000e,(/\u001b;z\u001b\u0006t\u0017mZ3s!\t)2$\u0003\u0002\u001d\r\ty1+Z2ve&$\u00180T1oC\u001e,'\u000f\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003 \u0003-\u0011\u0017N\u001c3BI\u0012\u0014Xm]:\u0011\u0005\u00012cBA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012\u0013A\u0002)sK\u0012,g-\u0003\u0002(Q\t11\u000b\u001e:j]\u001eT!!\n\u0012\t\u0011)\u0002!Q1A\u0005B-\n\u0001\u0002[8ti:\u000bW.Z\u000b\u0002?!AQ\u0006\u0001B\u0001B\u0003%q$A\u0005i_N$h*Y7fA!Aq\u0006\u0001B\u0001B\u0003%\u0001'A\u0003`a>\u0014H\u000f\u0005\u0002\"c%\u0011!G\t\u0002\u0004\u0013:$\b\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\u0002\u00119,XnQ8sKNDQA\u000e\u0001\u0005\u0002]\na\u0001P5oSRtDc\u0002\u001d;wqjdh\u0010\t\u0003s\u0001i\u0011A\u0001\u0005\u0006%U\u0002\r\u0001\u0006\u0005\u00063U\u0002\rA\u0007\u0005\u0006=U\u0002\ra\b\u0005\u0006UU\u0002\ra\b\u0005\u0006_U\u0002\r\u0001\r\u0005\u0006iU\u0002\r\u0001\r\u0005\b\u0003\u0002\u0011\r\u0011\"\u0003C\u0003)\u0019XM]5bY&TXM]\u000b\u0002\u0007B\u0011AIR\u0007\u0002\u000b*\u0011\u0011IB\u0005\u0003\u000f\u0016\u0013!bU3sS\u0006d\u0017N_3s\u0011\u0019I\u0005\u0001)A\u0005\u0007\u0006Y1/\u001a:jC2L'0\u001a:!\u0011\u001dY\u0005A1A\u0005\n1\u000b1\"Y;uQ\u0016s\u0017M\u00197fIV\tQ\n\u0005\u0002\"\u001d&\u0011qJ\t\u0002\b\u0005>|G.Z1o\u0011\u0019\t\u0006\u0001)A\u0005\u001b\u0006a\u0011-\u001e;i\u000b:\f'\r\\3eA!91\u000b\u0001b\u0001\n\u0013!\u0016!\u0004;sC:\u001c\bo\u001c:u\u0007>tg-F\u0001V!\t1\u0016,D\u0001X\u0015\tAF!\u0001\u0003vi&d\u0017B\u0001.X\u00055!&/\u00198ta>\u0014HoQ8oM\"1A\f\u0001Q\u0001\nU\u000ba\u0002\u001e:b]N\u0004xN\u001d;D_:4\u0007\u0005C\u0005_\u0001\u0001\u0007\t\u0011)Q\u0005?\u0006\u0001BO]1ogB|'\u000f^\"p]R,\u0007\u0010\u001e\t\u0003\u001d\u0001L!!\u0019\u0003\u0003!Q\u0013\u0018M\\:q_J$8i\u001c8uKb$\b\"C2\u0001\u0001\u0004\u0005\t\u0015)\u0003e\u0003\u0019\u0019XM\u001d<feB\u0011QmZ\u0007\u0002M*\u00111\rB\u0005\u0003Q\u001a\u0014q\u0002\u0016:b]N\u0004xN\u001d;TKJ4XM\u001d\u0005\nU\u0002\u0001\r\u0011!Q!\n-\fQb\u00197jK:$h)Y2u_JL\bC\u00017p\u001b\u0005i'B\u00018\u0005\u0003\u0019\u0019G.[3oi&\u0011\u0001/\u001c\u0002\u0017)J\fgn\u001d9peR\u001cE.[3oi\u001a\u000b7\r^8ss\"I!\u000f\u0001a\u0001\u0002\u0003\u0006KaH\u0001\u0006CB\u0004\u0018\n\u001a\u0005\u0006i\u0002!\t%^\u0001\u0005S:LG\u000f\u0006\u0002wsB\u0011\u0011e^\u0005\u0003q\n\u0012A!\u00168ji\")!p\u001da\u0001w\u0006\u0001\"\r\\8dW\u0012\u000bG/Y'b]\u0006<WM\u001d\t\u0003\u001dqL!! \u0003\u0003!\tcwnY6ECR\fW*\u00198bO\u0016\u0014\bBB@\u0001\t\u0013\t\t!\u0001\u0007de\u0016\fG/Z*feZ,'\u000fF\u0002e\u0003\u0007Aq!!\u0002\u007f\u0001\u0004\t9!\u0001\u0006c_>$8\u000f\u001e:baN\u0004b!!\u0003\u0002\u001a\u0005}a\u0002BA\u0006\u0003+qA!!\u0004\u0002\u00145\u0011\u0011q\u0002\u0006\u0004\u0003#\u0019\u0012A\u0002\u001fs_>$h(C\u0001$\u0013\r\t9BI\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY\"!\b\u0003\t1K7\u000f\u001e\u0006\u0004\u0003/\u0011\u0003cA3\u0002\"%\u0019\u00111\u00054\u00031Q\u0013\u0018M\\:q_J$8+\u001a:wKJ\u0014un\u001c;tiJ\f\u0007\u000fC\u0004\u0002(\u0001!\t%!\u000b\u0002\u0017\u0019,Go\u00195CY>\u001c7n\u001d\u000b\fm\u0006-\u0012qFA\u001a\u0003o\t\t\u0005C\u0004\u0002.\u0005\u0015\u0002\u0019A\u0010\u0002\t!|7\u000f\u001e\u0005\b\u0003c\t)\u00031\u00011\u0003\u0011\u0001xN\u001d;\t\u000f\u0005U\u0012Q\u0005a\u0001?\u00051Q\r_3d\u0013\u0012D\u0001\"!\u000f\u0002&\u0001\u0007\u00111H\u0001\tE2|7m[%egB!\u0011%!\u0010 \u0013\r\tyD\t\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\t\u0003\u0007\n)\u00031\u0001\u0002F\u0005AA.[:uK:,'\u000f\u0005\u0003\u0002H\u00055SBAA%\u0015\r\tY\u0005B\u0001\bg\",hM\u001a7f\u0013\u0011\ty%!\u0013\u0003+\tcwnY6GKR\u001c\u0007.\u001b8h\u0019&\u001cH/\u001a8fe\"9\u0011\u0011\u0007\u0001\u0005B\u0005MS#\u0001\u0019\t\u000f\u0005]\u0003\u0001\"\u0011\u0002Z\u0005YQ\u000f\u001d7pC\u0012\u0014En\\2l)A\tY&a\u001a\u0002l\u00055\u0014qNA@\u0003\u001f\u000bI\nE\u0003\u0002^\u0005\rd/\u0004\u0002\u0002`)\u0019\u0011\u0011\r\u0012\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002f\u0005}#A\u0002$viV\u0014X\rC\u0004\u0002j\u0005U\u0003\u0019A\u0010\u0002\u0011!|7\u000f\u001e8b[\u0016Dq!!\r\u0002V\u0001\u0007\u0001\u0007C\u0004\u00026\u0005U\u0003\u0019A\u0010\t\u0011\u0005E\u0014Q\u000ba\u0001\u0003g\nqA\u00197pG.LE\r\u0005\u0003\u0002v\u0005mTBAA<\u0015\r\tIHB\u0001\bgR|'/Y4f\u0013\u0011\ti(a\u001e\u0003\u000f\tcwnY6JI\"A\u0011\u0011QA+\u0001\u0004\t\u0019)A\u0005cY>\u001c7\u000eR1uCB!\u0011QQAF\u001b\t\t9IC\u0002\u0002\n\u0012\taAY;gM\u0016\u0014\u0018\u0002BAG\u0003\u000f\u0013Q\"T1oC\u001e,GMQ;gM\u0016\u0014\b\u0002CAI\u0003+\u0002\r!a%\u0002\u000b1,g/\u001a7\u0011\t\u0005U\u0014QS\u0005\u0005\u0003/\u000b9H\u0001\u0007Ti>\u0014\u0018mZ3MKZ,G\u000e\u0003\u0005\u0002\u001c\u0006U\u0003\u0019AAO\u0003!\u0019G.Y:t)\u0006<\u0007\u0007BAP\u0003_\u0003b!!)\u0002(\u0006-VBAAR\u0015\r\t)KI\u0001\be\u00164G.Z2u\u0013\u0011\tI+a)\u0003\u0011\rc\u0017m]:UC\u001e\u0004B!!,\u000202\u0001A\u0001DAY\u00033\u000b\t\u0011!A\u0003\u0002\u0005M&aA0%cE!\u0011QWA^!\r\t\u0013qW\u0005\u0004\u0003s\u0013#a\u0002(pi\"Lgn\u001a\t\u0004C\u0005u\u0016bAA`E\t\u0019\u0011I\\=\t\u000f\u0005\r\u0007\u0001\"\u0011\u0002F\u0006)1\r\\8tKR\ta\u000f")
public class NettyBlockTransferService
extends BlockTransferService {
    private final SparkConf conf;
    private final SecurityManager securityManager;
    private final String bindAddress;
    private final String hostName;
    private final int _port;
    private final Serializer serializer;
    private final boolean authEnabled;
    private final TransportConf transportConf;
    private TransportContext transportContext;
    public TransportServer org$apache$spark$network$netty$NettyBlockTransferService$$server;
    public TransportClientFactory org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory;
    public String org$apache$spark$network$netty$NettyBlockTransferService$$appId;

    @Override
    public String hostName() {
        return this.hostName;
    }

    private Serializer serializer() {
        return this.serializer;
    }

    private boolean authEnabled() {
        return this.authEnabled;
    }

    private TransportConf transportConf() {
        return this.transportConf;
    }

    @Override
    public void init(BlockDataManager blockDataManager) {
        NettyBlockRpcServer rpcHandler = new NettyBlockRpcServer(this.conf.getAppId(), this.serializer(), blockDataManager);
        None$ serverBootstrap = None$.MODULE$;
        None$ clientBootstrap = None$.MODULE$;
        if (this.authEnabled()) {
            serverBootstrap = new Some((Object)new SaslServerBootstrap(this.transportConf(), (SecretKeyHolder)this.securityManager));
            clientBootstrap = new Some((Object)new SaslClientBootstrap(this.transportConf(), this.conf.getAppId(), (SecretKeyHolder)this.securityManager, this.securityManager.isSaslEncryptionEnabled()));
        }
        this.transportContext = new TransportContext(this.transportConf(), (RpcHandler)rpcHandler);
        this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory = this.transportContext.createClientFactory((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(Option$.MODULE$.option2Iterable((Option)clientBootstrap).toSeq()).asJava());
        this.org$apache$spark$network$netty$NettyBlockTransferService$$server = this.createServer((List<TransportServerBootstrap>)serverBootstrap.toList());
        this.org$apache$spark$network$netty$NettyBlockTransferService$$appId = this.conf.getAppId();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NettyBlockTransferService $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Server created on ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.hostName(), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$server.getPort())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private TransportServer createServer(List<TransportServerBootstrap> bootstraps) {
        return (TransportServer)Utils$.MODULE$.startServiceOnPort(this._port, new Serializable(this, bootstraps){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NettyBlockTransferService $outer;
            private final List bootstraps$1;

            public final Tuple2<TransportServer, Object> apply(int port) {
                return this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$startService$1(port, this.bootstraps$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bootstraps$1 = bootstraps$1;
            }
        }, this.conf, this.getClass().getName())._1();
    }

    @Override
    public void fetchBlocks(String host, int port, String execId, String[] blockIds, BlockFetchingListener listener) {
        this.logTrace((Function0<String>)new Serializable(this, host, port, execId){
            public static final long serialVersionUID = 0L;
            private final String host$1;
            private final int port$1;
            private final String execId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fetch blocks from ", ":", " (executor id ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host$1, BoxesRunTime.boxToInteger((int)this.port$1), this.execId$1}));
            }
            {
                this.host$1 = host$1;
                this.port$1 = port$1;
                this.execId$1 = execId$1;
            }
        });
        try {
            RetryingBlockFetcher.BlockFetchStarter blockFetchStarter = new RetryingBlockFetcher.BlockFetchStarter(this, host, port, execId){
                private final /* synthetic */ NettyBlockTransferService $outer;
                private final String host$1;
                private final int port$1;
                private final String execId$1;

                public void createAndStart(String[] blockIds, BlockFetchingListener listener) {
                    TransportClient client = this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory.createClient(this.host$1, this.port$1);
                    new OneForOneBlockFetcher(client, this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$appId, this.execId$1, (String[])Predef$.MODULE$.refArrayOps((Object[])blockIds).toArray(ClassTag$.MODULE$.apply(String.class)), listener).start();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.host$1 = host$1;
                    this.port$1 = port$1;
                    this.execId$1 = execId$1;
                }
            };
            int maxRetries = this.transportConf().maxIORetries();
            if (maxRetries > 0) {
                new RetryingBlockFetcher(this.transportConf(), blockFetchStarter, blockIds, listener).start();
            } else {
                blockFetchStarter.createAndStart(blockIds, listener);
            }
        }
        catch (Exception exception2) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Exception while beginning fetchBlocks";
                }
            }, exception2);
            Predef$.MODULE$.refArrayOps((Object[])blockIds).foreach((Function1)new Serializable(this, listener, exception2){
                public static final long serialVersionUID = 0L;
                private final BlockFetchingListener listener$1;
                private final Exception e$1;

                public final void apply(String x$1) {
                    this.listener$1.onBlockFetchFailure(x$1, (Throwable)this.e$1);
                }
                {
                    this.listener$1 = listener$1;
                    this.e$1 = e$1;
                }
            });
        }
    }

    @Override
    public int port() {
        return this.org$apache$spark$network$netty$NettyBlockTransferService$$server.getPort();
    }

    @Override
    public Future<BoxedUnit> uploadBlock(String hostname, int port, String execId, BlockId blockId, ManagedBuffer blockData, StorageLevel level, ClassTag<?> classTag) {
        Promise result2 = Promise$.MODULE$.apply();
        TransportClient client = this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory.createClient(hostname, port);
        byte[] metadata = JavaUtils.bufferToArray((ByteBuffer)this.serializer().newInstance().serialize(new Tuple2((Object)level, classTag), ClassTag$.MODULE$.apply(Tuple2.class)));
        byte[] array = JavaUtils.bufferToArray((ByteBuffer)blockData.nioByteBuffer());
        client.sendRpc(new UploadBlock(this.org$apache$spark$network$netty$NettyBlockTransferService$$appId, execId, blockId.toString(), metadata, array).toByteBuffer(), new RpcResponseCallback(this, blockId, result2){
            private final /* synthetic */ NettyBlockTransferService $outer;
            public final BlockId blockId$1;
            private final Promise result$1;

            public void onSuccess(ByteBuffer response) {
                this.$outer.logTrace((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$2 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully uploaded block ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.blockId$1}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.result$1.success((Object)BoxedUnit.UNIT);
            }

            public void onFailure(Throwable e) {
                this.$outer.logError((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$2 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while uploading block ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.blockId$1}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, e);
                this.result$1.failure(e);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.blockId$1 = blockId$1;
                this.result$1 = result$1;
            }
        });
        return result2.future();
    }

    @Override
    public void close() {
        if (this.org$apache$spark$network$netty$NettyBlockTransferService$$server != null) {
            this.org$apache$spark$network$netty$NettyBlockTransferService$$server.close();
        }
        if (this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory != null) {
            this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory.close();
        }
    }

    public final Tuple2 org$apache$spark$network$netty$NettyBlockTransferService$$startService$1(int port, List bootstraps$1) {
        TransportServer server = this.transportContext.createServer(this.bindAddress, port, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bootstraps$1).asJava());
        return new Tuple2((Object)server, (Object)BoxesRunTime.boxToInteger((int)server.getPort()));
    }

    public NettyBlockTransferService(SparkConf conf, SecurityManager securityManager, String bindAddress, String hostName, int _port, int numCores) {
        this.conf = conf;
        this.securityManager = securityManager;
        this.bindAddress = bindAddress;
        this.hostName = hostName;
        this._port = _port;
        this.serializer = SparkEnv$.MODULE$.getClosureSerializer(conf, SparkEnv$.MODULE$.getClosureSerializer$default$2());
        this.authEnabled = securityManager.isAuthenticationEnabled();
        this.transportConf = SparkTransportConf$.MODULE$.fromSparkConf(conf, "shuffle", numCores);
    }
}

