/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.io;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.spark.SparkConf;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.SnappyCompressionCodec$;
import org.apache.spark.io.SnappyOutputStreamWrapper;
import org.xerial.snappy.Snappy;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;
import scala.reflect.ScalaSignature;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001%4A!\u0001\u0002\u0001\u0017\t12K\\1qaf\u001cu.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7M\u0003\u0002\u0004\t\u0005\u0011\u0011n\u001c\u0006\u0003\u000b\u0019\tQa\u001d9be.T!a\u0002\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0011aA8sO\u000e\u00011c\u0001\u0001\r%A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003!\r{W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0007\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\t\r|gN\u001a\t\u00033ii\u0011\u0001B\u0005\u00037\u0011\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\ty\u0002\u0005\u0005\u0002\u0014\u0001!)q\u0003\ba\u00011!9!\u0005\u0001b\u0001\n\u0003\u0019\u0013a\u0002<feNLwN\\\u000b\u0002IA\u0011Q\u0005\u000b\b\u0003\u001b\u0019J!a\n\b\u0002\rA\u0013X\rZ3g\u0013\tI#F\u0001\u0004TiJLgn\u001a\u0006\u0003O9Aa\u0001\f\u0001!\u0002\u0013!\u0013\u0001\u0003<feNLwN\u001c\u0011\t\u000b9\u0002A\u0011I\u0018\u0002-\r|W\u000e\u001d:fgN,GmT;uaV$8\u000b\u001e:fC6$\"\u0001M\u001c\u0011\u0005E*T\"\u0001\u001a\u000b\u0005\r\u0019$\"\u0001\u001b\u0002\t)\fg/Y\u0005\u0003mI\u0012AbT;uaV$8\u000b\u001e:fC6DQ\u0001O\u0017A\u0002A\n\u0011a\u001d\u0005\u0006u\u0001!\teO\u0001\u0016G>l\u0007O]3tg\u0016$\u0017J\u001c9viN#(/Z1n)\tat\b\u0005\u00022{%\u0011aH\r\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u00039s\u0001\u0007A\bC\u0003B\u0001\u0011\u0005#)\u0001\u0005d_6\u0004(/Z:t)\r\u0019\u0015j\u0013\t\u0004\u001b\u00113\u0015BA#\u000f\u0005\u0015\t%O]1z!\tiq)\u0003\u0002I\u001d\t!!)\u001f;f\u0011\u0015Q\u0005\t1\u0001D\u0003\u0015Ig\u000e];u\u0011\u0015a\u0005\t1\u0001N\u0003!Ig\u000e];u\u0019\u0016t\u0007CA\u0007O\u0013\tyeBA\u0002J]RDQ!\u0015\u0001\u0005BI\u000b!\u0002Z3d_6\u0004(/Z:t)\u0015\u00195\u000b\u0016,X\u0011\u0015Q\u0005\u000b1\u0001D\u0011\u0015)\u0006\u000b1\u0001N\u0003-Ig\u000e];u\u001f\u001a47/\u001a;\t\u000b1\u0003\u0006\u0019A'\t\u000ba\u0003\u0006\u0019A'\u0002\u0013=,H\u000f];u\u0019\u0016t\u0007F\u0001\u0001[!\tYf,D\u0001]\u0015\tiF!\u0001\u0006b]:|G/\u0019;j_:L!a\u0018/\u0003\u0019\u0011+g/\u001a7pa\u0016\u0014\u0018\t]5\b\u000b\u0005\u0014\u0001R\u00022\u0002-Ms\u0017\r\u001d9z\u0007>l\u0007O]3tg&|gnQ8eK\u000e\u0004\"aE2\u0007\u000b\u0005\u0011\u0001R\u00023\u0014\u0005\rd\u0001\"B\u000fd\t\u00031G#\u00012\t\u0011\t\u001a\u0007R1A\u0005\n\rB\u0001\u0002L2\t\u0002\u0003\u0006K\u0001\n")
public class SnappyCompressionCodec
implements CompressionCodec {
    private final SparkConf conf;
    private final String version;

    public String version() {
        return this.version;
    }

    @Override
    public OutputStream compressedOutputStream(OutputStream s) {
        int blockSize = (int)this.conf.getSizeAsBytes("spark.io.compression.snappy.blockSize", "32k");
        return new SnappyOutputStreamWrapper(new SnappyOutputStream(s, blockSize));
    }

    @Override
    public InputStream compressedInputStream(InputStream s) {
        return new SnappyInputStream(s);
    }

    @Override
    public byte[] compress(byte[] input, int inputLen) {
        return Snappy.rawCompress((Object)input, (int)inputLen);
    }

    @Override
    public byte[] decompress(byte[] input, int inputOffset, int inputLen, int outputLen) {
        byte[] output = new byte[outputLen];
        Snappy.uncompress((byte[])input, (int)inputOffset, (int)inputLen, (byte[])output, (int)0);
        return output;
    }

    public SnappyCompressionCodec(SparkConf conf) {
        this.conf = conf;
        this.version = SnappyCompressionCodec$.MODULE$.org$apache$spark$io$SnappyCompressionCodec$$version();
    }
}

