/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.io;

import com.google.common.primitives.UnsignedBytes;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.spark.util.io.ChunkedByteBuffer;
import scala.Predef$;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0005\u001b\ta2\t[;oW\u0016$')\u001f;f\u0005V4g-\u001a:J]B,Ho\u0015;sK\u0006l'BA\u0002\u0005\u0003\tIwN\u0003\u0002\u0006\r\u0005!Q\u000f^5m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"aD\n\u000e\u0003AQ!aA\t\u000b\u0003I\tAA[1wC&\u0011A\u0003\u0005\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u0005\u0017\u0001\t\u0005\r\u0011\"\u0001\u0018\u0003E\u0019\u0007.\u001e8lK\u0012\u0014\u0015\u0010^3Ck\u001a4WM]\u000b\u00021A\u0011\u0011DG\u0007\u0002\u0005%\u00111D\u0001\u0002\u0012\u0007\",hn[3e\u0005f$XMQ;gM\u0016\u0014\b\u0002C\u000f\u0001\u0005\u0003\u0007I\u0011\u0001\u0010\u0002+\rDWO\\6fI\nKH/\u001a\"vM\u001a,'o\u0018\u0013fcR\u0011q$\n\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0005+:LG\u000fC\u0004'9\u0005\u0005\t\u0019\u0001\r\u0002\u0007a$\u0013\u0007\u0003\u0005)\u0001\t\u0005\t\u0015)\u0003\u0019\u0003I\u0019\u0007.\u001e8lK\u0012\u0014\u0015\u0010^3Ck\u001a4WM\u001d\u0011\t\u0011)\u0002!\u0011!Q\u0001\n-\nq\u0001Z5ta>\u001cX\r\u0005\u0002!Y%\u0011Q&\t\u0002\b\u0005>|G.Z1o\u0011\u0015y\u0003\u0001\"\u00011\u0003\u0019a\u0014N\\5u}Q\u0019\u0011GM\u001a\u0011\u0005e\u0001\u0001\"\u0002\f/\u0001\u0004A\u0002\"\u0002\u0016/\u0001\u0004Y\u0003BB\u001b\u0001A\u0003&a'\u0001\u0004dQVt7n\u001d\t\u0004oibT\"\u0001\u001d\u000b\u0005e\n\u0013AC2pY2,7\r^5p]&\u00111\b\u000f\u0002\t\u0013R,'/\u0019;peB\u0011Q\bQ\u0007\u0002})\u0011q(E\u0001\u0004]&|\u0017BA!?\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0007\u0007\u0002\u0001\u000b\u0015\u0002\u001f\u0002\u0019\r,(O]3oi\u000eCWO\\6\t\u000b\u0015\u0003A\u0011\t$\u0002\tI,\u0017\r\u001a\u000b\u0002\u000fB\u0011\u0001\u0005S\u0005\u0003\u0013\u0006\u00121!\u00138u\u0011\u0015)\u0005\u0001\"\u0011L)\u00119E\n\u0016,\t\u000b5S\u0005\u0019\u0001(\u0002\t\u0011,7\u000f\u001e\t\u0004A=\u000b\u0016B\u0001)\"\u0005\u0015\t%O]1z!\t\u0001#+\u0003\u0002TC\t!!)\u001f;f\u0011\u0015)&\n1\u0001H\u0003\u0019ygMZ:fi\")qK\u0013a\u0001\u000f\u00061A.\u001a8hi\"DQ!\u0017\u0001\u0005Bi\u000bAa]6jaR\u00111L\u0018\t\u0003AqK!!X\u0011\u0003\t1{gn\u001a\u0005\u0006?b\u0003\raW\u0001\u0006Ef$Xm\u001d\u0005\u0006C\u0002!\tEY\u0001\u0006G2|7/\u001a\u000b\u0002?\u0001")
public class ChunkedByteBufferInputStream
extends InputStream {
    private ChunkedByteBuffer chunkedByteBuffer;
    private final boolean dispose;
    private Iterator<ByteBuffer> chunks;
    private ByteBuffer currentChunk;

    public ChunkedByteBuffer chunkedByteBuffer() {
        return this.chunkedByteBuffer;
    }

    public void chunkedByteBuffer_$eq(ChunkedByteBuffer x$1) {
        this.chunkedByteBuffer = x$1;
    }

    @Override
    public int read() {
        int n;
        if (this.currentChunk != null && !this.currentChunk.hasRemaining() && this.chunks.hasNext()) {
            this.currentChunk = (ByteBuffer)this.chunks.next();
        }
        if (this.currentChunk != null && this.currentChunk.hasRemaining()) {
            n = UnsignedBytes.toInt((byte)this.currentChunk.get());
        } else {
            this.close();
            n = -1;
        }
        return n;
    }

    @Override
    public int read(byte[] dest, int offset, int length) {
        int n;
        if (this.currentChunk != null && !this.currentChunk.hasRemaining() && this.chunks.hasNext()) {
            this.currentChunk = (ByteBuffer)this.chunks.next();
        }
        if (this.currentChunk != null && this.currentChunk.hasRemaining()) {
            int amountToGet = package$.MODULE$.min(this.currentChunk.remaining(), length);
            this.currentChunk.get(dest, offset, amountToGet);
            n = amountToGet;
        } else {
            this.close();
            n = -1;
        }
        return n;
    }

    @Override
    public long skip(long bytes) {
        long l;
        if (this.currentChunk == null) {
            l = 0L;
        } else {
            int amountToSkip = (int)package$.MODULE$.min(bytes, (long)this.currentChunk.remaining());
            this.currentChunk.position(this.currentChunk.position() + amountToSkip);
            if (this.currentChunk.remaining() == 0) {
                if (this.chunks.hasNext()) {
                    this.currentChunk = (ByteBuffer)this.chunks.next();
                } else {
                    this.close();
                }
            }
            l = amountToSkip;
        }
        return l;
    }

    @Override
    public void close() {
        if (this.chunkedByteBuffer() != null && this.dispose) {
            this.chunkedByteBuffer().dispose();
        }
        this.chunkedByteBuffer_$eq(null);
        this.chunks = null;
        this.currentChunk = null;
    }

    public ChunkedByteBufferInputStream(ChunkedByteBuffer chunkedByteBuffer, boolean dispose2) {
        this.chunkedByteBuffer = chunkedByteBuffer;
        this.dispose = dispose2;
        this.chunks = Predef$.MODULE$.refArrayOps((Object[])this.chunkedByteBuffer().getChunks()).iterator();
        this.currentChunk = this.chunks.hasNext() ? (ByteBuffer)this.chunks.next() : null;
    }
}

