/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.nio.ByteBuffer;
import java.util.Properties;
import org.apache.spark.InternalAccumulator$;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.TaskContextImpl;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.metrics.MetricsSystem;
import org.apache.spark.scheduler.Task$;
import org.apache.spark.scheduler.TaskData;
import org.apache.spark.scheduler.TaskData$;
import org.apache.spark.scheduler.TaskLocation;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.storage.memory.MemoryStore;
import org.apache.spark.util.AccumulatorV2;
import org.apache.spark.util.CallerContext;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0011EaAB\u0001\u0003\u0003\u0003!!B\u0001\u0003UCN\\'BA\u0002\u0005\u0003%\u00198\r[3ek2,'O\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\u0007CB\f7\r[3\u000b\u0003%\t1a\u001c:h+\rY\u0011qJ\n\u0004\u00011\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u000e'%\u0011AC\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t-\u0001\u0011\t\u0019!C\u00051\u0005Aql\u001d;bO\u0016LEm\u0001\u0001\u0016\u0003e\u0001\"!\u0004\u000e\n\u0005mq!aA%oi\"AQ\u0004\u0001BA\u0002\u0013%a$\u0001\u0007`gR\fw-Z%e?\u0012*\u0017\u000f\u0006\u0002 EA\u0011Q\u0002I\u0005\u0003C9\u0011A!\u00168ji\"91\u0005HA\u0001\u0002\u0004I\u0012a\u0001=%c!AQ\u0005\u0001B\u0001B\u0003&\u0011$A\u0005`gR\fw-Z%eA!Aq\u0005\u0001BA\u0002\u0013%\u0001$A\b`gR\fw-Z!ui\u0016l\u0007\u000f^%e\u0011!I\u0003A!a\u0001\n\u0013Q\u0013aE0ti\u0006<W-\u0011;uK6\u0004H/\u00133`I\u0015\fHCA\u0010,\u0011\u001d\u0019\u0003&!AA\u0002eA\u0001\"\f\u0001\u0003\u0002\u0003\u0006K!G\u0001\u0011?N$\u0018mZ3BiR,W\u000e\u001d;JI\u0002B\u0001b\f\u0001\u0003\u0002\u0004%I\u0001G\u0001\r?B\f'\u000f^5uS>t\u0017\n\u001a\u0005\tc\u0001\u0011\t\u0019!C\u0005e\u0005\u0001r\f]1si&$\u0018n\u001c8JI~#S-\u001d\u000b\u0003?MBqa\t\u0019\u0002\u0002\u0003\u0007\u0011\u0004\u0003\u00056\u0001\t\u0005\t\u0015)\u0003\u001a\u00035y\u0006/\u0019:uSRLwN\\%eA!Iq\u0007\u0001BA\u0002\u0013\u0005A\u0001O\u0001\ti\u0006\u001c8\u000eR1uCV\t\u0011\b\u0005\u0002;w5\t!!\u0003\u0002=\u0005\tAA+Y:l\t\u0006$\u0018\rC\u0005?\u0001\t\u0005\r\u0011\"\u0001\u0005\u007f\u0005aA/Y:l\t\u0006$\u0018m\u0018\u0013fcR\u0011q\u0004\u0011\u0005\bGu\n\t\u00111\u0001:\u0011!\u0011\u0005A!A!B\u0013I\u0014!\u0003;bg.$\u0015\r^1!Q\t\tE\t\u0005\u0002\u000e\u000b&\u0011aI\u0004\u0002\niJ\fgn]5f]RD\u0001\u0002\u0013\u0001\u0003\u0002\u0004%\t\"S\u0001\u000bi\u0006\u001c8NQ5oCJLX#\u0001&\u0011\u00075YU*\u0003\u0002M\u001d\t1q\n\u001d;j_:\u00042AT)T\u001b\u0005y%B\u0001)\u0005\u0003%\u0011'o\\1eG\u0006\u001cH/\u0003\u0002S\u001f\nI!I]8bI\u000e\f7\u000f\u001e\t\u0004\u001bQ3\u0016BA+\u000f\u0005\u0015\t%O]1z!\tiq+\u0003\u0002Y\u001d\t!!)\u001f;f\u0011!Q\u0006A!a\u0001\n#Y\u0016A\u0004;bg.\u0014\u0015N\\1ss~#S-\u001d\u000b\u0003?qCqaI-\u0002\u0002\u0003\u0007!\n\u0003\u0005_\u0001\t\u0005\t\u0015)\u0003K\u0003-!\u0018m]6CS:\f'/\u001f\u0011\t\u0011\u0001\u0004!\u00111A\u0005\n\u0005\f\u0001bX7fiJL7m]\u000b\u0002EB\u00111MZ\u0007\u0002I*\u0011Q\rB\u0001\tKb,7-\u001e;pe&\u0011q\r\u001a\u0002\f)\u0006\u001c8.T3ue&\u001c7\u000f\u0003\u0005j\u0001\t\u0005\r\u0011\"\u0003k\u00031yV.\u001a;sS\u000e\u001cx\fJ3r)\ty2\u000eC\u0004$Q\u0006\u0005\t\u0019\u00012\t\u00115\u0004!\u0011!Q!\n\t\f\u0011bX7fiJL7m\u001d\u0011\t\u0011=\u0004!\u00111A\u0005\u0002A\fq\u0002\\8dC2\u0004&o\u001c9feRLWm]\u000b\u0002cB\u0011!o^\u0007\u0002g*\u0011A/^\u0001\u0005kRLGNC\u0001w\u0003\u0011Q\u0017M^1\n\u0005a\u001c(A\u0003)s_B,'\u000f^5fg\"A!\u0010\u0001BA\u0002\u0013\u000510A\nm_\u000e\fG\u000e\u0015:pa\u0016\u0014H/[3t?\u0012*\u0017\u000f\u0006\u0002 y\"91%_A\u0001\u0002\u0004\t\b\u0002\u0003@\u0001\u0005\u0003\u0005\u000b\u0015B9\u0002!1|7-\u00197Qe>\u0004XM\u001d;jKN\u0004\u0003FA?E\u0011%\t\u0019\u0001\u0001BA\u0002\u0013%\u0001$\u0001\u0004`U>\u0014\u0017\n\u001a\u0005\u000b\u0003\u000f\u0001!\u00111A\u0005\n\u0005%\u0011AC0k_\nLEm\u0018\u0013fcR\u0019q$a\u0003\t\u0011\r\n)!!AA\u0002eA\u0011\"a\u0004\u0001\u0005\u0003\u0005\u000b\u0015B\r\u0002\u000f}SwNY%eA!Q\u00111\u0003\u0001\u0003\u0002\u0004%I!!\u0006\u0002\r}\u000b\u0007\u000f]%e+\t\t9\u0002\u0005\u0003\u000e\u0017\u0006e\u0001\u0003BA\u000e\u0003Cq1!DA\u000f\u0013\r\tyBD\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0012Q\u0005\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005}a\u0002\u0003\u0006\u0002*\u0001\u0011\t\u0019!C\u0005\u0003W\t!bX1qa&#w\fJ3r)\ry\u0012Q\u0006\u0005\nG\u0005\u001d\u0012\u0011!a\u0001\u0003/A!\"!\r\u0001\u0005\u0003\u0005\u000b\u0015BA\f\u0003\u001dy\u0016\r\u001d9JI\u0002B!\"!\u000e\u0001\u0005\u0003\u0007I\u0011BA\u000b\u00035y\u0016\r\u001d9BiR,W\u000e\u001d;JI\"Q\u0011\u0011\b\u0001\u0003\u0002\u0004%I!a\u000f\u0002#}\u000b\u0007\u000f]!ui\u0016l\u0007\u000f^%e?\u0012*\u0017\u000fF\u0002 \u0003{A\u0011bIA\u001c\u0003\u0003\u0005\r!a\u0006\t\u0015\u0005\u0005\u0003A!A!B\u0013\t9\"\u0001\b`CB\u0004\u0018\t\u001e;f[B$\u0018\n\u001a\u0011\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H\u00051A(\u001b8jiz\"b#!\u0013\u0002b\u0005\r\u0014QMA4\u0003S\nY'!\u001c\u0002p\u0005E\u00141\u000f\t\u0005u\u0001\tY\u0005\u0005\u0003\u0002N\u0005=C\u0002\u0001\u0003\b\u0003#\u0002!\u0019AA*\u0005\u0005!\u0016\u0003BA+\u00037\u00022!DA,\u0013\r\tIF\u0004\u0002\b\u001d>$\b.\u001b8h!\ri\u0011QL\u0005\u0004\u0003?r!aA!os\"1a#a\u0011A\u0002eAaaJA\"\u0001\u0004I\u0002BB\u0018\u0002D\u0001\u0007\u0011\u0004\u0003\u00058\u0003\u0007\u0002\n\u00111\u0001:\u0011!A\u00151\tI\u0001\u0002\u0004Q\u0005\u0002\u00031\u0002DA\u0005\t\u0019\u00012\t\u0011=\f\u0019\u0005%AA\u0002ED\u0011\"a\u0001\u0002DA\u0005\t\u0019A\r\t\u0015\u0005M\u00111\tI\u0001\u0002\u0004\t9\u0002\u0003\u0006\u00026\u0005\r\u0003\u0013!a\u0001\u0003/Aa!a\u001e\u0001\t\u000bA\u0012aB:uC\u001e,\u0017\n\u001a\u0005\u0007\u0003w\u0002AQ\u0001\r\u0002\u001dM$\u0018mZ3BiR,W\u000e\u001d;JI\"1\u0011q\u0010\u0001\u0005\u0006a\t1\u0002]1si&$\u0018n\u001c8JI\"1\u00111\u0011\u0001\u0005\u0006a\tQA[8c\u0013\u0012Da!a\"\u0001\t\u000b\t\u0017aB7fiJL7m\u001d\u0005\b\u0003\u0017\u0003AQAAG\u0003\u0015\t\u0007\u000f]%e+\t\tI\u0002C\u0004\u0002\u0012\u0002!)!!$\u0002\u0019\u0005\u0004\b/\u0011;uK6\u0004H/\u00133\t\u0019\u0005U\u0005\u00011AA\u0002\u0013\u0005A!a&\u0002\u001bQ\f7o\u001b#bi\u0006\u0014\u0015\u0010^3t+\u0005\u0019\u0006\u0002DAN\u0001\u0001\u0007\t\u0019!C\u0001\t\u0005u\u0015!\u0005;bg.$\u0015\r^1CsR,7o\u0018\u0013fcR\u0019q$a(\t\u0011\r\nI*!AA\u0002MCq!a)\u0001A\u0003&1+\u0001\buCN\\G)\u0019;b\u0005f$Xm\u001d\u0011)\u0007\u0005\u0005F\tC\u0004\u0002*\u0002!)\"a&\u0002\u0019\u001d,G\u000fV1tW\nKH/Z:\t\u000f\u00055\u0006\u0001\"\u0002\u00020\u0006\u0019!/\u001e8\u0015\u0011\u0005-\u0013\u0011WA^\u0003\u007fC\u0001\"a-\u0002,\u0002\u0007\u0011QW\u0001\u000ei\u0006\u001c8.\u0011;uK6\u0004H/\u00133\u0011\u00075\t9,C\u0002\u0002::\u0011A\u0001T8oO\"9\u0011QXAV\u0001\u0004I\u0012!D1ui\u0016l\u0007\u000f\u001e(v[\n,'\u000f\u0003\u0005\u0002B\u0006-\u0006\u0019AAb\u00035iW\r\u001e:jGN\u001c\u0016p\u001d;f[B!\u0011QYAe\u001b\t\t9MC\u0002\u0002\b\u0012IA!a3\u0002H\niQ*\u001a;sS\u000e\u001c8+_:uK6D1\"a4\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002R\u0006\tB/Y:l\u001b\u0016lwN]=NC:\fw-\u001a:\u0016\u0005\u0005M\u0007\u0003BAk\u00037l!!a6\u000b\u0007\u0005eG!\u0001\u0004nK6|'/_\u0005\u0005\u0003;\f9NA\tUCN\\W*Z7pefl\u0015M\\1hKJD1\"!9\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002d\u0006)B/Y:l\u001b\u0016lwN]=NC:\fw-\u001a:`I\u0015\fHcA\u0010\u0002f\"I1%a8\u0002\u0002\u0003\u0007\u00111\u001b\u0005\t\u0003S\u0004\u0001\u0015)\u0003\u0002T\u0006\u0011B/Y:l\u001b\u0016lwN]=NC:\fw-\u001a:!Q\r\t9\u000f\u0012\u0005\b\u0003_\u0004A\u0011AAy\u0003Q\u0019X\r\u001e+bg.lU-\\8ss6\u000bg.Y4feR\u0019q$a=\t\u0011\u0005=\u0017Q\u001ea\u0001\u0003'Dq!a>\u0001\r\u0003\tI0A\u0004sk:$\u0016m]6\u0015\t\u0005-\u00131 \u0005\t\u0003{\f)\u00101\u0001\u0002\u0000\u000691m\u001c8uKb$\b\u0003\u0002B\u0001\u0005\u0007i\u0011\u0001B\u0005\u0004\u0005\u000b!!a\u0003+bg.\u001cuN\u001c;fqRDqA!\u0003\u0001\t\u0003\u0011Y!\u0001\nqe\u00164WM\u001d:fI2{7-\u0019;j_:\u001cXC\u0001B\u0007!\u0019\u0011yAa\b\u0003&9!!\u0011\u0003B\u000e\u001d\u0011\u0011\u0019B!\u0007\u000e\u0005\tU!b\u0001B\f/\u00051AH]8pizJ\u0011aD\u0005\u0004\u0005;q\u0011a\u00029bG.\fw-Z\u0005\u0005\u0005C\u0011\u0019CA\u0002TKFT1A!\b\u000f!\rQ$qE\u0005\u0004\u0005S\u0011!\u0001\u0004+bg.dunY1uS>t\u0007\"\u0003B\u0017\u0001\u0001\u0007I\u0011\u0001B\u0018\u0003\u0015)\u0007o\\2i+\t\t)\fC\u0005\u00034\u0001\u0001\r\u0011\"\u0001\u00036\u0005IQ\r]8dQ~#S-\u001d\u000b\u0004?\t]\u0002\"C\u0012\u00032\u0005\u0005\t\u0019AA[\u0011!\u0011Y\u0004\u0001Q!\n\u0005U\u0016AB3q_\u000eD\u0007\u0005C\u0006\u0002~\u0002\u0001\r\u00111A\u0005\u0012\t}RC\u0001B!!\u0011\u0011\tAa\u0011\n\u0007\t\u0015CAA\bUCN\\7i\u001c8uKb$\u0018*\u001c9m\u0011-\u0011I\u0005\u0001a\u0001\u0002\u0004%\tBa\u0013\u0002\u0017\r|g\u000e^3yi~#S-\u001d\u000b\u0004?\t5\u0003\"C\u0012\u0003H\u0005\u0005\t\u0019\u0001B!\u0011!\u0011\t\u0006\u0001Q!\n\t\u0005\u0013\u0001C2p]R,\u0007\u0010\u001e\u0011)\u0007\t=C\tC\u0006\u0003X\u0001\u0001\r\u00111A\u0005\n\te\u0013A\u0003;bg.$\u0006N]3bIV\u0011!1\f\t\u0005\u0005;\u0012\u0019'\u0004\u0002\u0003`)\u0019!\u0011M;\u0002\t1\fgnZ\u0005\u0005\u0005K\u0012yF\u0001\u0004UQJ,\u0017\r\u001a\u0005\f\u0005S\u0002\u0001\u0019!a\u0001\n\u0013\u0011Y'\u0001\buCN\\G\u000b\u001b:fC\u0012|F%Z9\u0015\u0007}\u0011i\u0007C\u0005$\u0005O\n\t\u00111\u0001\u0003\\!A!\u0011\u000f\u0001!B\u0013\u0011Y&A\u0006uCN\\G\u000b\u001b:fC\u0012\u0004\u0003f\u0001B8\t\"\"!q\u000eB<!\ri!\u0011P\u0005\u0004\u0005wr!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0013\t}\u0004\u00011A\u0005\n\t\u0005\u0015aB0lS2dW\rZ\u000b\u0003\u0005\u0007\u00032!\u0004BC\u0013\r\u00119I\u0004\u0002\b\u0005>|G.Z1o\u0011%\u0011Y\t\u0001a\u0001\n\u0013\u0011i)A\u0006`W&dG.\u001a3`I\u0015\fHcA\u0010\u0003\u0010\"I1E!#\u0002\u0002\u0003\u0007!1\u0011\u0005\t\u0005'\u0003\u0001\u0015)\u0003\u0003\u0004\u0006Aql[5mY\u0016$\u0007\u0005K\u0002\u0003\u0012\u0012CCA!%\u0003x!I!1\u0014\u0001A\u0002\u0013E!qF\u0001\u0019?\u0016DXmY;u_J$Um]3sS\u0006d\u0017N_3US6,\u0007\"\u0003BP\u0001\u0001\u0007I\u0011\u0003BQ\u0003qyV\r_3dkR|'\u000fR3tKJL\u0017\r\\5{KRKW.Z0%KF$2a\bBR\u0011%\u0019#QTA\u0001\u0002\u0004\t)\f\u0003\u0005\u0003(\u0002\u0001\u000b\u0015BA[\u0003eyV\r_3dkR|'\u000fR3tKJL\u0017\r\\5{KRKW.\u001a\u0011\t\u0013\t-\u0006\u00011A\u0005\u0012\t=\u0012aG0fq\u0016\u001cW\u000f^8s\t\u0016\u001cXM]5bY&TXm\u00119v)&lW\rC\u0005\u00030\u0002\u0001\r\u0011\"\u0005\u00032\u0006yr,\u001a=fGV$xN\u001d#fg\u0016\u0014\u0018.\u00197ju\u0016\u001c\u0005/\u001e+j[\u0016|F%Z9\u0015\u0007}\u0011\u0019\fC\u0005$\u0005[\u000b\t\u00111\u0001\u00026\"A!q\u0017\u0001!B\u0013\t),\u0001\u000f`Kb,7-\u001e;pe\u0012+7/\u001a:jC2L'0Z\"qkRKW.\u001a\u0011\t\u000f\tm\u0006\u0001\"\u0001\u0003\u0002\u000611.\u001b7mK\u0012DqAa0\u0001\t\u0003\u0011y#A\ffq\u0016\u001cW\u000f^8s\t\u0016\u001cXM]5bY&TX\rV5nK\"9!1\u0019\u0001\u0005\u0002\t=\u0012AG3yK\u000e,Ho\u001c:EKN,'/[1mSj,7\t];US6,\u0007b\u0002Bd\u0001\u0011\u0005!\u0011Z\u0001\u001aG>dG.Z2u\u0003\u000e\u001cW/\\;mCR|'/\u00169eCR,7\u000f\u0006\u0003\u0003L\n\u0015\bC\u0002B\b\u0005?\u0011i\r\r\u0004\u0003P\nm'\u0011\u001d\t\t\u0005#\u0014)N!7\u0003`6\u0011!1\u001b\u0006\u0003i\u0012IAAa6\u0003T\ni\u0011iY2v[Vd\u0017\r^8s-J\u0002B!!\u0014\u0003\\\u0012a!Q\u001cBc\u0003\u0003\u0005\tQ!\u0001\u0002T\t\u0019q\fJ\u0019\u0011\t\u00055#\u0011\u001d\u0003\r\u0005G\u0014)-!A\u0001\u0002\u000b\u0005\u00111\u000b\u0002\u0004?\u0012\u0012\u0004B\u0003Bt\u0005\u000b\u0004\n\u00111\u0001\u0003\u0004\u0006QA/Y:l\r\u0006LG.\u001a3\t\u000f\t-\b\u0001\"\u0001\u0003n\u0006!1.\u001b7m)\ry\"q\u001e\u0005\t\u0005c\u0014I\u000f1\u0001\u0003\u0004\u0006y\u0011N\u001c;feJ,\b\u000f\u001e+ie\u0016\fG\rC\u0004\u0003v\u0002!\tBa>\u0002\u0013]\u0014\u0018\u000e^3Lef|G#B\u0010\u0003z\u000e=\u0001\u0002\u0003B~\u0005g\u0004\rA!@\u0002\t-\u0014\u0018p\u001c\t\u0005\u0005\u007f\u001cY!\u0004\u0002\u0004\u0002)!!1`B\u0002\u0015\u0011\u0019)aa\u0002\u0002!\u0015\u001cx\u000e^3sS\u000e\u001cxN\u001a;xCJ,'BAB\u0005\u0003\r\u0019w.\\\u0005\u0005\u0007\u001b\u0019\tA\u0001\u0003Lef|\u0007\u0002CB\t\u0005g\u0004\raa\u0005\u0002\r=,H\u000f];u!\u0011\u0019)ba\u0007\u000e\u0005\r]!\u0002BB\r\u0007\u0003\t!![8\n\t\ru1q\u0003\u0002\u0007\u001fV$\b/\u001e;\t\u000f\r\u0005\u0002\u0001\"\u0001\u0004$\u0005A!/Z1e\u0017JLx\u000eF\u0003 \u0007K\u00199\u0003\u0003\u0005\u0003|\u000e}\u0001\u0019\u0001B\u007f\u0011!\u0019Ica\bA\u0002\r-\u0012!B5oaV$\b\u0003BB\u000b\u0007[IAaa\f\u0004\u0018\t)\u0011J\u001c9vi\"I11\u0007\u0001\u0012\u0002\u0013\u00051QG\u0001$G>dG.Z2u\u0003\u000e\u001cW/\\;mCR|'/\u00169eCR,7\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u00199D\u000b\u0003\u0003\u0004\u000ee2FAB\u001e!\u0011\u0019ida\u0012\u000e\u0005\r}\"\u0002BB!\u0007\u0007\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r\u0015c\"\u0001\u0006b]:|G/\u0019;j_:LAa!\u0013\u0004@\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\b\u0011\r5#\u0001#\u0001\u0005\u0007\u001f\nA\u0001V1tWB\u0019!h!\u0015\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0003\u0004TM!1\u0011\u000b\u0007\u0013\u0011!\t)e!\u0015\u0005\u0002\r]CCAB(\u0011!\u0019Yf!\u0015\u0005\u0002\ru\u0013!G:fe&\fG.\u001b>f/&$\b\u000eR3qK:$WM\\2jKN$\"ba\u0018\u0004l\re4QRBI!\u0011\u0019\tga\u001a\u000e\u0005\r\r$bAB3k\u0006\u0019a.[8\n\t\r%41\r\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\u0002CB7\u00073\u0002\raa\u001c\u0002\tQ\f7o\u001b\u0019\u0005\u0007c\u001a)\b\u0005\u0003;\u0001\rM\u0004\u0003BA'\u0007k\"Aba\u001e\u0004l\u0005\u0005\t\u0011!B\u0001\u0003'\u00121a\u0018\u00134\u0011!\u0019Yh!\u0017A\u0002\ru\u0014\u0001D2veJ,g\u000e\u001e$jY\u0016\u001c\b\u0003CB@\u0007\u0013\u000bI\"!.\u000e\u0005\r\u0005%\u0002BBB\u0007\u000b\u000bq!\\;uC\ndWMC\u0002\u0004\b:\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019Yi!!\u0003\u00075\u000b\u0007\u000f\u0003\u0005\u0004\u0010\u000ee\u0003\u0019AB?\u0003-\u0019WO\u001d:f]RT\u0015M]:\t\u0011\rM5\u0011\fa\u0001\u0007+\u000b!b]3sS\u0006d\u0017N_3s!\u0011\u00199ja'\u000e\u0005\re%bABJ\t%!1QTBM\u0005I\u0019VM]5bY&TXM]%ogR\fgnY3\t\u0011\r\u00056\u0011\u000bC\u0001\u0007G\u000b1\u0004Z3tKJL\u0017\r\\5{K^KG\u000f\u001b#fa\u0016tG-\u001a8dS\u0016\u001cH\u0003BBS\u0007c\u0003\"\"DBT\u0007W\u001bY+]B0\u0013\r\u0019IK\u0004\u0002\u0007)V\u0004H.\u001a\u001b\u0011\u0011\r}4QVA\r\u0003kKAaa,\u0004\u0002\n9\u0001*Y:i\u001b\u0006\u0004\b\u0002CBZ\u0007?\u0003\raa\u0018\u0002\u001dM,'/[1mSj,G\rV1tW\"Q1qWB)#\u0003%\ta!/\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\u0011\u0019Yla0\u0016\u0005\ru&fA\u001d\u0004:\u0011A\u0011\u0011KB[\u0005\u0004\t\u0019\u0006\u0003\u0006\u0004D\u000eE\u0013\u0013!C\u0001\u0007\u000b\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*T\u0003BBd\u0007\u0017,\"a!3+\u0007)\u001bI\u0004\u0002\u0005\u0002R\r\u0005'\u0019AA*\u0011)\u0019ym!\u0015\u0012\u0002\u0013\u00051\u0011[\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\t\rM7q[\u000b\u0003\u0007+T3AYB\u001d\t!\t\tf!4C\u0002\u0005M\u0003BCBn\u0007#\n\n\u0011\"\u0001\u0004^\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uI]*Baa8\u0004dV\u00111\u0011\u001d\u0016\u0004c\u000eeB\u0001CA)\u00073\u0014\r!a\u0015\t\u0015\r\u001d8\u0011KI\u0001\n\u0003\u0019I/A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005O\u000b\u0005\u0007W\u001cy/\u0006\u0002\u0004n*\u001a\u0011d!\u000f\u0005\u0011\u0005E3Q\u001db\u0001\u0003'B!ba=\u0004RE\u0005I\u0011AB{\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%sU!1q_B~+\t\u0019IP\u000b\u0003\u0002\u0018\reB\u0001CA)\u0007c\u0014\r!a\u0015\t\u0015\r}8\u0011KI\u0001\n\u0003!\t!\u0001\u000f%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0019\u0016\t\r]H1\u0001\u0003\t\u0003#\u001aiP1\u0001\u0002T!QAqAB)\u0003\u0003%I\u0001\"\u0003\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\t\u0017\u0001BA!\u0018\u0005\u000e%!Aq\u0002B0\u0005\u0019y%M[3di\u0002")
public abstract class Task<T>
implements Serializable {
    private int _stageId;
    private int _stageAttemptId;
    private int _partitionId;
    private transient TaskData taskData;
    private Option<Broadcast<byte[]>> taskBinary;
    private TaskMetrics _metrics;
    private transient Properties localProperties;
    private int _jobId;
    private Option<String> _appId;
    private Option<String> _appAttemptId;
    private transient byte[] taskDataBytes;
    private transient TaskMemoryManager taskMemoryManager;
    private long epoch;
    private transient TaskContextImpl context;
    private volatile transient Thread taskThread;
    private volatile transient boolean _killed;
    private long _executorDeserializeTime;
    private long _executorDeserializeCpuTime;

    public static <T> Option<String> $lessinit$greater$default$10() {
        return Task$.MODULE$.$lessinit$greater$default$10();
    }

    public static <T> Option<String> $lessinit$greater$default$9() {
        return Task$.MODULE$.$lessinit$greater$default$9();
    }

    public static <T> int $lessinit$greater$default$8() {
        return Task$.MODULE$.$lessinit$greater$default$8();
    }

    public static <T> Properties $lessinit$greater$default$7() {
        return Task$.MODULE$.$lessinit$greater$default$7();
    }

    public static <T> TaskMetrics $lessinit$greater$default$6() {
        return Task$.MODULE$.$lessinit$greater$default$6();
    }

    public static <T> Option<Broadcast<byte[]>> $lessinit$greater$default$5() {
        return Task$.MODULE$.$lessinit$greater$default$5();
    }

    public static <T> TaskData $lessinit$greater$default$4() {
        return Task$.MODULE$.$lessinit$greater$default$4();
    }

    public static Tuple4<HashMap<String, Object>, HashMap<String, Object>, Properties, ByteBuffer> deserializeWithDependencies(ByteBuffer byteBuffer) {
        return Task$.MODULE$.deserializeWithDependencies(byteBuffer);
    }

    public static ByteBuffer serializeWithDependencies(Task<?> task, Map<String, Object> map2, Map<String, Object> map3, SerializerInstance serializerInstance) {
        return Task$.MODULE$.serializeWithDependencies(task, map2, map3, serializerInstance);
    }

    private int _stageId() {
        return this._stageId;
    }

    private void _stageId_$eq(int x$1) {
        this._stageId = x$1;
    }

    private int _stageAttemptId() {
        return this._stageAttemptId;
    }

    private void _stageAttemptId_$eq(int x$1) {
        this._stageAttemptId = x$1;
    }

    private int _partitionId() {
        return this._partitionId;
    }

    private void _partitionId_$eq(int x$1) {
        this._partitionId = x$1;
    }

    public TaskData taskData() {
        return this.taskData;
    }

    public void taskData_$eq(TaskData x$1) {
        this.taskData = x$1;
    }

    public Option<Broadcast<byte[]>> taskBinary() {
        return this.taskBinary;
    }

    public void taskBinary_$eq(Option<Broadcast<byte[]>> x$1) {
        this.taskBinary = x$1;
    }

    private TaskMetrics _metrics() {
        return this._metrics;
    }

    private void _metrics_$eq(TaskMetrics x$1) {
        this._metrics = x$1;
    }

    public Properties localProperties() {
        return this.localProperties;
    }

    public void localProperties_$eq(Properties x$1) {
        this.localProperties = x$1;
    }

    private int _jobId() {
        return this._jobId;
    }

    private void _jobId_$eq(int x$1) {
        this._jobId = x$1;
    }

    private Option<String> _appId() {
        return this._appId;
    }

    private void _appId_$eq(Option<String> x$1) {
        this._appId = x$1;
    }

    private Option<String> _appAttemptId() {
        return this._appAttemptId;
    }

    private void _appAttemptId_$eq(Option<String> x$1) {
        this._appAttemptId = x$1;
    }

    public final int stageId() {
        return this._stageId();
    }

    public final int stageAttemptId() {
        return this._stageAttemptId();
    }

    public final int partitionId() {
        return this._partitionId();
    }

    public final int jobId() {
        return this._jobId();
    }

    public final TaskMetrics metrics() {
        return this._metrics();
    }

    public final String appId() {
        return this._appId().isDefined() ? (String)this._appId().get() : null;
    }

    public final String appAttemptId() {
        return this._appAttemptId().isDefined() ? (String)this._appAttemptId().get() : null;
    }

    public byte[] taskDataBytes() {
        return this.taskDataBytes;
    }

    public void taskDataBytes_$eq(byte[] x$1) {
        this.taskDataBytes = x$1;
    }

    public final byte[] getTaskBytes() {
        byte[] bytes = this.taskDataBytes();
        return bytes != null && bytes.length > 0 ? bytes : (byte[])((Broadcast)this.taskBinary().get()).value();
    }

    public final T run(long taskAttemptId, int attemptNumber, MetricsSystem metricsSystem) {
        T t;
        SparkEnv$.MODULE$.get().blockManager().registerTask(taskAttemptId);
        this.context_$eq(new TaskContextImpl(this.stageId(), this.partitionId(), taskAttemptId, attemptNumber, this.taskMemoryManager(), this.localProperties(), metricsSystem, this.metrics()));
        TaskContext$.MODULE$.setTaskContext(this.context());
        this.taskThread_$eq(Thread.currentThread());
        if (this._killed()) {
            this.kill(false);
        }
        new CallerContext("TASK", this._appId(), this._appAttemptId(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.jobId())), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.stageId())), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.stageAttemptId())), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)taskAttemptId)), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)attemptNumber))).setCurrentContext();
        try {
            t = this.runTask(this.context());
            this.context().markTaskCompleted();
        }
        catch (Throwable throwable) {
            try {
                try {
                    this.context().markTaskFailed(throwable);
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                this.context().markTaskCompleted();
                try {
                    Utils$.MODULE$.tryLogNonFatalError((Function0<BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            MemoryManager memoryManager;
                            MemoryStore qual$1 = SparkEnv$.MODULE$.get().blockManager().memoryStore();
                            MemoryMode x$3 = MemoryMode.ON_HEAP;
                            long x$4 = qual$1.releaseUnrollMemoryForThisTask$default$2();
                            qual$1.releaseUnrollMemoryForThisTask(x$3, x$4);
                            MemoryStore qual$2 = SparkEnv$.MODULE$.get().blockManager().memoryStore();
                            MemoryMode x$5 = MemoryMode.OFF_HEAP;
                            long x$6 = qual$2.releaseUnrollMemoryForThisTask$default$2();
                            qual$2.releaseUnrollMemoryForThisTask(x$5, x$6);
                            MemoryManager memoryManager2 = memoryManager = SparkEnv$.MODULE$.get().memoryManager();
                            synchronized (memoryManager2) {
                                memoryManager.notifyAll();
                                return;
                            }
                        }
                    });
                }
                finally {
                    TaskContext$.MODULE$.unset();
                }
                throw throwable3;
            }
        }
        try {
            Utils$.MODULE$.tryLogNonFatalError((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */);
            return t;
        }
        finally {
            TaskContext$.MODULE$.unset();
        }
    }

    private TaskMemoryManager taskMemoryManager() {
        return this.taskMemoryManager;
    }

    private void taskMemoryManager_$eq(TaskMemoryManager x$1) {
        this.taskMemoryManager = x$1;
    }

    public void setTaskMemoryManager(TaskMemoryManager taskMemoryManager) {
        this.taskMemoryManager_$eq(taskMemoryManager);
    }

    public abstract T runTask(TaskContext var1);

    public Seq<TaskLocation> preferredLocations() {
        return Nil$.MODULE$;
    }

    public long epoch() {
        return this.epoch;
    }

    public void epoch_$eq(long x$1) {
        this.epoch = x$1;
    }

    public TaskContextImpl context() {
        return this.context;
    }

    public void context_$eq(TaskContextImpl x$1) {
        this.context = x$1;
    }

    private Thread taskThread() {
        return this.taskThread;
    }

    private void taskThread_$eq(Thread x$1) {
        this.taskThread = x$1;
    }

    private boolean _killed() {
        return this._killed;
    }

    private void _killed_$eq(boolean x$1) {
        this._killed = x$1;
    }

    public long _executorDeserializeTime() {
        return this._executorDeserializeTime;
    }

    public void _executorDeserializeTime_$eq(long x$1) {
        this._executorDeserializeTime = x$1;
    }

    public long _executorDeserializeCpuTime() {
        return this._executorDeserializeCpuTime;
    }

    public void _executorDeserializeCpuTime_$eq(long x$1) {
        this._executorDeserializeCpuTime = x$1;
    }

    public boolean killed() {
        return this._killed();
    }

    public long executorDeserializeTime() {
        return this._executorDeserializeTime();
    }

    public long executorDeserializeCpuTime() {
        return this._executorDeserializeCpuTime();
    }

    public Seq<AccumulatorV2<?, ?>> collectAccumulatorUpdates(boolean taskFailed) {
        return this.context() == null ? (Seq)Seq$.MODULE$.empty() : (Seq)((TraversableLike)this.context().taskMetrics().internalAccums().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(AccumulatorV2<?, ?> a) {
                if (!a.isZero()) return true;
                Option<String> option = a.name();
                Some some = new Some((Object)InternalAccumulator$.MODULE$.RESULT_SIZE());
                if (option == null) {
                    if (some == null) return true;
                    return false;
                } else if (option.equals((Object)some)) return true;
                return false;
            }
        })).$plus$plus((GenTraversableOnce)this.context().taskMetrics().externalAccums().filter((Function1)new Serializable(this, taskFailed){
            public static final long serialVersionUID = 0L;
            private final boolean taskFailed$1;

            public final boolean apply(AccumulatorV2<?, ?> a) {
                return !this.taskFailed$1 || a.countFailedValues();
            }
            {
                this.taskFailed$1 = taskFailed$1;
            }
        }), Seq$.MODULE$.canBuildFrom());
    }

    public boolean collectAccumulatorUpdates$default$1() {
        return false;
    }

    public void kill(boolean interruptThread) {
        this._killed_$eq(true);
        if (this.context() != null) {
            this.context().markInterrupted();
        }
        if (interruptThread && this.taskThread() != null) {
            this.taskThread().interrupt();
        }
    }

    public void writeKryo(Kryo kryo, Output output) {
        output.writeInt(this._stageId());
        output.writeVarInt(this._stageAttemptId(), true);
        output.writeVarInt(this._partitionId(), true);
        output.writeVarInt(this._jobId(), true);
        output.writeLong(this.epoch());
        output.writeLong(this._executorDeserializeTime());
        output.writeLong(this._executorDeserializeCpuTime());
        if (this.taskData() != null && this.taskData().uncompressedLen() > 0) {
            output.writeBoolean(true);
        } else {
            output.writeBoolean(false);
            kryo.writeClassAndObject(output, this.taskBinary().get());
        }
        this._metrics().write(kryo, output);
        output.writeString(this.appId());
        output.writeString(this.appAttemptId());
    }

    public void readKryo(Kryo kryo, Input input) {
        this._stageId_$eq(input.readInt());
        this._stageAttemptId_$eq(input.readVarInt(true));
        this._partitionId_$eq(input.readVarInt(true));
        this._jobId_$eq(input.readVarInt(true));
        this.epoch_$eq(input.readLong());
        this._executorDeserializeTime_$eq(input.readLong());
        this._executorDeserializeCpuTime_$eq(input.readLong());
        this.taskData_$eq(TaskData$.MODULE$.EMPTY());
        if (input.readBoolean()) {
            this.taskBinary_$eq((Option<Broadcast<byte[]>>)None$.MODULE$);
        } else {
            this.taskBinary_$eq((Option<Broadcast<byte[]>>)new Some((Object)((Broadcast)kryo.readClassAndObject(input))));
        }
        this._metrics_$eq(new TaskMetrics());
        this._metrics().read(kryo, input);
        this._appId_$eq((Option<String>)Option$.MODULE$.apply((Object)input.readString()));
        this._appAttemptId_$eq((Option<String>)Option$.MODULE$.apply((Object)input.readString()));
    }

    public Task(int _stageId, int _stageAttemptId, int _partitionId, TaskData taskData, Option<Broadcast<byte[]>> taskBinary, TaskMetrics _metrics, Properties localProperties, int _jobId, Option<String> _appId, Option<String> _appAttemptId) {
        this._stageId = _stageId;
        this._stageAttemptId = _stageAttemptId;
        this._partitionId = _partitionId;
        this.taskData = taskData;
        this.taskBinary = taskBinary;
        this._metrics = _metrics;
        this.localProperties = localProperties;
        this._jobId = _jobId;
        this._appId = _appId;
        this._appAttemptId = _appAttemptId;
        this.epoch = -1L;
        this._killed = false;
        this._executorDeserializeTime = 0L;
        this._executorDeserializeCpuTime = 0L;
    }
}

