/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.random;

import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.util.random.AcceptanceResult;
import org.apache.spark.util.random.AcceptanceResult$;
import org.apache.spark.util.random.BinomialBounds$;
import org.apache.spark.util.random.PoissonBounds$;
import org.apache.spark.util.random.StratifiedSamplingUtils;
import org.apache.spark.util.random.StratifiedSamplingUtils$;
import org.apache.spark.util.random.StratifiedSamplingUtils$$anonfun$getPoissonSamplingFunction$1$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ResizableArray;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.TraitSetter;

public final class StratifiedSamplingUtils$
implements Logging {
    public static final StratifiedSamplingUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private transient int org$apache$spark$internal$Logging$$levelFlags;

    static {
        new StratifiedSamplingUtils$();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public int org$apache$spark$internal$Logging$$levelFlags() {
        return this.org$apache$spark$internal$Logging$$levelFlags;
    }

    @Override
    public void org$apache$spark$internal$Logging$$levelFlags_$eq(int x$1) {
        this.org$apache$spark$internal$Logging$$levelFlags = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public final boolean isInfoEnabled() {
        return Logging$class.isInfoEnabled(this);
    }

    @Override
    public final boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public final boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public <K, V> scala.collection.mutable.Map<K, AcceptanceResult> getAcceptanceResults(RDD<Tuple2<K, V>> rdd, boolean withReplacement, Map<K, Object> fractions, Option<Map<K, Object>> counts, long seed) {
        Function2<scala.collection.mutable.Map<K, AcceptanceResult>, scala.collection.mutable.Map<K, AcceptanceResult>, scala.collection.mutable.Map<K, AcceptanceResult>> combOp = this.getCombOp();
        RDD mappedPartitionRDD = rdd.mapPartitionsWithIndex(new Serializable(withReplacement, fractions, counts, seed, combOp){
            public static final long serialVersionUID = 0L;
            private final boolean withReplacement$1;
            private final Map fractions$2;
            private final Option counts$1;
            private final long seed$3;
            private final Function2 combOp$1;

            public final Iterator<scala.collection.mutable.Map<K, AcceptanceResult>> apply(int x0$1, Iterator<Tuple2<K, V>> x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), x1$1);
                if (tuple2 != null) {
                    int partition = tuple2._1$mcI$sp();
                    Iterator iter = (Iterator)tuple2._2();
                    HashMap zeroU = new HashMap();
                    StratifiedSamplingUtils.RandomDataGenerator rng = new StratifiedSamplingUtils.RandomDataGenerator();
                    rng.reSeed(this.seed$3 + (long)partition);
                    Function2<scala.collection.mutable.Map<K, AcceptanceResult>, Tuple2<K, V>, scala.collection.mutable.Map<K, AcceptanceResult>> seqOp = StratifiedSamplingUtils$.MODULE$.getSeqOp(this.withReplacement$1, this.fractions$2, rng, this.counts$1);
                    Iterator iterator2 = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.mutable.Map[]{(scala.collection.mutable.Map)iter.aggregate((Function0)new Serializable(this, (scala.collection.mutable.Map)zeroU){
                        public static final long serialVersionUID = 0L;
                        private final scala.collection.mutable.Map zeroU$1;

                        public final scala.collection.mutable.Map<K, AcceptanceResult> apply() {
                            return this.zeroU$1;
                        }
                        {
                            this.zeroU$1 = zeroU$1;
                        }
                    }, seqOp, this.combOp$1)}));
                    return iterator2;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.withReplacement$1 = withReplacement$1;
                this.fractions$2 = fractions$2;
                this.counts$1 = counts$1;
                this.seed$3 = seed$3;
                this.combOp$1 = combOp$1;
            }
        }, rdd.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(scala.collection.mutable.Map.class));
        return mappedPartitionRDD.reduce(combOp);
    }

    public <K, V> Function2<scala.collection.mutable.Map<K, AcceptanceResult>, Tuple2<K, V>, scala.collection.mutable.Map<K, AcceptanceResult>> getSeqOp(boolean withReplacement, Map<K, Object> fractions, StratifiedSamplingUtils.RandomDataGenerator rng, Option<Map<K, Object>> counts) {
        double delta = 5.0E-5;
        return new Serializable(withReplacement, fractions, rng, counts, delta){
            public static final long serialVersionUID = 0L;
            private final boolean withReplacement$2;
            private final Map fractions$3;
            public final StratifiedSamplingUtils.RandomDataGenerator rng$1;
            private final Option counts$2;
            private final double delta$1;

            public final scala.collection.mutable.Map<K, AcceptanceResult> apply(scala.collection.mutable.Map<K, AcceptanceResult> result2, Tuple2<K, V> item) {
                Object object;
                Object key = item._1();
                double fraction = BoxesRunTime.unboxToDouble((Object)this.fractions$3.apply(key));
                Object object2 = result2.contains(key) ? BoxedUnit.UNIT : result2.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)new AcceptanceResult(AcceptanceResult$.MODULE$.$lessinit$greater$default$1(), AcceptanceResult$.MODULE$.$lessinit$greater$default$2())));
                AcceptanceResult acceptResult = (AcceptanceResult)result2.apply(key);
                if (this.withReplacement$2) {
                    int copiesWaitlisted;
                    double acceptBound;
                    long copiesAccepted;
                    if (acceptResult.areBoundsEmpty()) {
                        long n = BoxesRunTime.unboxToLong((Object)((MapLike)this.counts$2.get()).apply(key));
                        long sampleSize = (long)scala.math.package$.MODULE$.ceil((double)n * fraction);
                        double lmbd1 = PoissonBounds$.MODULE$.getLowerBound(sampleSize);
                        double lmbd2 = PoissonBounds$.MODULE$.getUpperBound(sampleSize);
                        acceptResult.acceptBound_$eq(lmbd1 / (double)n);
                        acceptResult.waitListBound_$eq((lmbd2 - lmbd1) / (double)n);
                    }
                    long l = copiesAccepted = (acceptBound = acceptResult.acceptBound()) == 0.0 ? 0L : (long)this.rng$1.nextPoisson(acceptBound);
                    if (copiesAccepted > 0L) {
                        acceptResult.numAccepted_$eq(acceptResult.numAccepted() + copiesAccepted);
                    }
                    object = (copiesWaitlisted = this.rng$1.nextPoisson(acceptResult.waitListBound())) > 0 ? acceptResult.waitList().$plus$plus$eq((TraversableOnce)ArrayBuffer$.MODULE$.fill(copiesWaitlisted, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.getSeqOp.1 $outer;

                        public final double apply() {
                            return this.apply$mcD$sp();
                        }

                        public double apply$mcD$sp() {
                            return this.$outer.rng$1.nextUniform();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    })) : BoxedUnit.UNIT;
                } else {
                    acceptResult.acceptBound_$eq(BinomialBounds$.MODULE$.getLowerBound(this.delta$1, acceptResult.numItems(), fraction));
                    acceptResult.waitListBound_$eq(BinomialBounds$.MODULE$.getUpperBound(this.delta$1, acceptResult.numItems(), fraction));
                    double x = this.rng$1.nextUniform();
                    if (x < acceptResult.acceptBound()) {
                        acceptResult.numAccepted_$eq(acceptResult.numAccepted() + 1L);
                        object = BoxedUnit.UNIT;
                    } else {
                        object = x < acceptResult.waitListBound() ? acceptResult.waitList().$plus$eq((Object)BoxesRunTime.boxToDouble((double)x)) : BoxedUnit.UNIT;
                    }
                }
                acceptResult.numItems_$eq(acceptResult.numItems() + 1L);
                return result2;
            }
            {
                this.withReplacement$2 = withReplacement$2;
                this.fractions$3 = fractions$3;
                this.rng$1 = rng$1;
                this.counts$2 = counts$2;
                this.delta$1 = delta$1;
            }
        };
    }

    public <K> Function2<scala.collection.mutable.Map<K, AcceptanceResult>, scala.collection.mutable.Map<K, AcceptanceResult>, scala.collection.mutable.Map<K, AcceptanceResult>> getCombOp() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.mutable.Map<K, AcceptanceResult> apply(scala.collection.mutable.Map<K, AcceptanceResult> result1, scala.collection.mutable.Map<K, AcceptanceResult> result2) {
                result1.keySet().union((GenSet)result2.keySet()).foreach((Function1)new Serializable(this, result1, result2){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.mutable.Map result1$1;
                    private final scala.collection.mutable.Map result2$1;

                    public final Object apply(K key) {
                        Object object;
                        Option entry1 = this.result1$1.get(key);
                        if (this.result2$1.contains(key)) {
                            ((AcceptanceResult)this.result2$1.apply(key)).merge((Option<AcceptanceResult>)entry1);
                            object = BoxedUnit.UNIT;
                        } else {
                            object = entry1.isDefined() ? this.result2$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), entry1.get())) : BoxedUnit.UNIT;
                        }
                        return object;
                    }
                    {
                        this.result1$1 = result1$1;
                        this.result2$1 = result2$1;
                    }
                });
                return result2;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public <K> Map<K, Object> computeThresholdByKey(Map<K, AcceptanceResult> finalResult, Map<K, Object> fractions) {
        void var3_3;
        HashMap thresholdByKey = new HashMap();
        finalResult.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<K, AcceptanceResult> check$ifrefutable$1) {
                Tuple2<K, AcceptanceResult> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(fractions, thresholdByKey){
            public static final long serialVersionUID = 0L;
            private final Map fractions$4;
            private final HashMap thresholdByKey$1;

            public final HashMap<K, Object> apply(Tuple2<K, AcceptanceResult> x$1) {
                Tuple2<K, AcceptanceResult> tuple2 = x$1;
                if (tuple2 != null) {
                    HashMap hashMap;
                    Object key = tuple2._1();
                    AcceptanceResult acceptResult = (AcceptanceResult)tuple2._2();
                    long sampleSize = (long)scala.math.package$.MODULE$.ceil((double)acceptResult.numItems() * BoxesRunTime.unboxToDouble((Object)this.fractions$4.apply(key)));
                    if (acceptResult.numAccepted() > sampleSize) {
                        StratifiedSamplingUtils$.MODULE$.logWarning((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Pre-accepted too many";
                            }
                        });
                        hashMap = this.thresholdByKey$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)BoxesRunTime.boxToDouble((double)acceptResult.acceptBound())));
                    } else {
                        int numWaitListAccepted = (int)(sampleSize - acceptResult.numAccepted());
                        if (numWaitListAccepted >= acceptResult.waitList().size()) {
                            StratifiedSamplingUtils$.MODULE$.logWarning((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "WaitList too short";
                                }
                            });
                            hashMap = this.thresholdByKey$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)BoxesRunTime.boxToDouble((double)acceptResult.waitListBound())));
                        } else {
                            hashMap = this.thresholdByKey$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), ((ResizableArray)acceptResult.waitList().sorted((Ordering)Ordering.Double$.MODULE$)).apply(numWaitListAccepted)));
                        }
                    }
                    HashMap hashMap2 = hashMap;
                    return hashMap2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.fractions$4 = fractions$4;
                this.thresholdByKey$1 = thresholdByKey$1;
            }
        });
        return var3_3;
    }

    public <K, V> Function2<Object, Iterator<Tuple2<K, V>>, Iterator<Tuple2<K, V>>> getBernoulliSamplingFunction(RDD<Tuple2<K, V>> rdd, Map<K, Object> fractions, boolean exact, long seed) {
        ObjectRef samplingRateByKey = ObjectRef.create(fractions);
        if (exact) {
            scala.collection.mutable.Map<K, AcceptanceResult> finalResult = this.getAcceptanceResults(rdd, false, fractions, (Option<Map<K, Object>>)None$.MODULE$, seed);
            samplingRateByKey.elem = this.computeThresholdByKey((Map<K, AcceptanceResult>)finalResult, fractions);
        }
        return new Serializable(seed, samplingRateByKey){
            public static final long serialVersionUID = 0L;
            private final long seed$2;
            public final ObjectRef samplingRateByKey$1;

            public final Iterator<Tuple2<K, V>> apply(int idx, Iterator<Tuple2<K, V>> iter) {
                StratifiedSamplingUtils.RandomDataGenerator rng = new StratifiedSamplingUtils.RandomDataGenerator();
                rng.reSeed(this.seed$2 + (long)idx);
                return iter.filter((Function1)new Serializable(this, rng){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getBernoulliSamplingFunction.1 $outer;
                    private final StratifiedSamplingUtils.RandomDataGenerator rng$2;

                    public final boolean apply(Tuple2<K, V> t) {
                        return this.rng$2.nextUniform() < BoxesRunTime.unboxToDouble((Object)((Map)this.$outer.samplingRateByKey$1.elem).apply(t._1()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.rng$2 = rng$2;
                    }
                });
            }
            {
                this.seed$2 = seed$2;
                this.samplingRateByKey$1 = samplingRateByKey$1;
            }
        };
    }

    public <K, V> Function2<Object, Iterator<Tuple2<K, V>>, Iterator<Tuple2<K, V>>> getPoissonSamplingFunction(RDD<Tuple2<K, V>> rdd, Map<K, Object> fractions, boolean exact, long seed, ClassTag<K> evidence$1, ClassTag<V> evidence$2) {
        Object object;
        if (exact) {
            RDD<Tuple2<K, V>> x$2 = rdd;
            ClassTag<K> x$3 = evidence$1;
            ClassTag<V> x$4 = evidence$2;
            RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$2);
            Object x$5 = null;
            Some counts = new Some(RDD$.MODULE$.rddToPairRDDFunctions(x$2, x$3, x$4, null).countByKey());
            scala.collection.mutable.Map<K, AcceptanceResult> finalResult = this.getAcceptanceResults(rdd, true, fractions, (Option<Map<K, Object>>)counts, seed);
            Map<K, Object> thresholdByKey = this.computeThresholdByKey((Map<K, AcceptanceResult>)finalResult, fractions);
            object = new Serializable(seed, finalResult, thresholdByKey){
                public static final long serialVersionUID = 0L;
                private final long seed$1;
                public final scala.collection.mutable.Map finalResult$1;
                public final Map thresholdByKey$2;

                public final Iterator<Tuple2<K, V>> apply(int idx, Iterator<Tuple2<K, V>> iter) {
                    StratifiedSamplingUtils.RandomDataGenerator rng = new StratifiedSamplingUtils.RandomDataGenerator();
                    rng.reSeed(this.seed$1 + (long)idx);
                    return iter.flatMap((Function1)new Serializable(this, rng){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.getPoissonSamplingFunction.1 $outer;
                        public final StratifiedSamplingUtils.RandomDataGenerator rng$3;

                        public final GenTraversableOnce<Tuple2<K, V>> apply(Tuple2<K, V> item) {
                            Object key = item._1();
                            double acceptBound = ((AcceptanceResult)this.$outer.finalResult$1.apply(key)).acceptBound();
                            long copiesAccepted = acceptBound == 0.0 ? 0L : (long)this.rng$3.nextPoisson(acceptBound);
                            int copiesWaitlisted = this.rng$3.nextPoisson(((AcceptanceResult)this.$outer.finalResult$1.apply(key)).waitListBound());
                            long copiesInSample = copiesAccepted + (long)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), copiesWaitlisted).count((Function1)new Serializable(this, key){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$getPoissonSamplingFunction$1$$anonfun$apply$7 $outer;
                                private final Object key$1;

                                public final boolean apply(int i) {
                                    return this.apply$mcZI$sp(i);
                                }

                                public boolean apply$mcZI$sp(int i) {
                                    return this.$outer.rng$3.nextUniform() < BoxesRunTime.unboxToDouble((Object)this.$outer.org$apache$spark$util$random$StratifiedSamplingUtils$$anonfun$$anonfun$$$outer().thresholdByKey$2.apply(this.key$1));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.key$1 = key$1;
                                }
                            });
                            return copiesInSample > 0L ? package$.MODULE$.Iterator().fill((int)copiesInSample, (Function0)new Serializable(this, item){
                                public static final long serialVersionUID = 0L;
                                private final Tuple2 item$1;

                                public final Tuple2<K, V> apply() {
                                    return this.item$1;
                                }
                                {
                                    this.item$1 = item$1;
                                }
                            }) : package$.MODULE$.Iterator().empty();
                        }

                        public /* synthetic */ anonfun.getPoissonSamplingFunction.1 org$apache$spark$util$random$StratifiedSamplingUtils$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.rng$3 = rng$3;
                        }
                    });
                }
                {
                    this.seed$1 = seed$1;
                    this.finalResult$1 = finalResult$1;
                    this.thresholdByKey$2 = thresholdByKey$2;
                }
            };
        } else {
            object = new Serializable(fractions, seed){
                public static final long serialVersionUID = 0L;
                public final Map fractions$1;
                private final long seed$1;

                public final Iterator<Tuple2<K, V>> apply(int idx, Iterator<Tuple2<K, V>> iter) {
                    StratifiedSamplingUtils.RandomDataGenerator rng = new StratifiedSamplingUtils.RandomDataGenerator();
                    rng.reSeed(this.seed$1 + (long)idx);
                    return iter.flatMap((Function1)new Serializable(this, rng){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.getPoissonSamplingFunction.2 $outer;
                        private final StratifiedSamplingUtils.RandomDataGenerator rng$4;

                        public final GenTraversableOnce<Tuple2<K, V>> apply(Tuple2<K, V> item) {
                            int count2 = this.rng$4.nextPoisson(BoxesRunTime.unboxToDouble((Object)this.$outer.fractions$1.apply(item._1())));
                            return count2 == 0 ? package$.MODULE$.Iterator().empty() : package$.MODULE$.Iterator().fill(count2, (Function0)new Serializable(this, item){
                                public static final long serialVersionUID = 0L;
                                private final Tuple2 item$2;

                                public final Tuple2<K, V> apply() {
                                    return this.item$2;
                                }
                                {
                                    this.item$2 = item$2;
                                }
                            });
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.rng$4 = rng$4;
                        }
                    });
                }
                {
                    this.fractions$1 = fractions$1;
                    this.seed$1 = seed$1;
                }
            };
        }
        return object;
    }

    private StratifiedSamplingUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

