/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection.unsafe.sort;

import com.google.common.primitives.UnsignedLongs;
import org.apache.spark.annotation.Private;
import org.apache.spark.unsafe.types.ByteArray;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.collection.unsafe.sort.PrefixComparator;

@Private
public class PrefixComparators {
    public static final PrefixComparator STRING = new UnsignedPrefixComparator();
    public static final PrefixComparator STRING_DESC = new UnsignedPrefixComparatorDesc();
    public static final PrefixComparator STRING_NULLS_LAST = new UnsignedPrefixComparatorNullsLast();
    public static final PrefixComparator STRING_DESC_NULLS_FIRST = new UnsignedPrefixComparatorDescNullsFirst();
    public static final PrefixComparator BINARY = new UnsignedPrefixComparator();
    public static final PrefixComparator BINARY_DESC = new UnsignedPrefixComparatorDesc();
    public static final PrefixComparator BINARY_NULLS_LAST = new UnsignedPrefixComparatorNullsLast();
    public static final PrefixComparator BINARY_DESC_NULLS_FIRST = new UnsignedPrefixComparatorDescNullsFirst();
    public static final PrefixComparator LONG = new SignedPrefixComparator();
    public static final PrefixComparator LONG_DESC = new SignedPrefixComparatorDesc();
    public static final PrefixComparator LONG_NULLS_LAST = new SignedPrefixComparatorNullsLast();
    public static final PrefixComparator LONG_DESC_NULLS_FIRST = new SignedPrefixComparatorDescNullsFirst();
    public static final PrefixComparator DOUBLE = new UnsignedPrefixComparator();
    public static final PrefixComparator DOUBLE_DESC = new UnsignedPrefixComparatorDesc();
    public static final PrefixComparator DOUBLE_NULLS_LAST = new UnsignedPrefixComparatorNullsLast();
    public static final PrefixComparator DOUBLE_DESC_NULLS_FIRST = new UnsignedPrefixComparatorDescNullsFirst();

    private PrefixComparators() {
    }

    public static final class SignedPrefixComparatorDesc
    extends RadixSortSupport {
        @Override
        public boolean sortDescending() {
            return true;
        }

        @Override
        public boolean sortSigned() {
            return true;
        }

        @Override
        public boolean nullsFirst() {
            return false;
        }

        @Override
        public int compare(long b, long a) {
            return a < b ? -1 : (a > b ? 1 : 0);
        }
    }

    public static final class SignedPrefixComparatorDescNullsFirst
    extends RadixSortSupport {
        @Override
        public boolean sortDescending() {
            return true;
        }

        @Override
        public boolean sortSigned() {
            return true;
        }

        @Override
        public boolean nullsFirst() {
            return true;
        }

        @Override
        public int compare(long b, long a) {
            return a < b ? -1 : (a > b ? 1 : 0);
        }
    }

    public static final class SignedPrefixComparatorNullsLast
    extends RadixSortSupport {
        @Override
        public boolean sortDescending() {
            return false;
        }

        @Override
        public boolean sortSigned() {
            return true;
        }

        @Override
        public boolean nullsFirst() {
            return false;
        }

        @Override
        public int compare(long a, long b) {
            return a < b ? -1 : (a > b ? 1 : 0);
        }
    }

    public static final class SignedPrefixComparator
    extends RadixSortSupport {
        @Override
        public boolean sortDescending() {
            return false;
        }

        @Override
        public boolean sortSigned() {
            return true;
        }

        @Override
        public boolean nullsFirst() {
            return true;
        }

        @Override
        public int compare(long a, long b) {
            return a < b ? -1 : (a > b ? 1 : 0);
        }
    }

    public static final class UnsignedPrefixComparatorDesc
    extends RadixSortSupport {
        @Override
        public boolean sortDescending() {
            return true;
        }

        @Override
        public boolean sortSigned() {
            return false;
        }

        @Override
        public boolean nullsFirst() {
            return false;
        }

        @Override
        public int compare(long bPrefix, long aPrefix) {
            return UnsignedLongs.compare((long)aPrefix, (long)bPrefix);
        }
    }

    public static final class UnsignedPrefixComparatorDescNullsFirst
    extends RadixSortSupport {
        @Override
        public boolean sortDescending() {
            return true;
        }

        @Override
        public boolean sortSigned() {
            return false;
        }

        @Override
        public boolean nullsFirst() {
            return true;
        }

        @Override
        public int compare(long bPrefix, long aPrefix) {
            return UnsignedLongs.compare((long)aPrefix, (long)bPrefix);
        }
    }

    public static final class UnsignedPrefixComparatorNullsLast
    extends RadixSortSupport {
        @Override
        public boolean sortDescending() {
            return false;
        }

        @Override
        public boolean sortSigned() {
            return false;
        }

        @Override
        public boolean nullsFirst() {
            return false;
        }

        @Override
        public int compare(long aPrefix, long bPrefix) {
            return UnsignedLongs.compare((long)aPrefix, (long)bPrefix);
        }
    }

    public static final class UnsignedPrefixComparator
    extends RadixSortSupport {
        @Override
        public boolean sortDescending() {
            return false;
        }

        @Override
        public boolean sortSigned() {
            return false;
        }

        @Override
        public boolean nullsFirst() {
            return true;
        }

        @Override
        public int compare(long aPrefix, long bPrefix) {
            return UnsignedLongs.compare((long)aPrefix, (long)bPrefix);
        }
    }

    public static abstract class RadixSortSupport
    extends PrefixComparator {
        public abstract boolean sortDescending();

        public abstract boolean sortSigned();

        public abstract boolean nullsFirst();
    }

    public static final class DoublePrefixComparator {
        public static long computePrefix(double value2) {
            long bits = Double.doubleToLongBits(value2);
            long mask = -(bits >>> 63) | Long.MIN_VALUE;
            return bits ^ mask;
        }
    }

    public static final class BinaryPrefixComparator {
        public static long computePrefix(byte[] bytes) {
            return ByteArray.getPrefix((byte[])bytes);
        }
    }

    public static final class StringPrefixComparator {
        public static long computePrefix(UTF8String value2) {
            return value2 == null ? 0L : value2.getPrefix();
        }
    }
}

